<?php
	//
	// Post Time Off Requests
	//	
	function postTimeOffRequestLkup( $requests )
	{
		//echo dpp($requests);
	
		$noChange = array( 'A', 'R' );
		$remove = array(0);
		$requestTypeIDs = array_diff($requests['requestTypeID'], $remove);                          
		$dbHandle = loginToDB();
		$countRqst = 0;
		
		foreach( $requestTypeIDs as $reqKey => $regValue ) {
			if ( $requests['requestID'][$reqKey] == 0 ) {
				$requests['requestID'][$reqKey] = getNextRequestID( $dbHandle );
			}
			$requestTypeIDArr = explode("-", $regValue);
			//echo dpp($requestTypeIDArr);
			//echo "<br />" . $requestTypeIDArr[array_key_last($requestTypeIDArr)];
			if ( $requests['numHoursRequested'][$reqKey] == 0 ) {
				continue;
			}
			else if ( in_array( $requestTypeIDArr[array_key_last($requestTypeIDArr)],  $noChange ) ) {
				if ( $requestTypeIDArr[array_key_last($requestTypeIDArr)] == "R" ) { $countRqst++; }
				continue;
			}
			else {
			
				//echo "<br /> In else loop with request type = " . $requestTypeIDArr[array_key_last($requestTypeIDArr)] . "<br />" ;
				if ( $requestTypeIDArr[array_key_last($requestTypeIDArr)] == "C" ) {
					$query = "DELETE FROM `TimeOffApproved` WHERE `RequestID`=" . $requests['requestID'][$reqKey] . "";
	
				}
				else if ( $requestTypeIDArr[array_key_last($requestTypeIDArr)] == "D" ) {
					$query = "DELETE FROM `TimeOffRequest` WHERE `RequestID`=" . $requests['requestID'][$reqKey] . "";
				} 
				else if ( $requestTypeIDArr[array_key_last($requestTypeIDArr)] == "N" ) {
					$countRqst++;
					$query  = "INSERT INTO `TimeOffRequest`(`StaffID`, `RequestID`, `RequestTypeID`, `RequestMonth`, `RequestDay`, `RequestYear`, `HoursRequested` ) VALUES ( ";
					$query .= $requests['staffID'] . ", " . $requests['requestID'][$reqKey] . ", " . $requestTypeIDArr[3] . ", ";
					$query .= $requestTypeIDArr[1] . ", " .  $requestTypeIDArr[2] . ", " . $requestTypeIDArr[0] . ", " . $requests['numHoursRequested'][$reqKey] . " ";
					$query .= " ) ";				
				} 
				//echo "<br />" . $query . "<br />" ;
				
				$result = mysqli_query( $dbHandle, $query  );
				if ( mysqli_errno( $dbHandle ) != 0 )
				{
					$rtnMsg = mysqli_error($dbHandle);          			
					if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
					closeDB( $dbHandle );
					return array( FAIL, "Unable to save time off requests: " . $rtnMsg, $countRqst  );
				}
				
			}
		}

		// Free result set
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );		
		return array( SUCCESS, "All Time Off Requests saved successfully", $countRqst );
	}
	
	
	
	//
	// Get Approved Time Off 
	//
	function getApprovedTimeOff($loginID)
	{
		$dbHandle = loginToDB();
		$vacations = array();
		
		$query  = " SELECT a.`StaffID`, a.`RequestID`, concat( a.`RequestYear`, if( a.`RequestMonth` < 10, concat('0',a.`RequestMonth`), a.`RequestMonth`), if( a.`RequestDay` < 10, concat('0',a.`RequestDay`), a.`RequestDay`) ) as RequestDay, b.`RequestTypeID`, b.`RequestName`, 'A'  as Source, a.`HoursRequested`  FROM `TimeOffApproved` a, `TimeOffRequestLkup` b WHERE a.StaffID =" .  $loginID . " AND b.`RequestTypeID` = a.`RequestTypeID`";
		
		$query  .= " ORDER BY 3";
		
		//echo $query;
		
		$result = mysqli_query( $dbHandle, $query  );

		while ($row = mysqli_fetch_assoc($result)) {
			$vacations[] = $row ;
		}

		// Free result set
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );		
		return $vacations;
	}
	
	//
	// Get Requested Time Off 
	//
	function getRequestedTimeOff($loginID)
	{
		$dbHandle = loginToDB();
		$vacations = array();
		
		$query  = " SELECT a.`StaffID`, a.`RequestID`, concat( a.`RequestYear`, if( a.`RequestMonth` < 10, concat('0',a.`RequestMonth`), a.`RequestMonth`), if( a.`RequestDay` < 10, concat('0',a.`RequestDay`), a.`RequestDay`) ) as RequestDay, b.`RequestTypeID`, b.`RequestName`, 'R'  as Source, a.`HoursRequested`  FROM `TimeOffRequest` a, `TimeOffRequestLkup` b WHERE a.StaffID =" .  $loginID . " AND b.`RequestTypeID` = a.`RequestTypeID`";
		$query  .= " ORDER BY 3";
		
		//echo $query;
		
		$result = mysqli_query( $dbHandle, $query  );

		while ($row = mysqli_fetch_assoc($result)) {
			$vacations[] = $row ;
		}

		// Free result set
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );		
		return $vacations;
	}
	
	//
	// Get Corporate Holidays
	//
	function getCorporateHolidays()
	{
		$dbHandle = loginToDB();
		$holidays = array();
		
		$query   = "SELECT concat( `Year`, if( `Month` < 10, concat('0',`Month`), `Month`), if( `Day` < 10, concat('0',`Day`), `Day`) ) as CorpHoliday, `Holiday` FROM `CorporateHolidays` WHERE `Year` between YEAR(CURDATE()) and YEAR(CURDATE())+1 ";
		$result = mysqli_query( $dbHandle, $query  );

		while ($row = mysqli_fetch_assoc($result)) {
			$holidays[] = $row['CorpHoliday'] ;
		}

		// Free result set
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );		
		return $holidays;
	}
	
	//
	// Get Staff Start Date
	//
	function getStaffStartDate( $staffID )
	{
		$dbHandle = loginToDB();
		
		$query = "SELECT `StaffHireDate` FROM `Staff` WHERE `StaffID`=" . $staffID . " ";
		$result = mysqli_query( $dbHandle, $query  );

		$row = mysqli_fetch_assoc($result);
		$startDate = $row['StaffHireDate'];
		
		// Free result set
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );	
			
		return $startDate;
	}
	
	
	function getTimeOffRequestLkup( $rqstLevel = 'S' )
	{
		$dbHandle = loginToDB();
		$requests = array();
		
		$query   = "SELECT `RequestTypeID`, `RequestName` FROM `TimeOffRequestLkup` WHERE `RequestLevel` = '" . $rqstLevel . "'";
		$result = mysqli_query( $dbHandle, $query  );

		while ($row = mysqli_fetch_assoc($result)) {
			$requests[] = $row;
		}

		// Free result set
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );		
		return $requests;
	}
	
	function getNextRequestID( $handle = NULL )
	{
		$dbHandle = ( $handle == NULL ) ? loginToDB() : $handle;
		
		$query = "SELECT IFNULL(MAX(`RequestID`), 0) + 1 AS ID FROM ( SELECT `RequestID` FROM `TimeOffRequest` UNION ALL SELECT `RequestID` FROM `TimeOffApproved` ";
		$query .= " UNION ALL SELECT `RequestID` FROM `TimeOffRejected` ) a";
		$result = mysqli_query( $dbHandle, $query  );

		$row = mysqli_fetch_assoc($result);

		// Free result set
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		if ( $handle == NULL ) {
			closeDB( $dbHandle );	
		}	
		return $row['ID'];
	}
	
	function getWeekendStatus( $staffID )
	{
		$dbHandle = loginToDB();

		$query = "SELECT b.`IsWeekendStaff` FROM `Staff` a, `StaffIndicators` b WHERE a.`StaffID`=" . $staffID . "  AND a.`StaffID`=b .`StaffID` ";
		$result = mysqli_query( $dbHandle, $query  );

		$row = mysqli_fetch_assoc($result);
		$weekendStaff = $row['IsWeekendStaff'];
		
		// Free result set
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );	
			
		return ( $weekendStaff == 'Y' );
	}
	
	function cannotRequestVacation( $ID )
	{
		$dbHandle = loginToDB();
		
		$query = "SELECT DATEDIFF(CURDATE(), StaffHireDate) as hired_days FROM `Staff` WHERE StaffID=" . $ID . " ";
		
		$result = mysqli_query( $dbHandle, $query  );

		if ( mysqli_errno( $dbHandle ) != 0 )
		{
			$rtnMsg = mysqli_error($dbHandle);          			
            if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
			return array( FAIL, $rtnMsg . "<br />" . $query );
		}
		$hireDays = mysqli_fetch_row($result);
		
		// Free result set
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		
		$query = "SELECT `HoursUsed`, `CarryOverHours`, `HoursAvailable`  FROM `TimeOffHoursUsed` WHERE `StaffID`=" . $ID . " AND CURDATE() between  `AnnivStartDate` and `AnnivEndDate` AND `RequestTypeID`=" . VACATION . " ";
		$result = mysqli_query( $dbHandle, $query  );

		if ( mysqli_errno( $dbHandle ) != 0 )
		{
			$rtnMsg = mysqli_error($dbHandle);          			
            if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
			return array( FAIL, $rtnMsg . "<br />" . $query );
		}
		$vacationDays = mysqli_fetch_row($result);
		
		// Free result set
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );		
		//return ( ( $hireDays[0] < 365 ) || ( $vacationDays[0] >= ( $vacationDays[1] + $vacationDays[2] ) ) );
		return ( ( $hireDays[0] < 365 ) || ( $vacationDays[0] >=  $vacationDays[1] ) );
		
	}
	
	function cannotRequestSick( $ID )
	{
		$dbHandle = loginToDB();
		
		$query = "SELECT `HoursUsed`, `CarryOverHours`, `HoursAvailable` FROM `TimeOffHoursUsed` WHERE `StaffID`=" . $ID . " AND CURDATE() between  `AnnivStartDate` and `AnnivEndDate` AND `RequestTypeID`=" . SICK . " ";
		
		//echo $query;
		
		$result = mysqli_query( $dbHandle, $query  );

		if ( mysqli_errno( $dbHandle ) != 0 )
		{
			$rtnMsg = mysqli_error($dbHandle);          			
            if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
			return array( FAIL, $rtnMsg . "<br />" . $query );
		}
		$sickDays = mysqli_fetch_row($result);
		
		// Free result set
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );		
		return ( $sickDays[0] >= ( $sickDays[1] + $sickDays[2] ) );
		
	}

	function getMaxSickAllowed($ID)
	{
		$dbHandle = loginToDB();
		
		$query = "SELECT `CarryOverHours` + `HoursAvailable`- `HoursUsed` AS MaxSick FROM `TimeOffHoursUsed` WHERE `StaffID`=" . $ID . " AND CURDATE() between  `AnnivStartDate` and `AnnivEndDate` AND `RequestTypeID`=" . SICK . " ";
		$result = mysqli_query( $dbHandle, $query  );

		if ( mysqli_errno( $dbHandle ) != 0 )
		{
			$rtnMsg = mysqli_error($dbHandle);          			
            if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
			return array( FAIL, $rtnMsg . "<br />" . $query );
		}
		$sickDays = mysqli_fetch_row($result);
		
		// Free result set
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );		
		return $sickDays[0];
		
	}
	
	function getMaxVacationAllowed($ID)
	{
		$dbHandle = loginToDB();
		
		//$query = "SELECT `CarryOverHours` + `HoursAvailable`- `HoursUsed` AS MaxVacation FROM `TimeOffHoursUsed` WHERE `StaffID`=" . $ID . " AND CURDATE() between  `AnnivStartDate` and `AnnivEndDate` AND `RequestTypeID`=" . VACATION . " ";
		$query = "SELECT `CarryOverHours` - `HoursUsed` AS MaxVacation FROM `TimeOffHoursUsed` WHERE `StaffID`=" . $ID . " AND CURDATE() between  `AnnivStartDate` and `AnnivEndDate` AND `RequestTypeID`=" . VACATION . " ";
		$result = mysqli_query( $dbHandle, $query  );

		if ( mysqli_errno( $dbHandle ) != 0 )
		{
			$rtnMsg = mysqli_error($dbHandle);          			
            if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
			return array( FAIL, $rtnMsg . "<br />" . $query );
		}
		$vacDays = mysqli_fetch_row($result);
		
		// Free result set
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );		
		return $vacDays[0];
		
	}
	
	function getRequestsAvailable($ID, $rqst)
	{
		$dbHandle = loginToDB();
		
		$query = "SELECT IFNULL(`CarryOverHours` + `HoursAvailable`- `HoursUsed`, 0 ) AS MaxAvailable FROM `TimeOffHoursUsed` WHERE `StaffID`=" . $ID . " AND CURDATE() between `AnnivStartDate` and `AnnivEndDate` AND `RequestTypeID`=" . $rqst . " ";
		
		$result = mysqli_query( $dbHandle, $query  );

		if ( mysqli_errno( $dbHandle ) != 0 )
		{
			$rtnMsg = mysqli_error($dbHandle);          			
            if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
			return array( FAIL, $rtnMsg . "<br />" . $query );
		}
		$availDays = mysqli_fetch_row($result);
		
		// Free result set
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );		
		return $availDays[0];
		
	}
	
	function getRequestsRequested($ID, $rqst)
	{
		$dbHandle = loginToDB();
		
		$query = "SELECT ifnull( sum(`HoursRequested`), 0 ) AS REQUESTED FROM `TimeOffRequest` where `StaffID`=" . $ID . " and `RequestYear`=YEAR(curdate()) and `RequestTypeID`=" . $rqst . " ";
		
		//echo $query;
		
		$result = mysqli_query( $dbHandle, $query  );

		if ( mysqli_errno( $dbHandle ) != 0 )
		{
			$rtnMsg = mysqli_error($dbHandle);          			
            if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
			return array( FAIL, $rtnMsg . "<br />" . $query );
		}
		$rqstDays = mysqli_fetch_row($result);
		
		// Free result set
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );		
		return $rqstDays[0];
		
	}
	
	/*
	function getStaffName( $staffID = -1 )
  	{
		$dbHandle = loginToDB();

		$query  = "select rtrim(StaffFname), coalesce(trim(StaffMInit), '' ), rtrim(StaffLname) from Staff where StaffID = " .  $staffID; 
		$result = mysqli_query( $dbHandle, $query  );
		$row = mysqli_fetch_row( $result );
				
	   // Free result set
	   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }


		closeDB( $dbHandle );
		return $row[0] . " " . (( $row[1] == '' ) ? "" : ( $row[1] . ". " )) .  $row[2];
  	}
	
	*/
	
	
?>