<?php

	function discontinueProvider( $formdata )
	{
		$dbHandle = loginToDB();
		global $CLIENTREF;
		
		$query  = "SELECT COUNT( * ) as RowCount, b.`ProviderName` FROM  `ClientsProvider` a,  `Providers` b WHERE a.`ProviderID` = b.`ProviderID` AND a.`ProviderID` = " . $formdata['providerID'] . " ";
		$result = mysqli_query( $dbHandle, $query  );
		$row = mysqli_fetch_assoc( $result );
		if ( $row['RowCount'] > 0 )
		{
						
		   // Free result set
		   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

			closeDB( $dbHandle );
			return array( FAIL, "The provider ( " . ucwords($row['ProviderName']) . " ) you are attempting to discontinue is still assigned to some " . $CLIENTREF . ". Please reassign the " . $CLIENTREF . " before you can discontinue the provider");
		}
		else {
			$query  = "SELECT b.`ProviderName` FROM  `Providers` b WHERE  b.`ProviderID` = " . $formdata['providerID'] . " ";
			$result = mysqli_query( $dbHandle, $query  );
			$row = mysqli_fetch_assoc( $result );
		}
		
		$providerName =  ucwords($row['ProviderName']);
		
		$query  = "UPDATE `Providers` SET `Discontinued`='Y' WHERE `ProviderID` = " . $formdata['providerID'] . " ";
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno( $dbHandle ) != 0 )
		{
						
		   // Free result set
		   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
	
			closeDB( $dbHandle );
			return array( FAIL, mysqli_error( $dbHandle ));
		}
						
	   // Free result set
	   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
	
	
		closeDB( $dbHandle );
		return array( SUCCESS, "Provider ( " . $providerName . " ) was successfully discontinued.");
	}


	function assignPrimaryDoctor( $formdata )
	{
		$retStr = "";
		$dbHandle    = loginToDB();
		global $CLIENTREF;
		
		for( $i = 1; $i <= 10; $i++ )
		{
			if ( isset($formdata['clientID'.$i] ) && isset($formdata['drname'.$i] ) )
			{
				$query = "REPLACE INTO `ClientsProvider`(`ClientID`, `ProviderID`) VALUES ( " . $formdata['clientID'.$i] . ", " . $formdata['drname'.$i] . " ) ";
				mysqli_query( $dbHandle, $query  );
		
				if ( mysqli_errno( $dbHandle ) != 0 )
				{
					$rtnMsg = mysqli_error($dbHandle);
          			
				   // Free result set
				   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }


					closeDB( $dbHandle );
					return array( FAIL, $rtnMsg );
				}
			}
		}
          			
	   // Free result set
	   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

		closeDB( $dbHandle );
		return array( SUCCESS, "All selected primary doctors have been assigned to their respective " . rtrim(trim($CLIENTREF), "s") );
	}
	
	function putProvider( $formdata )
	{
		$retStr = "";
		$provID = getNextID( 'Providers', 'ProviderID' );	
		$dbHandle    = loginToDB();
		
		$query = "SELECT `ProviderTypeID` FROM `ProviderTypeLkup` WHERE upper(`ProviderType`) like '%" . strtoupper( preg_replace('/\s+/', ' ', trim($formdata['specialistType'])) ) . "%'";
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno( $dbHandle ) != 0 )
		{
			$rtnMsg = mysqli_error($dbHandle);
					
		   // Free result set
		   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

			closeDB( $dbHandle );
			return array( SQLERROR, $rtnMsg );
		}
		else if ( mysqli_num_rows($result) == 0 ) { 
			if ( $formdata['providerID'] == 6 ) {
				$query = "INSERT INTO `ProviderTypeLkup`(`ProviderType`) VALUES ('" . $formdata['specialistType'] . "')";
				
				mysqli_query( $dbHandle, $query  );
			
				//echo "SQL Return Code = " . mysqli_errno( $dbHandle ) . " with error " . mysqli_error($dbHandle);
				if ( mysqli_errno( $dbHandle ) != 0 )
				{
					$rtnMsg = mysqli_error($dbHandle);
							
				   // Free result set
				   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		
					closeDB( $dbHandle );
					return array( SQLERROR, $rtnMsg );
				}
				
				$last_id = mysqli_insert_id($dbHandle);
				$formdata['providerID'] = $last_id;
			}
		}
		else {
			$row = mysqli_fetch_assoc( $result );
			$formdata['providerID'] = $row['ProviderTypeID'];
		}
			
			
		
		$query = "INSERT INTO `Providers`(`ProviderID`, `ProviderTypeID`, `ProviderName`, `ProviderAddress`, `ProviderCity`, ";        $query .= " `ProviderState`, `ProviderZip`, `ProviderPhone`, `ProviderCell`, `ProviderFax`, `ProviderEmail`) VALUES ( ";
		$query .= $provID . ", " . $formdata['providerID'] . ", ";
		$query .= "'" . sql_quote( $dbHandle,  trim( $formdata['provider'] ) ) . "', ";
		$query .= "'" . sql_quote( $dbHandle,  $formdata['address'] ) . "', ";
		$query .= "'" . sql_quote( $dbHandle,  $formdata['city'] ) . "', ";
		$query .= "'" . sql_quote( $dbHandle,  $formdata['state'] ) . "', ";
		$query .= "'" . sql_quote( $dbHandle,  $formdata['zipcode'] ) . "', ";
		$query .= "'" . sql_quote( $dbHandle,  formatPhone( $formdata['phonenum'] ) ) . "', ";
		$query .= "'" . sql_quote( $dbHandle,  formatPhone( $formdata['cellnum'] ) ) . "', ";
		$query .= "'" . sql_quote( $dbHandle,  formatPhone( $formdata['fax'] ) ) . "', ";
		$query .= "'" . sql_quote( $dbHandle,  $formdata['staffemail'] ) . "' ";
		$query .= " ) ";
		
		mysqli_query( $dbHandle, $query  );
		
		//echo "SQL Return Code = " . mysqli_errno( $dbHandle ) . " with error " . mysqli_error($dbHandle);
		if ( mysqli_errno( $dbHandle ) != 0 )
		{
			$rtnMsg = mysqli_error($dbHandle);
          			
		   // Free result set
		   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

			closeDB( $dbHandle );
			return array( FAIL, $rtnMsg );
		}
          			
	   // Free result set
	   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

		closeDB( $dbHandle );
		return array( SUCCESS, "Provider ( " . trim( $formdata['provider'] ) . " ) successfully added." );
	}
	
	function updateProvider( $formdata )
	{
		$retStr = "";
		$dbHandle    = loginToDB();
		
		$query = "replace INTO `Providers`(`ProviderID`, `ProviderTypeID`, `ProviderName`, `ProviderAddress`, `ProviderCity`, ";        $query .= " `ProviderState`, `ProviderZip`, `ProviderPhone`, `ProviderCell`, `ProviderFax`, `ProviderEmail`) VALUES ( ";
		$query .=  $formdata['providerID']  . ", " . $formdata['providerTypeID'] . ", ";
		$query .= "'" . sql_quote( $dbHandle,  trim( $formdata['provider'] ) ) . "', ";
		$query .= "'" . sql_quote( $dbHandle,  $formdata['address'] ) . "', ";
		$query .= "'" . sql_quote( $dbHandle,  $formdata['city'] ) . "', ";
		$query .= "'" . sql_quote( $dbHandle,  $formdata['state'] ) . "', ";
		$query .= "'" . sql_quote( $dbHandle,  $formdata['zipcode'] ) . "', ";
		$query .= "'" . sql_quote( $dbHandle,  formatPhone( $formdata['phonenum'] ) ) . "', ";
		$query .= "'" . sql_quote( $dbHandle,  formatPhone( $formdata['cellnum'] ) ) . "', ";
		$query .= "'" . sql_quote( $dbHandle,  formatPhone( $formdata['fax'] ) ) . "', ";
		$query .= "'" . sql_quote( $dbHandle,  $formdata['staffemail'] ) . "' ";
		$query .= " ) ";
		
		mysqli_query( $dbHandle, $query  );
		
		if ( mysqli_errno( $dbHandle ) != 0 )
		{
			$rtnMsg = mysqli_error($dbHandle);
          			
		   // Free result set
		   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

			closeDB( $dbHandle );
			return array( FAIL, $rtnMsg );
		}
          			
	   // Free result set
	   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
	   
		closeDB( $dbHandle );
		return array( SUCCESS, "Provider ( " . trim( $formdata['provider'] ) . " ) successfully updated.");
	}

?>
