<?php

	function putMedication( $formdata, $handle = false )
	{
		$medID = getNextID( 'Medications', 'MedID' );
		
		if ( $dbHandle === false ) {
			$dbHandle    = loginToDB();
		}
		else {
			$dbHandle    = $handle;
		}
		
		$query = "INSERT INTO `Medications`(`MedID`, `MedName`, `Reason-for-taking`, `MedEffects`) VALUES ( ";
		$query .= $medID . ", ";
		$query .= "'" . sql_quote( $dbHandle,  trim( $formdata['newmedname'] ) ) . "', ";
		$query .= "'" . sql_quote( $dbHandle,  $formdata['reason'] ) . "', ";
		$query .= "'" . sql_quote( $dbHandle,  $formdata['sideeffects'] ) . "' ";
		$query .= " ) ";
		
		mysqli_query( $dbHandle, $query  );
		
		if ( mysqli_errno( $dbHandle ) != 0 )
		{
			$rtnMsg = mysqli_error($dbHandle);
			
		   // Free result set
		   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

			closeDB( $dbHandle );
			return array( FAIL, $rtnMsg );
		}
          			
	   // Free result set
	   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

		closeDB( $dbHandle );
		return array( SUCCESS, "New medication ( " . $formdata['newmedname'] . " ) successfully added." );
	}
	
	function editMedication( $formdata )
	{
		global $CLIENTREF;
		$dbHandle    = loginToDB();
		
		if ( $formdata['medaction'] == 'D' ) {
			$query  = "SELECT COUNT( a.`MedID` ) as RowCount, b.`MedName` FROM  `ClientsMedications` a,  `Medications` b ";
			$query .= " WHERE a.`MedID` = b.`MedID` AND a.`MedStatus` != 'Discontinued' AND a.`MedID` = " . $formdata['medID'] . " ";
			$result = mysqli_query( $dbHandle, $query  );
			$row = mysqli_fetch_assoc( $result );
			if ( $row['RowCount'] > 0 )
			{
							
			   // Free result set
			   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
	
				closeDB( $dbHandle );
				return array( FAIL, "The medication ( " . $row['MedName'] . " ) you are attempting to delete is still assigned to some " . strtolower($CLIENTREF) . ". Please make sure  the " . strtolower($CLIENTREF) . " before you can delete the medication");
			}
		}
		
		$query  = "UPDATE `Medications` SET ";
		
		if ( $formdata['medaction'] == 'D' ) {
			$query .= " `Discontinued`='Y' "; 
			$action = ' discontinued';
		}
		else {
			$query .= " `MedName`='" . sql_quote( $dbHandle,  $formdata['newmedname'] ) . "' ";; 
			$action = ' updated';
		}
		$query .= " WHERE `MedID` = " . $formdata['medID'] . " ";
		
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno( $dbHandle ) != 0 )
		{
						
		   // Free result set
		   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			$errMsg = mysqli_error( $dbHandle );
			closeDB( $dbHandle );
			return array( FAIL, $errMsg );
		}
						
	   // Free result set
	   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
	
		
		$query  = "SELECT b.`MedName` FROM  `Medications` b WHERE  b.`MedID` = " . $formdata['medID'] . " ";
		$result = mysqli_query( $dbHandle, $query  );
		$row = mysqli_fetch_assoc( $result );
		
		
		$medName =  $row['MedName'];
		
		closeDB( $dbHandle );
		return array( SUCCESS, "Medication ( " . $medName . " ) was successfully ". $action . " .");
	}
	
	function updateClientsMedication( $formdata )
	{
		
		$dbHandle = loginToDB();
		$retStr = ""; 
		list( $cID, $mID, $seqID, $tKey, $sID ) = explode( "-", $formdata['updmedparms'] );	
		$query  = "UPDATE `ClientsMedications` SET `MedID`=" . $formdata['medID'] . ",`TimeKey`=" . getKeyFromTime($formdata['medtime']) . ",`ServiceID`=" . $formdata['programID'] . ", ";
		$query .= " `StartDate`=STR_TO_DATE('" . sql_quote( $dbHandle, $formdata['medstartdt'] ) . "', '%m/%d/%Y'),`MedTime`='" . $formdata['medtime'] . "',`MedDosage`='" . sql_quote( $dbHandle,  $formdata['meddose'] ) . "', `Direction`='" . sql_quote( $dbHandle,  $formdata['meddirection'] ) . "', `MedStatus`='" . $formdata['medstatus']  . "', ";
		$query .= " `AdminDate`=STR_TO_DATE('" . sql_quote( $dbHandle, $formdata['prescribedt'] ) . "', '%m/%d/%Y'),`MedType`=" . $formdata['medtype'] . "  ";
		$query .= " WHERE `ClientID`=" . $cID . " and `MedID`=" . $mID . " and `SeqID`=" . $seqID . " and `TimeKey`=" . $tKey . " and `ServiceID`=" . $sID . "";
		
		//echo $query;
		
		mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno( $dbHandle ) != 0 )
		{
			$rtnMsg = mysqli_error($dbHandle);
					
		   // Free result set
		   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

			closeDB( $dbHandle );
			return array( FAIL, $rtnMsg );
		}
		
	   // Free result set
	   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

		closeDB( $dbHandle );
		return array( SUCCESS, "Selected medication ( " . getMedicationName( $formdata['medID'] )  . " ) for  ( " . getClientName( $cID ) . " ) successfully updated" .  " for the " . trim( $formdata['serviceName'] ) . " service." );
	
	
	}
	
	
	function assignClientMedication( $formdata )
	{
		  $retStr = ""; 
		  $newMed = array();
		  $dbHandle = loginToDB();
		  $medID = $formdata['medID'];
		  list($sMth, $sDay,  $sYr ) = explode("/", $formdata['medstartdt']);
		  $startMthYr = "". $sYr . $sMth . "";
		  $thisMthYr = date("Ym");
		  
		  //echo "startMthYr = " . $startMthYr . " and thisMthYr = ". $thisMthYr;
		  //exit;

		  if ( $medID == -1 )
		  {
			  $retStr = putMedication( $formdata, $dbHandle );
			  if ( $retStr[0] != SUCCESS ) {
				
				// Free result set
				if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
				closeDB( $dbHandle );
				return $retStr;
			  }
			  $medID = $retStr[1];
		  }
		  
		  
		  // check if already a Clients medication, if a Clients medication get sequence from history then copy medication to history table
		  $query = "select Coalesce( max(SeqID), 0 ) from ClientsMedications where ClientID = " . $formdata['clientID'] . " and MedID = " . $medID ;
		  //. " and MedProgram = '" . $formdata['medprogram'] . "'";
		  
		  $result = mysqli_query( $dbHandle, $query  );
		  $row = mysqli_fetch_row( $result );
		  $currSeqID = $row[0];
			  
		  // get SeqID
		  $query = "select Coalesce( max(SeqID), 0 ) from ClientsMedicationsHistory where ClientID = " . $formdata['clientID'] . " and MedID = " . $medID ;

		  $result = mysqli_query( $dbHandle, $query  );
		  $row = mysqli_fetch_row( $result );
		  $histSeqID = $row[0];
		
		  if ( $currSeqID == $histSeqID && $histSeqID == 0 ) {
			$seqID = 1;
		  } 
		  else {
			$seqID = ( $currSeqID > $histSeqID ) ? ( $currSeqID + 1 ) : ( $histSeqID + 1 );
		  }
		  $timeKey = getKeyFromTime($formdata['medtime']);
		  
		  $query  = "INSERT INTO `ClientsMedications`(`ClientID`, `MedID`, `SeqID`, `TimeKey`, `ServiceID`, `StartDate`, `MedTime`, ";
		  $query .= " `MedDosage`, `Direction`, `MedStatus`, `AdminDate`, `MedType`) VALUES ( " . $formdata['clientID'] . ", "; 
	
		  $query .= $medID . ", " . $seqID . ", '" . $timeKey . "', "; 	
		  $query .=  "" . $formdata['programID'] . ", ";	 
		  $query .= "STR_TO_DATE('" . sql_quote( $dbHandle, $formdata['medstartdt'] ) . "', '%m/%d/%Y'), ";
		  $query .=  "'" . sql_quote( $dbHandle,  $formdata['medtime'] ) . "', ";			  
		  $query .=  "'" . sql_quote( $dbHandle,  $formdata['meddose'] ) . "', ";		
		  $query .=  "'" . sql_quote( $dbHandle,  $formdata['meddirection'] ) . "', ";		
		  $query .=  "'" . sql_quote( $dbHandle,  $formdata['medstatus'] ) . "', ";
		  $query .= "STR_TO_DATE('" . sql_quote( $dbHandle, $formdata['prescribedt'] ) . "', '%m/%d/%Y'), ";
		  $query .=  $formdata['medtype'] . " )";

		  //echo $query;
		  //exit;			 		  
		  mysqli_query( $dbHandle, $query  );
		  if ( mysqli_errno( $dbHandle ) == 0 )
		  {
			echo marWasInitialized( $formdata['clientID'], ltrim($sMth, '0'), $sYr, $dbHandle );
				if ( ( $startMthYr == $thisMthYr ) && 
					 ( marWasInitialized( $formdata['clientID'], ltrim($sMth, '0'), $sYr, $dbHandle ) > 0 )  )
				{
					$marinit = array();
					$marinit['clientID'] = array( 0 => $formdata['clientID'] );
					$marinit['medID'] = array( 0 => $medID );
					$marinit['seqID'] = array( 0 => $seqID );
					$marinit['timekey'] = array( 0 => $timeKey );
					$marinit['month'] = array( 0 => ltrim($sMth, '0') );
					$marinit['year'] = array( 0 => $sYr );
					$marinit['programCd'] = array( 0 => $formdata['medprogram'] );
					$marinit['medType'] = array( 0 => $formdata['medType'] );
					$marinit['startDate'] = array( 0 => $formdata['medstartdt'] );
					
					$rtn = initializeMAR( $marinit, $dbHandle );
					if ( $rtn == SUCCESS )
						$retStr = array( SUCCESS, $medID );
					else {
						$retStr = array( FAIL, "Medication assigned for Clients, but was to added to Clients's MAR for the current month. Pleasae Notify IT Support immediately." );
					}
				}
				else {
					$retStr = array( SUCCESS, $medID );
				}
		  }
		  else 
		  {
			$retStr = array( FAIL, mysqli_error($dbHandle) );
		  }
		  if ( $dbHandle !== false ) {
				
			   // Free result set
			   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			   closeDB( $dbHandle ); 
		  }
		return $retStr;
	}
		
	function deleteDiscontinueMedication( $formdata )
	{
		global $CLIENTREF;
		$dbHandle    = loginToDB();
		
		//echo dpp($formdata);
		
		for( $i = 0; $i < $formdata['numMeds']; $i++ )
		{
			if ( $formdata['selectedMedID'][$i] == 0 ) { continue; }
			if ( $formdata['medaction'] == 'D' ) {
				$query  = " UPDATE `ClientsMedications` SET  `MedStatus`='Discontinued', ";
				$query .= " `DiscontinueDate`= STR_TO_DATE( '" . $formdata['discDate'][$i] . "', '%m/%d/%Y'), ";
				$query .= " `Comment`= '" . sql_quote( $dbHandle,  $formdata['disccmnts'][$i] ) . "' ";
				$query .= " WHERE `ClientID`= " . $formdata['clientID'];
				$query .= " AND `MedID`=  " . $formdata['selectedMedID'][$i];
				$query .= " AND `SeqID`=  " . $formdata['seqID'][$i];
				$query .= " AND `TimeKey`=  '" . $formdata['timeKey'][$i] . "'";
				$query .= " AND `ServiceID`= " . $formdata['programID'];
			}
			else {
				$query  = " DELETE FROM `ClientsMedications` ";
				$query .= " WHERE `ClientID`= " . $formdata['clientID'];
				$query .= " AND `MedID`=  " . $formdata['selectedMedID'][$i];
				$query .= " AND `SeqID`=  " . $formdata['seqID'][$i];
				$query .= " AND `TimeKey`=  '" . $formdata['timeKey'][$i] . "'";
				$query .= " AND `ServiceID`= " . $formdata['programID'];
			}
			
			//echo $query;
			mysqli_query( $dbHandle, $query  );
		
			if ( mysqli_errno( $dbHandle ) != 0 )
			{
				$rtnMsg = mysqli_error($dbHandle);
						
			   // Free result set
			   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
	
				closeDB( $dbHandle );
				return array( FAIL, $rtnMsg );
			}
		}
		
		// Free result set
	   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

		closeDB( $dbHandle );
		return array( SUCCESS, "Selected medications for  ( " . trim( $formdata['clientName'] ) . " ) successfully " . (( $formdata['medaction'] == 'D' ) ? " discontinued " : " deleted " ) . " for the " . trim( $formdata['serviceName'] ) . " service." );
	}
	
	function marWasInitialized( $cID, $mth, $yr, $handle = false )
	{
		if ( $handle === false ) {
			$handle = loginToDB();
			$localConnect = true;
		}
			
		$query  = "SELECT COUNT(`ClientID`) FROM `MARDailyMedAdmin` WHERE `ClientID`= " . $cID . " AND `Month`= " . $mth . " AND `Year`=" . $yr . "";
		$result = mysqli_query( $handle, $query  );
		$row = mysqli_fetch_row( $result );
		
		// Free result set
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		if ( $localConnect === true ) {
			closeDB( $handle );
		}
				
		return $row[0];		
	}
	
	function initializeMAR( $formdata, $dbHandle = "" )
	{
		$retStr = "";
		$closeHere = ( $dbHandle == "" );
		$dbHandle  = ( $dbHandle == "" ) ? loginToDB() : $dbHandle;
		
		for( $i = 0; $i < count($formdata['clientID']); $i++ )
		{
			$query = "INSERT INTO `MARDailyMedAdmin`(`ClientID`, `MedID`, `SeqID`, `TimeKey`, `Month`, `Year`, `MedType`, `MARType`, `StartDate`) VALUES ( ";
			$query .= $formdata['clientID'][$i] . ", ";
			$query .= $formdata['medID'][$i] . ", ";
			$query .= $formdata['seqID'][$i] . ", ";
			$query .= "'" . sql_quote( $dbHandle,  $formdata['timekey'][$i] ) . "', ";
			$query .= "'" . sql_quote( $dbHandle,  $formdata['month'][$i] ) . "', ";
			$query .= "'" . sql_quote( $dbHandle,  $formdata['year'][$i] ) . "', ";
			$query .= "'" . sql_quote( $dbHandle,  $formdata['medType'][$i] ) . "', ";
			$query .= "'" . sql_quote( $dbHandle,  $formdata['programCd'][$i] ) . "',";
			$query .= "'" . sql_quote( $dbHandle,  $formdata['startDate'][$i] ) . "' )";
			
			//echo $query . "<br>";
			
			mysqli_query( $dbHandle, $query  );
	
			if ( mysqli_errno( $dbHandle ) != 0 )
			{
				//echo  $query . "<br>" . mysqli_error($dbHandle);
				$rtnMsg = mysqli_error($dbHandle);
          			
                // Free result set
                if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }


				closeDB( $dbHandle );
				return array( SQLERROR, $rtnMsg );
			}
		}
		if ( $closeHere ) {
          			
		   // Free result set
		   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

			closeDB( $dbHandle ); 
		}
		return array( SUCCESS, "" );		
	}

?>
