<?php

	//
	// Get Corporate Documents to be updated
	//
	function getVehicleList( $vID = -1 )
	{
		$dbHandle = loginToDB();
		$vehiclelist = array();
		
		$query   = "SELECT `VehiculeID`, `VehiculeYear`, `VehiculeMake`, `VehiculeModel`, `VehicleColor`, ";
		$query  .= "`EndingMileage`, `TagImage`, `InService`, `AssignedTo`, FormatDateMMDDYYYY(`TagExpiresOn`) AS TagExpiresOn, ";
		$query  .= "`VehicleVIN` FROM `VehiculeLkup`  " . ( (  $vID == -1 ) ? "" : ( " WHERE  `VehiculeID` = " . $vID ) );
 
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			$errorNumber = mysqli_errno($dbHandle);
			$errorMessage = mysqli_error($dbHandle);
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return array( FAIL, "getVehicleList() failed with Error Code: " . $errorNumber  . " and Error Message: " . $errorMessage . " " . PHP_EOL . "Please notify the administrator." );
		}
		
		while ( $row = mysqli_fetch_assoc( $result ) )
		{
			$vehiclelist[] = $row;
		}
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return array( SUCCESS, $vehiclelist );
	}
	
	function deleteVehicle( $vehicleID )
	{
		$vehicleRec = getVehicleList( $vehicleID );
		$dbHandle = loginToDB();
		
		// Delete vehicle record
		$query = "DELETE FROM `VehiculeLkup` WHERE `VehiculeID`=" . $vehicleID . "";
		
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno($dbHandle) != 0 ) {
			$errorNumber = mysqli_errno($dbHandle);
			$errorMessage = mysqli_error($dbHandle);
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
			return array( FAIL, "deleteVehicle() failed with Error Code: " . $errorNumber  . " and Error Message: " . $errorMessage . " " );
		}
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
				
		return array( SUCCESS, $vehicleRec[1][0]['VehicleColor'] .  " " . $vehicleRec[1][0]['VehiculeYear'] .  " " . $vehicleRec[1][0]['VehiculeMake'] . " " . $vehicleRec[1][0]['VehiculeModel'] . " deleted successfully." );
		
	}
	
	 
	//
	// updateVehicleInfo
	//
	function updateVehicleInfo( $vehicleRec,  $tagUpdated = false )
	{
		$dbHandle = loginToDB();
		
		if (  $tagUpdated === true ) {
			$tag_file_name = basename($_FILES['tagimage']['name']);
			$ext = strtolower(pathinfo($tag_file_name)["extension"]);
			
			$tagImage = $vehicleRec['vehicleyear'] . ucfirst(trim($vehicleRec['vehiclemake'])) . ucfirst(trim($vehicleRec['vehiclemodel'])) . "." . $ext;
		}
		
		if ( ! mysqli_begin_transaction( $dbHandle, MYSQLI_TRANS_START_READ_WRITE ) ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
						
			return array( FAIL, "Unable to begin an update transaction. Please notify the application administrator" );
		}
		
		$query    = "UPDATE `VehiculeLkup` SET ";
		$query   .= " `VehiculeYear` = " . $vehicleRec['vehicleyear'] . ", ";
		$query   .= " `VehiculeMake` = '" . sql_quote( $dbHandle, $vehicleRec['vehiclemake'] ) . "', ";
		$query   .= " `VehiculeModel` = '" . sql_quote( $dbHandle, $vehicleRec['vehiclemodel'] ) . "', ";
		$query   .= " `VehicleColor` = '" . sql_quote( $dbHandle, $vehicleRec['vehiclecolor'] ) . "', ";
		$query   .= " `VehicleVIN` = '" . sql_quote( $dbHandle, $vehicleRec['vin'] ) . "', ";
		$query   .= " `AssignedTo` = '" . $vehicleRec['vehiclehouse'] . "', ";
		$query   .= " `EndingMileage` = " . $vehicleRec['mileage'] . ", ";
		$query   .= "`TagExpiresOn` =  STR_TO_DATE( '" . $vehicleRec['tagexpiredt'] . "', '%m/%d/%Y'), ";
		if ( isset($tagUpdated) && $tagUpdated === true ) {
			$query   .= "`TagImage` = '" . sql_quote( $dbHandle, $tagImage ) . "', ";
		}
		$query   .= " `InService` = '" . $vehicleRec['inservice'] . "' WHERE `VehiculeID`=" .  $vehicleRec['vehicleID'];		
		
		//echo "<br>" . $query;
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno($dbHandle) != 0 ) {
			$errorNumber = mysqli_errno($dbHandle);
			$errorMessage = mysqli_error($dbHandle);
			mysqli_rollback($dbHandle);
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
			return array( FAIL, "updateVehicleInfo() failed with Error Code: " . $errorNumber  . " and Error Message: " . $errorMessage . " " );
		}
		
		/* If code reaches this point without errors then commit the data in the database */
		mysqli_commit($dbHandle);
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
		
		return array( SUCCESS, $vehicleRec['vehicleyear'] .  " " . $vehicleRec['vehiclemake'] . " " . $vehicleRec['vehiclemodel'] . " updated successfully." );
	}
	
	//
	// Assign Vehicle
	//
	function reassignVehicle( $vehicleRec )
	{
		$vehicleID = ( explode( ":", $vehicleRec['vehicle'] ) )[0];
		$vehicle = getVehicleList( $vehicleID );
		$house = getHouseName( $vehicleRec['vehiclehouse'] );
		
		$dbHandle = loginToDB();
		
		$query    = "UPDATE `VehiculeLkup` SET `AssignedTo`=" . $vehicleRec['vehiclehouse'] . " WHERE `VehiculeID`=" . $vehicleID;
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			$errorNumber = mysqli_errno($dbHandle);
			$errorMessage = mysqli_error($dbHandle);
			mysqli_rollback($dbHandle);
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
			return array( FAIL, "reassignVehicle() failed with Error Code: " . $errorNumber  . " and Error Message: " . $errorMessage . " " );
		}
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return array( SUCCESS, $vehicle[1][0]['VehicleColor'] . " " . $vehicle[1][0]['VehiculeYear'] . " " . $vehicle[1][0]['VehiculeMake'] . " " . $vehicle[1][0]['VehiculeModel'] . " was successfully assigned to " . $house );
		
	}
	
	//
	//  Add Vehicle
	//
	function addNewVehicle( $vehicleRec )
	{
		$vehiculeID = getNextID( 'VehiculeLkup', 'VehiculeID' );		
		$dbHandle = loginToDB();
		
		if ( isset( $_FILES) && isset($_FILES['tagimage']) && isset($_FILES['tagimage']['name']) ) {
			$tag_file_name = basename($_FILES['tagimage']['name']);
			$ext = strtolower(pathinfo($tag_file_name)["extension"]);
			
			$tagImage = $vehicleRec['vehicleyear'] . ucfirst(trim($vehicleRec['vehiclemake'])) . ucfirst(trim($vehicleRec['vehiclemodel'])) . "." . $ext;
			}
		else {
			$tagImage = 'blank.jpg';
		}
		
		if ( ! mysqli_begin_transaction( $dbHandle, MYSQLI_TRANS_START_READ_WRITE ) ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
						
			return array( FAIL, "Unable to begin an insert transaction. Please notify the application administrator" );
		}
		
		$query    = "INSERT INTO `VehiculeLkup`(`VehiculeID`, `VehiculeYear`, `VehiculeMake`, `VehiculeModel`, ";
		$query   .= " `VehicleColor`, `VehicleVIN`, `AssignedTo`, `EndingMileage`,  `TagExpiresOn`, `TagImage`, `InService`) VALUES (";
		$query   .= $vehiculeID . ", ";
		$query   .= $vehicleRec['vehicleyear'] . ", ";
		$query   .= "'" . sql_quote( $dbHandle, $vehicleRec['vehiclemake'] ) . "', ";
		$query   .= "'" . sql_quote( $dbHandle, $vehicleRec['vehiclemodel'] ) . "', ";
		$query   .= "'" . sql_quote( $dbHandle, $vehicleRec['vehiclecolor'] ) . "', ";
		$query   .= "'" . sql_quote( $dbHandle, $vehicleRec['vin'] ) . "', ";
		$query   .= "'" . $vehicleRec['vehiclehouse'] . "', ";
		$query   .= "" . $vehicleRec['mileage'] . ", ";
		$query   .= " STR_TO_DATE( '" . $vehicleRec['tagexpiredt'] . "', '%m/%d/%Y'), ";
		$query   .= "'" . sql_quote( $dbHandle, $tagImage ) . "', ";
		$query   .= "'" . $vehicleRec['inservice'] . "' ";
		$query   .= " ) ";
		
		//echo "<br>" . $query;
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno($dbHandle) != 0 ) {
			$errorNumber = mysqli_errno($dbHandle);
			$errorMessage = mysqli_error($dbHandle);
			mysqli_rollback($dbHandle);
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
			return array( FAIL, "addNewVehicle() failed with Error Code: " . $errorNumber  . " and Error Message: " . $errorMessage . " " );
		}
		
		/* If code reaches this point without errors then commit the data in the database */
		mysqli_commit($dbHandle);
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
		
		return array( SUCCESS, $vehicleRec['vehicleyear'] .  " " . $vehicleRec['vehiclemake'] . " " . $vehicleRec['vehiclemodel'] . " added successfully." );
			
	}
	
?>
