<?php
	
	//
	 // Attendance Functions
	 //
	 include( $_SERVER['DOCUMENT_ROOT'] . '/assets/db/seizure.db.php' );
	
	
	function recordResidentTemperature( $clientData )
	{
		$dbHandle = loginToDB();
		
		global $TIMEZONE;
				
		date_default_timezone_set( getTimeZone( $TIMEZONE ) );
		
		list( $tempMonth, $tempDay, $tempYear ) = explode("/", $clientData['tempdate']);
		
		for( $jj = 0; $jj < count($clientData['resident']); $jj++ ) 
		{
			if  ( ( $clientData['resident'][$jj] == '' ) or ( $clientData['tempValue'][$jj] == '' ) ) { continue; }
			
			$query = "INSERT INTO `ClientBodyTemperature`(`ClientID`, `Month`, `Year`, `TempReadingTime`, `";
			$query .= "" . ltrim($tempDay, "0") . "` ) VALUES ( ";
			$query .= $clientData['resident'][$jj]  . ", ";
			$query .= ltrim($tempMonth, "0") . ", ";
			$query .= "'" . $tempYear . "', ";
			$query .= "'" . $clientData['tempReading'] . "', ";
			$query .= $clientData['tempValue'][$jj] . " ";
			$query .= " )";
			$query .= " ON DUPLICATE KEY UPDATE ";
			$query .= "`" . ltrim($tempDay, "0") . "` = " . $clientData['tempValue'][$jj];
			
			$result = mysqli_query( $dbHandle, $query  );
			if ( mysqli_errno( $dbHandle ) != 0 )
			{
				$rtnMsg = mysqli_error($dbHandle);
						
				// Free result set
				if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
				closeDB( $dbHandle );
				return array( SQLERROR, $rtnMsg . "<br />" . $query );
			}
		}
		// Free result set
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );		
		return array( SUCCESS, "" );
	}
	
	function getNextPaymentNo( $clientID, $mth, $yr )
	{
		$dbHandle = loginToDB();
	
		$query  = "select COALESCE( max( PaymentNo ), 0 ) + 1 as PaymentNo from WeeklyAllowances ";
		$query .= " where ClientID = " . $clientID . " and Month = " . $mth . " and Year = " . $yr;
		//echo $query;
		$result = mysqli_query( $dbHandle, $query  );
		$row = mysqli_fetch_row( $result );
				
	   // Free result set
	   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

		closeDB( $dbHandle );
		return $row[0];
	}
	
	function getYTDvalues( $clientID )
	{
		$dbHandle = loginToDB();
	
		$query  = "select COALESCE( max( AmtReceivedYTD ), 0 ), COALESCE( max( AmtDueYTD ), 0 ) from WeeklyAllowances ";
		$query .= " where ClientID = " . $clientID ;
		
		$result = mysqli_query( $dbHandle, $query  );
		$row = mysqli_fetch_row( $result );
          			
                               // Free result set
                               if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }


		closeDB( $dbHandle );
		return $row;
	}
	
	function putNewAllowance( $formdata )
	{
		  $retStr = array( SUCCESS, "" );
		  $msgs = "";
		  //echo dpp($formdata);
		  
		  global $CLIENTREF;
		  
		  for ( $i = 0; $i < count($formdata['allowancedate']); $i++ )
		  {
		  
		  	  if ( ! isset( $formdata['resident'][$i] ) || $formdata['allowancedate'][$i] == '' || $formdata['todayAllowance'][$i] == '' ) { continue; }
			  
		  	  list( $mth, $day, $yr ) = explode( "/", $formdata['allowancedate'][$i] );
		  	  $paymentNo = getNextPaymentNo( $formdata['resident'][$i], $mth, $yr );
		 	  $YTDvalues = getYTDvalues( $formdata['resident'][$i] ); 
			  if ( $paymentNo <= 4 )
			  {
				  $YTDvalues = getYTDvalues( $formdata['resident'][$i] );
				  $dbHandle = loginToDB();
				  $query  = "INSERT INTO WeeklyAllowances ( ClientID, PaymentNo, Month, Year, AllowanceDate, TodayAllowance, AllowanceDue, AmtReceivedYTD, AmtDueYTD, Remarks ) ";
				  $query .= "VALUES ( "; 
				  $query .=  $formdata['resident'][$i]  . ", ";
				  $query .=  $paymentNo  . ", ";
				  $query .=  $mth  . ", ";
				  $query .=  "'" . sql_quote( $dbHandle,  $yr ) . "', ";
				  $query   .= "STR_TO_DATE('" . $formdata['allowancedate'][$i] . "', '%m/%d/%Y'),  ";
				  $query .=  $formdata['todayAllowance'][$i]  . ", ";	
				  $query .=  $formdata['allowanceDue']  . ", ";	
				  $query .=  ( $YTDvalues[0] + $formdata['todayAllowance'][$i] ) . ", ";	
				  $query .=  ( $YTDvalues[1] + $formdata['allowanceDue'] ) . ", ";	  
				  $query .=  "'" . sql_quote( $dbHandle,  $formdata['comments'][$i] ) . "' ";
				  $query .= " )";
				  //echo $query;
				  mysqli_query( $dbHandle, $query  );
				  if ( mysqli_errno( $dbHandle ) != 0 )
				  {
					$retStr = array( FAIL, mysqli_error($dbHandle) );
          			
				   // Free result set
				   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }


					closeDB( $dbHandle );
					return $retStr;
				  }
			  }
			  else
				$msgs .= "Next payment number for " . getClientName( $formdata['resident'][$i], $dbHandle)  . " is " . $paymentNo . " which is more than the 4 allowed for each combination of " . ( isset($CLIENTREF) ? rtrim(trim($CLIENTREF), "s") : '' ) . " , month and year.<br>";
		  }			
		  if ( $msgs != "" )
		  		return array( FAIL, $msgs );
				
		  return $retStr;
	}
	
	function putCriticalProblem( $formdata )
	  {
	  	  
			  $retStr = ""; 
			  $problemID = getCriticalProblemID();
			  
			  $dbHandle = loginToDB();
			  for ( $i = 0; $i < count( $formdata['client'] ); $i++ )
			  {
				  $query  = "INSERT INTO CriticalProblems (ProblemID, ClientID, IncidentDate, ProblemType, ProblemDescription, SubmittedBy, DiscussedWith, NotificationTime ) ";
				  $query .= "VALUES ( ";
				  $query .=  $problemID . ", ";
				  $query .=  $formdata['client'][$i] . ", ";
				  $query .=  "STR_TO_DATE('" . sql_quote( $dbHandle, $formdata['incidentdate'] ) . "', '%m/%d/%Y'), ";
				  $query .=  "'" . sql_quote( $dbHandle,  $formdata['problemtype'] ) . "', ";
				  $query .=  "'" . sql_quote( $dbHandle,  $formdata['problemdescription'] ) . "', ";
				  //$query .=  "'" . isset($formdata['solution']) ? sql_quote( $dbHandle,  $formdata['solution'] ) : '' . "', ";
				  $query .=  "'" . sql_quote( $dbHandle,  $formdata['staff'] ) . "', ";
				  $query .=  "'" . sql_quote( $dbHandle,  $formdata['discussedby'] ) . "', ";
				  $query .=  "'" . sql_quote( $dbHandle,  $formdata['reporttime1'] ) . "' ";
				  $query .= " )";
			  
			// echo $query;
			  
				  mysqli_query( $dbHandle, $query  );
				  if ( mysqli_errno( $dbHandle ) == 0 )
					$retStr = array( SUCCESS, $problemID );
				  else
				  {
				  	$i = count( $clients ) + 1;
					$retStr = array( FAIL, mysqli_error($dbHandle) );
				  }	
			  }
			  if ( $retStr[0] == FAIL )
			  {
			  	$query .=  "Delete from CriticalProblems where ProblemID = " . $problemID;
				mysqli_query( $dbHandle, $query  );
			  }
          			
                               // Free result set
                               if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }


		closeDB( $dbHandle );
			  return $retStr;
	  }
	  
	  /*
	  function resolveCriticalProblem( $formdata )
	  {
	  			$dbHandle = loginToDB();
				$retStr = ""; 				

	  			$query  = "update CriticalProblems set ResolvedBy = '" . sql_quote( $dbHandle,  $formdata['staff'] ) . "', ";
				  $query .= " ResolutionDate = '" . sql_quote( $dbHandle,  $formdata['resolutiondate'] ) . "', ";
				  $query .= " ResolutionDetails = '" . sql_quote( $dbHandle,  $formdata['resolutiondetails'] ) . "' ";
				  $query .= " where problemID = " . $formdata['problemID'];
				  //echo $query;
				  mysqli_query( $dbHandle, $query  );
				  if ( mysqli_errno( $dbHandle ) == 0 )
					$retStr = array( SUCCESS, "" );
				  else
					$retStr = array( FAIL, mysqli_error($dbHandle) );
          			
                               // Free result set
                               if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }


		closeDB( $dbHandle );
				  return $retStr;
		}
		*/
	
?>
