<?php
	
	//
	// Attendance Functions
	//
	include( $_SERVER['DOCUMENT_ROOT'] . '/assets/db/attendance.db.php' );
	
	function postBloodPressure( $bpRec )
	{
		$dbHandle = loginToDB();
		
		// BP Readings
		$NormalS = 90; $NormalD = 60;
		$ElevatedS = 120; $ElevatedD = 80;
		$HighS = 140; $HighD = 90;
		
		$query = "SELECT ifnull(max(`BPLogID`),0)+1 as BPLogID FROM `BloodPressureLog`";
		$result = mysqli_query( $dbHandle, $query  );
		$row = mysqli_fetch_assoc($result);
		$bpLogID = $row['BPLogID'];
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		
		// Determine Blood Pressure Staus
		$bpStatus = 'High';
		if ( $bpRec['systolic'] < $NormalS || $bpRec['diastolic'] < $NormalD ) {
			$bpStatus = 'Low';
		}
		else if ( $bpRec['systolic'] <= $ElevatedS && $bpRec['diastolic'] <= $ElevatedD ) {
			$bpStatus = 'Normal';
		}
		else if ( $bpRec['systolic'] < $HighS && $bpRec['diastolic'] < $HighD ) {
			$bpStatus = 'Elevated';
		}

		
		$query = "INSERT INTO `BloodPressureLog`(`BPLogID`, `ClientID`, `LogDate`, `LogTime`, `Systolic`, `Diastolic`, `Pulse`, `BPStatus`, `Notes`) VALUES ( ";
		$query .= $bpLogID . ", " . $bpRec['client'] . ", ";
		$query   .= " STR_TO_DATE( '" . $bpRec['bplogdate'] . "', '%m/%d/%Y'), ";
		$query .= "'" . $bpRec['bplogtime'] . "', ";
		$query .=  $bpRec['systolic'] . ", " .$bpRec['diastolic'] . ", " . $bpRec['pulse'] . ", ";
		$query .= "'" . $bpStatus . "', '" . $bpRec['notes'] . "' ";
		$query .= " )";
		
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno( $dbHandle ) != 0 )
		{
			$errMsg = "Error No: " . mysqli_errno( $dbHandle ) . " Error Message:  " . mysqli_error( $dbHandle );
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
			return array(FAIL, $errMsg );
		}
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
		return array( SUCCESS, "" );
	}
?>
