<?php
	
	//
	// Attendance Functions
	//
	include( $_SERVER['DOCUMENT_ROOT'] . '/assets/db/attendance.db.php' );
	
	function getAwakeOvernightData( $formdata )
	{
		$retStr = array();
		$dbHandle    = loginToDB();
		
		global  $monthToDigit;
		
		$query  = " SELECT awakeDate, DATE_FORMAT( awakeDate,  '%m/%d/%Y' ) , COALESCE( hour11p12a,  '0' ) , COALESCE( hour12a1a,  '0' ) , ";
		$query .= " COALESCE( hour1a2a,  '0' ) , COALESCE( hour2a3a,  '0' ) , COALESCE( hour3a4a,  '0' ) , COALESCE( hour4a5a,  '0' ) , ";
		$query .= " COALESCE( hour5a6a,  '0' ) , COALESCE( hour6a7a,  '0' ) , COALESCE( hour7a8a,  '0' ) , staffInitials ";
        $query .= " FROM AwakeOvernightChecklist WHERE clientID = " . $formdata['resident'] . " and MONTH(awakeDate) = " . $monthToDigit[$formdata['chart_month']] .  "";
		$query .= " and YEAR(awakeDate) = " . $formdata['chart_year'] . " ORDER BY clientID, awakeDate ";
		
		//echo $query;
							
		$idx = 1;
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno( $dbHandle ) == 0 )
		{
			while ( $row = mysqli_fetch_row( $result ) )
			{
				$retStr[$idx++] = $row;
			}
          			
		   // Free result set
		   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

			closeDB( $dbHandle );
			return array( SUCCESS, $retStr ); 
			
		}
		else {
			$msg =  mysqli_error($dbHandle);
          			
		   // Free result set
		   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
	
	
			closeDB( $dbHandle );
			return array( FAIL, $msg );
		}
	}
	
	function postBloodPressure( $bpRec )
	{
		$dbHandle = loginToDB();
		
		// BP Readings
		$NormalS = 90; $NormalD = 60;
		$ElevatedS = 120; $ElevatedD = 80;
		$HighS = 140; $HighD = 90;
		
		$query = "SELECT ifnull(max(`BPLogID`),0)+1 as BPLogID FROM `BloodPressureLog`";
		$result = mysqli_query( $dbHandle, $query  );
		$row = mysqli_fetch_assoc($result);
		$bpLogID = $row['BPLogID'];
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		
		// Determine Blood Pressure Staus
		$bpStatus = 'High';
		if ( $bpRec['systolic'] < $NormalS || $bpRec['diastolic'] < $NormalD ) {
			$bpStatus = 'Low';
		}
		else if ( $bpRec['systolic'] <= $ElevatedS && $bpRec['diastolic'] <= $ElevatedD ) {
			$bpStatus = 'Normal';
		}
		else if ( $bpRec['systolic'] < $HighS && $bpRec['diastolic'] < $HighD ) {
			$bpStatus = 'Elevated';
		}

		
		$query = "INSERT INTO `BloodPressureLog`(`BPLogID`, `ClientID`, `LogDate`, `LogTime`, `Systolic`, `Diastolic`, `Pulse`, `BPStatus`, `Notes`) VALUES ( ";
		$query .= $bpLogID . ", " . $bpRec['client'] . ", ";
		$query   .= " STR_TO_DATE( '" . $bpRec['bplogdate'] . "', '%m/%d/%Y'), ";
		$query .= "'" . $bpRec['bplogtime'] . "', ";
		$query .=  $bpRec['systolic'] . ", " .$bpRec['diastolic'] . ", " . $bpRec['pulse'] . ", ";
		$query .= "'" . $bpStatus . "', '" . $bpRec['notes'] . "' ";
		$query .= " )";
		
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno( $dbHandle ) != 0 )
		{
			$errMsg = "Error No: " . mysqli_errno( $dbHandle ) . " Error Message:  " . mysqli_error( $dbHandle );
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
			return array(FAIL, $errMsg );
		}
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
		return array( SUCCESS, "" );
	}
	
	function postChecklistInfo( $formdata )
	{
		$rtnArray = array();
		$dbHandle    = loginToDB();
		$numRecords = $formdata['numDays'];

		for ( $i = 1; $i <= $numRecords; $i++ )
		{
			
			$staffInit = $formdata['staffInitials-'.$i];
			if ( $formdata['hour11p12a-'.$i] == '' && $formdata['hour12a1a-'.$i] == '' && $formdata['hour1a2a-'.$i] == '' && 
			     $formdata['hour2a3a-'.$i] == '' && $formdata['hour3a4a-'.$i] == '' && $formdata['hour4a5a-'.$i] == '' && 
				 $formdata['hour5a6a-'.$i] == '' && $formdata['hour6a7a-'.$i] == '' && $formdata['hour7a8a-'.$i] == '' )
			{
				$staffInit = '';
			}
			$query  = "INSERT INTO AwakeOvernightChecklist(clientID, awakeDate, hour11p12a, hour12a1a, hour1a2a, hour2a3a, ";
			$query .= " hour3a4a, hour4a5a, hour5a6a, hour6a7a, hour7a8a, staffInitials) VALUES ( ";
			$query .=  $formdata['resident'] . ", '" . sql_quote( $dbHandle,  $formdata['awakeDate-'.$i] ) . "', ";
			$query .=  " '" . sql_quote( $dbHandle,  $formdata['hour11p12a-'.$i] ) . "', ";
			$query .=  " '" . sql_quote( $dbHandle,  $formdata['hour12a1a-'.$i] ) . "', ";
			$query .=  " '" . sql_quote( $dbHandle,  $formdata['hour1a2a-'.$i] ) . "', ";
			$query .=  " '" . sql_quote( $dbHandle,  $formdata['hour2a3a-'.$i] ) . "', ";
			$query .=  " '" . sql_quote( $dbHandle,  $formdata['hour3a4a-'.$i] ) . "', ";
			$query .=  " '" . sql_quote( $dbHandle,  $formdata['hour4a5a-'.$i] ) . "', ";
			$query .=  " '" . sql_quote( $dbHandle,  $formdata['hour5a6a-'.$i] ) . "', ";
			$query .=  " '" . sql_quote( $dbHandle,  $formdata['hour6a7a-'.$i] ) . "', ";
			$query .=  " '" . sql_quote( $dbHandle,  $formdata['hour7a8a-'.$i] ) . "', ";
			$query .=  " '" . sql_quote( $dbHandle,  $staffInit ) . "' ";
			$query .=  " ) ON DUPLICATE KEY UPDATE ";
			$query .=  " hour11p12a = '" . sql_quote( $dbHandle,  $formdata['hour11p12a-'.$i] ) . "', ";
			$query .=  " hour12a1a = '" . sql_quote( $dbHandle,  $formdata['hour12a1a-'.$i] ) . "', ";
			$query .=  " hour1a2a = '" . sql_quote( $dbHandle,  $formdata['hour1a2a-'.$i] ) . "', ";
			$query .=  " hour2a3a = '" . sql_quote( $dbHandle,  $formdata['hour2a3a-'.$i] ) . "', ";
			$query .=  " hour3a4a = '" . sql_quote( $dbHandle,  $formdata['hour3a4a-'.$i] ) . "', ";
			$query .=  " hour4a5a = '" . sql_quote( $dbHandle,  $formdata['hour4a5a-'.$i] ) . "', ";
			$query .=  " hour5a6a = '" . sql_quote( $dbHandle,  $formdata['hour5a6a-'.$i] ) . "', ";
			$query .=  " hour6a7a = '" . sql_quote( $dbHandle,  $formdata['hour6a7a-'.$i] ) . "', ";
			$query .=  " hour7a8a = '" . sql_quote( $dbHandle,  $formdata['hour7a8a-'.$i] ) . "', ";
			$query .=  " staffInitials = '" . sql_quote( $dbHandle,  $staffInit ) . "' ";
						
			mysqli_query( $dbHandle, $query  );
			if ( mysqli_errno( $dbHandle ) != 0 )
			{
				$rtnMsg = mysqli_error($dbHandle);
          			
			   // Free result set
			   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

				closeDB( $dbHandle );
				return array( SQLERROR, $rtnMsg );
			}
		}
          			
	   // Free result set
	   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

		closeDB( $dbHandle );
		return array( SUCCESS, "Awake Overnight Checklist for " . getClientName( $formdata['resident'] ) . " successfully saved." );
		
	}
	
	function getActivityChartingData( $formdata, $chooseDay = 0 )
	{
		global $monthToDigit;
		
		//echo dpp($formdata);
		
		$retStr = array();
		$dbHandle    = loginToDB();
		
		$dataTables = array( 0 => "`DayActivityCharting`", "DayHabilitationActivityCharting", "`PersonalSupportActivityCharting`", "`EmploymentServicesActivityCharting`" );
		
		$query  = " SELECT activityDate, DATE_FORMAT( activityDate,  '%m/%d/%Y' ) ,  ";
		$query .= " startTime, endTime, activityChartingID, ";
		//if ($chooseDay == 1 ) {
		//	$query .= " participation, activityStaff, ";
		//}
		//else {
			$query .= " comments, ";
		//}
		$query .= " staffInitials, startTimeID, endTimeID  ";
        $query .= " FROM " . $dataTables[$chooseDay] . " WHERE clientID = " . $formdata['resident'] . " and MONTH(activityDate) = " . $formdata['chart_month'] .  "";
		$query .= " and YEAR(activityDate) = " . $formdata['chart_year'] . " ORDER BY clientID, activityDate ";
			
		//echo $query;			
		//exit;
			
		$idx = 1;
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno( $dbHandle ) == 0 )
		{
			while ( $row = mysqli_fetch_row( $result ) )
			{
				$retStr[$idx++] = $row;
			}
          			
		   // Free result set
		   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }


			closeDB( $dbHandle );
			return array( SUCCESS, $retStr ); 
			
		}
		else {
			$msg =  mysqli_error($dbHandle);
          			
		   // Free result set
		   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }


			closeDB( $dbHandle );
			return array( FAIL, $msg );
		}
	}
	
	function getESActivityChartingData( $formdata )
	{
		
		$retStr = array();
		
		
		if( isset($formdata['ClientID']) ) 
		{
			$dbHandle    = loginToDB();
			
			if ( $formdata['reportType'] == 'W' ) { 
				list( $startDate, $endDate ) = explode( " - ", $formdata['weekdate'] );
				list($sm, $sd, $sy ) = explode( "/", $startDate );
				list($em, $ed, $ey ) = explode( "/", $endDate );
			}
			else {
				list($sm, $sy ) = explode( "/", $formdata['monthdate'] );
				$sd = 1;
				$em = $sm;
				$ed = cal_days_in_month( CAL_GREGORIAN, intval($sm), intval($sy) );  
				$ey = $sy;
			}
			
			$startDate = implode( "-", array( $sy, $sm, $sd ) );
			$endDate = implode( "-", array( $ey, $em, $ed ) );
			
			//echo "StartDate = " . $startDate . " Enddate = ". $endDate;
			
			$query  = " SELECT activityDate, DATE_FORMAT( activityDate,  '%W - %m/%d/%Y' ) ,  ";
			$query .= " startTime, endTime, activityChartingID, comments, staffInitials, startTimeID  ";
			$query .= " FROM `EmploymentServicesActivityCharting` WHERE clientID = " . $formdata['ClientID'] . " and activityDate between ";
			$query .=  "'" . $startDate . "' and '" . $endDate . "'";
			$query .= " ORDER BY clientID, activityDate, startTimeID";
				
			//echo $query;				
			$idx = 1;
			$result = mysqli_query( $dbHandle, $query  );
			if ( mysqli_errno( $dbHandle ) == 0 )
			{
				while ( $row = mysqli_fetch_row( $result ) )
				{
					$retStr[$idx++] = $row;
				}
						
			   // Free result set
			   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
	
	
				closeDB( $dbHandle );
				return array( SUCCESS, $retStr ); 
				
			}
			else {
				$msg =  mysqli_error($dbHandle);
						
			   // Free result set
			   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
	
	
				closeDB( $dbHandle );
				return array( FAIL, $msg );
			}
		}
	}
	
	function getPSActivityChartingData( $formdata )
	{
		
		$retStr = array();
		
		
		if( isset($formdata['ClientID']) ) 
		{
			$dbHandle    = loginToDB();
			
			if ( $formdata['reportType'] == 'W' ) { 
				list( $startDate, $endDate ) = explode( " - ", $formdata['weekdate'] );
				list($sm, $sd, $sy ) = explode( "/", $startDate );
				list($em, $ed, $ey ) = explode( "/", $endDate );
			}
			else {
				list($sm, $sy ) = explode( "/", $formdata['monthdate'] );
				$sd = 1;
				$em = $sm;
				$ed = cal_days_in_month( CAL_GREGORIAN, intval($sm), intval($sy) );  
				$ey = $sy;
			}
		
			
			$startDate = implode( "-", array( $sy, $sm, $sd ) );
			$endDate = implode( "-", array( $ey, $em, $ed ) );
			
			//echo "StartDate = " . $startDate . " Enddate = ". $endDate;
			
			$query  = " SELECT activityDate, DATE_FORMAT( activityDate,  '%W - %m/%d/%Y' ) ,  ";
			$query .= " startTime, endTime, activityChartingID, comments, staffInitials, startTimeID  ";
			$query .= " FROM `PersonalSupportActivityCharting` WHERE clientID = " . $formdata['ClientID'] . " and activityDate between ";
			$query .=  "'" . $startDate . "' and '" . $endDate . "'";
			$query .= " ORDER BY clientID, activityDate, startTimeID";
				
			//echo $query;				
			
			$idx = 1;
			$result = mysqli_query( $dbHandle, $query  );
			if ( mysqli_errno( $dbHandle ) == 0 )
			{
				while ( $row = mysqli_fetch_row( $result ) )
				{
					$retStr[$idx++] = $row;
				}
						
			   // Free result set
			   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
	
	
				closeDB( $dbHandle );
				return array( SUCCESS, $retStr ); 
				
			}
			else {
				$msg =  mysqli_error($dbHandle);
						
			   // Free result set
			   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
	
	
				closeDB( $dbHandle );
				return array( FAIL, $msg );
			}
		}
	}
	
	function getActivityChartingOptions( $es = false )
	{
		$rtnArray = array();
		$dbHandle    = loginToDB();
		$query  = "SELECT activityChartingID, chartingItem FROM " . ( ( $es === true ) ? ' ActivityChartingForES_Lkup ' : ' ActivityChartingLkup ' ) . " order by chartingItem";
				
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno( $dbHandle ) == 0 )
		{
			while ( $row = mysqli_fetch_row( $result ) )
			{
				$retStr[$row[0]] = $row[1];
			}
          			
		   // Free result set
		   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

			closeDB( $dbHandle );
			return $retStr; 			
		}
	}
	
	function postDayChartingInfo( $formdata )
	{
		$rtnArray = array();
		$dbHandle    = loginToDB();

		//for ( $i = 1; $i <= $numRows; $i++ )
		foreach ( $formdata['row'] as $dataKey => $dataValues )
		{
			//echo 'comments = ' . $formdata['comments'] . '<br>';
			$staffInit = $dataValues['postingStaff'];
			if ( trim($dataValues['activityDate']) == '' || trim($dataValues['activityStartTime']) == '' || trim($dataValues['activityEndTime']) == '' || 
			     trim($dataValues['activity']) == '' || trim($dataValues['comments']) == ''  )								
			{
				//insert blank rows with no staff initials
				$staffInit = '';
				continue;
			}
			//echo dpp($formdata[$i]);

			// Check for overlapping activities

			$query  = "select count(*) from DayActivityCharting where clientID = " . $formdata['resident'] . " and activityDate = '" . sql_quote( $dbHandle,  dbDateFormat($dataValues['activityDate'] )) . "' ";
			$query .= " and ( " . $dataValues['startTimeID'] . " between ( startTimeID + 1 ) and ( endTimeID - 1 ) or "  . $dataValues['endTimeID'] . " between ( startTimeID + 1 ) and ( endTimeID - 1 ) )";
			
			//echo $query;
			//exit;
			
			mysqli_query( $dbHandle, $query  );
			if ( mysqli_errno( $dbHandle ) != 0 )
			{
				
			   // Free result set
			   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }


				closeDB( $dbHandle );
				return array( SQLERROR, "postDayChartingInfo Failed:  system was unable to determine whether or not activities overlapped." );
			}
			else {
				$result = mysqli_query( $dbHandle, $query  );
				$row = mysqli_fetch_row( $result );
				if ( $row[0] > 0 )
				{
				
					// Free result set
					if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

					closeDB( $dbHandle );
					return array( OVERLAP, "postDayChartingInfo Failed:  activity you are attempting to post for " .
											$dataValues['activityDate'] . " between " . $dataValues['activityStartTime'] . " and " . $dataValues['activityEndTime'] .
											" overlapps with another posted activity. Please check activity date/time and correct." );
				}
			}

			
			$query  = "INSERT INTO DayActivityCharting(clientID, activityDate, startTimeID, endTimeID, startTime, endTime, activityChartingID, comments, staffInitials ) VALUES ( ";
			$query .=  $formdata['resident'] . ", '" . sql_quote( $dbHandle,  dbDateFormat($dataValues['activityDate'] )) . "', ";
			$query .=  $dataValues['startTimeID'] . ", " . $dataValues['endTimeID'] . ", ";
			$query .=  " '" . sql_quote( $dbHandle,  $dataValues['activityStartTime'] ) . "', ";
			$query .=  " '" . sql_quote( $dbHandle,  $dataValues['activityEndTime'] ) . "', ";
			$query .=  " " . $dataValues['activity'] . ", ";
			$query .=  " '" . sql_quote( $dbHandle,  $dataValues['comments'] ) . "', ";
			$query .=  " '" . sql_quote( $dbHandle,  $staffInit ) . "' ";
			$query .=  " ) ON DUPLICATE KEY UPDATE ";
			$query .=  " startTime = '" . sql_quote( $dbHandle,  $dataValues['activityStartTime'] ) . "', ";
			$query .=  " endTime = '" . sql_quote( $dbHandle,  $dataValues['activityEndTime'] ) . "', ";
			$query .=  " activityChartingID = " .  $dataValues['activity']  . ", ";
			$query .=  " comments = '" . sql_quote( $dbHandle,  $dataValues['comments'] ) . "', ";
			$query .=  " staffInitials = '" . sql_quote( $dbHandle,  $staffInit ) . "' ";
			
			//echo "<br><br>Query is " . $query;
			//exit;
			
			mysqli_query( $dbHandle, $query  );
			if ( mysqli_errno( $dbHandle ) != 0 )
			{
				$rtnMsg = mysqli_error($dbHandle);
          			
			   // Free result set
			   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

				closeDB( $dbHandle );
				return array( SQLERROR, $rtnMsg );
			}
		}
          			
	   // Free result set
	   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

		closeDB( $dbHandle );
		return array( SUCCESS, "Dailyy Activity Charting for " . getClientName( $formdata['resident'] ) . " successfully saved." );

	}
	
	//=============================
	
	function postDHChartingInfo( $formdata )
	{
		$rtnArray = array();
		$dbHandle    = loginToDB();

		//for ( $i = 1; $i <= $numRows; $i++ )
		foreach ( $formdata['row'] as $dataKey => $dataValues )
		{
			//echo 'comments = ' . $formdata['comments'] . '<br>';
			$staffInit = $dataValues['postingStaff'];
			if ( trim($dataValues['activityDate']) == '' || trim($dataValues['activityStartTime']) == '' || trim($dataValues['activityEndTime']) == '' || 
			     trim($dataValues['activity']) == '' || trim($dataValues['comments']) == ''  )								
			{
				//insert blank rows with no staff initials
				$staffInit = '';
				continue;
			}
			//echo dpp($formdata[$i]);

			// Check for overlapping activities

			$query  = "select count(*) from DayHabilitationActivityCharting where clientID = " . $formdata['resident'] . " and activityDate = '" . sql_quote( $dbHandle,  dbDateFormat($dataValues['activityDate'] )) . "' ";
			$query .= " and ( " . $dataValues['startTimeID'] . " between ( startTimeID + 1 ) and ( endTimeID - 1 ) or "  . $dataValues['endTimeID'] . " between ( startTimeID + 1 ) and ( endTimeID - 1 ) )";
			
			//echo $query;
			//exit;
			
			mysqli_query( $dbHandle, $query  );
			if ( mysqli_errno( $dbHandle ) != 0 )
			{
				
			   // Free result set
			   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }


				closeDB( $dbHandle );
				return array( SQLERROR, "postDHChartingInfo Failed:  system was unable to determine whether or not activities overlapped." );
			}
			else {
				$result = mysqli_query( $dbHandle, $query  );
				$row = mysqli_fetch_row( $result );
				if ( $row[0] > 0 )
				{
				
					// Free result set
					if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

					closeDB( $dbHandle );
					return array( OVERLAP, "postDHChartingInfo Failed:  activity you are attempting to post for " .
											$dataValues['activityDate'] . " between " . $dataValues['activityStartTime'] . " and " . $dataValues['activityEndTime'] .
											" overlapps with another posted activity. Please check activity date/time and correct." );
				}
			}

			
			$query  = "INSERT INTO DayHabilitationActivityCharting(clientID, activityDate, startTimeID, endTimeID, startTime, endTime, activityChartingID, comments, staffInitials ) VALUES ( ";
			$query .=  $formdata['resident'] . ", '" . sql_quote( $dbHandle,  dbDateFormat($dataValues['activityDate'] )) . "', ";
			$query .=  $dataValues['startTimeID'] . ", " . $dataValues['endTimeID'] . ", ";
			$query .=  " '" . sql_quote( $dbHandle,  $dataValues['activityStartTime'] ) . "', ";
			$query .=  " '" . sql_quote( $dbHandle,  $dataValues['activityEndTime'] ) . "', ";
			$query .=  " " . $dataValues['activity'] . ", ";
			$query .=  " '" . sql_quote( $dbHandle,  $dataValues['comments'] ) . "', ";
			$query .=  " '" . sql_quote( $dbHandle,  $staffInit ) . "' ";
			$query .=  " ) ON DUPLICATE KEY UPDATE ";
			$query .=  " startTime = '" . sql_quote( $dbHandle,  $dataValues['activityStartTime'] ) . "', ";
			$query .=  " endTime = '" . sql_quote( $dbHandle,  $dataValues['activityEndTime'] ) . "', ";
			$query .=  " activityChartingID = " .  $dataValues['activity']  . ", ";
			$query .=  " comments = '" . sql_quote( $dbHandle,  $dataValues['comments'] ) . "', ";
			$query .=  " staffInitials = '" . sql_quote( $dbHandle,  $staffInit ) . "' ";
			
			//echo "<br><br>Query is " . $query;
			//exit;
			
			mysqli_query( $dbHandle, $query  );
			if ( mysqli_errno( $dbHandle ) != 0 )
			{
				$rtnMsg = mysqli_error($dbHandle);
          			
			   // Free result set
			   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

				closeDB( $dbHandle );
				return array( SQLERROR, $rtnMsg );
			}
		}
          			
	   // Free result set
	   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

		closeDB( $dbHandle );
		return array( SUCCESS, "Day Habilitation Activity Charting for " . getClientName( $formdata['resident'] ) . " successfully saved." );

	}
	
	// ============================
	function postPSChartingInfo( $formdata )
	{
		$rtnArray = array();
		$dbHandle    = loginToDB();

		//for ( $i = 1; $i <= $numRows; $i++ )
		foreach ( $formdata['row'] as $dataKey => $dataValues )
		{
			//echo 'comments = ' . $formdata['comments'] . '<br>';
			$staffInit = $dataValues['postingStaff'];
			if ( trim($dataValues['activityDate']) == '' || trim($dataValues['activityStartTime']) == '' || trim($dataValues['activityEndTime']) == '' || 
			     trim($dataValues['activity']) == '' || trim($dataValues['comments']) == ''  )								
			{
				//insert blank rows with no staff initials
				$staffInit = '';
				continue;
			}
			//echo dpp($formdata[$i]);

			// Check for overlapping activities

			$query  = "select count(*) from PersonalSupportActivityCharting where clientID = " . $formdata['resident'] . " and activityDate = '" . sql_quote( $dbHandle,  dbDateFormat($dataValues['activityDate'] )) . "' ";
			$query .= " and ( " . $dataValues['startTimeID'] . " between ( startTimeID + 1 ) and ( endTimeID - 1 ) or "  . $dataValues['endTimeID'] . " between ( startTimeID + 1 ) and ( endTimeID - 1 ) )";
			
			//echo $query;
			//exit;
			
			mysqli_query( $dbHandle, $query  );
			if ( mysqli_errno( $dbHandle ) != 0 )
			{
				
			   // Free result set
			   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }


				closeDB( $dbHandle );
				return array( SQLERROR, "postPSChartingInfo Failed:  system was unable to determine whether or not activities overlapped." );
			}
			else {
				$result = mysqli_query( $dbHandle, $query  );
				$row = mysqli_fetch_row( $result );
				if ( $row[0] > 0 )
				{
				
					// Free result set
					if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

					closeDB( $dbHandle );
					return array( OVERLAP, "postPSChartingInfo Failed:  activity you are attempting to post for " .
											$dataValues['activityDate'] . " between " . $dataValues['activityStartTime'] . " and " . $dataValues['activityEndTime'] .
											" overlapps with another posted activity. Please check activity date/time and correct." );
				}
			}

			
			$query  = "INSERT INTO PersonalSupportActivityCharting(clientID, activityDate, startTimeID, endTimeID, startTime, endTime, activityChartingID, comments, staffInitials ) VALUES ( ";
			$query .=  $formdata['resident'] . ", '" . sql_quote( $dbHandle,  dbDateFormat($dataValues['activityDate'] )) . "', ";
			$query .=  $dataValues['startTimeID'] . ", " . $dataValues['endTimeID'] . ", ";
			$query .=  " '" . sql_quote( $dbHandle,  $dataValues['activityStartTime'] ) . "', ";
			$query .=  " '" . sql_quote( $dbHandle,  $dataValues['activityEndTime'] ) . "', ";
			$query .=  " " . $dataValues['activity'] . ", ";
			$query .=  " '" . sql_quote( $dbHandle,  $dataValues['comments'] ) . "', ";
			$query .=  " '" . sql_quote( $dbHandle,  $staffInit ) . "' ";
			$query .=  " ) ON DUPLICATE KEY UPDATE ";
			$query .=  " startTime = '" . sql_quote( $dbHandle,  $dataValues['activityStartTime'] ) . "', ";
			$query .=  " endTime = '" . sql_quote( $dbHandle,  $dataValues['activityEndTime'] ) . "', ";
			$query .=  " activityChartingID = " .  $dataValues['activity']  . ", ";
			$query .=  " comments = '" . sql_quote( $dbHandle,  $dataValues['comments'] ) . "', ";
			$query .=  " staffInitials = '" . sql_quote( $dbHandle,  $staffInit ) . "' ";
			
			//echo "<br><br>Query is " . $query;
			//exit;
			
			mysqli_query( $dbHandle, $query  );
			if ( mysqli_errno( $dbHandle ) != 0 )
			{
				$rtnMsg = mysqli_error($dbHandle);
          			
			   // Free result set
			   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

				closeDB( $dbHandle );
				return array( SQLERROR, $rtnMsg );
			}
		}
          			
	   // Free result set
	   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

		closeDB( $dbHandle );
		return array( SUCCESS, "Personal Support Activity Charting for " . getClientName( $formdata['resident'] ) . " successfully saved." );

	}
	
	//============================
	
	function postESChartingInfo( $formdata )
	{
		$rtnArray = array();
		$dbHandle    = loginToDB();

		//for ( $i = 1; $i <= $numRows; $i++ )
		foreach ( $formdata['row'] as $dataKey => $dataValues )
		{
			//echo 'comments = ' . $formdata['comments'] . '<br>';
			$staffInit = $dataValues['postingStaff'];	
			if ( trim($dataValues['activityDate']) == '' || trim($dataValues['activityStartTime']) == '' || trim($dataValues['activityEndTime']) == '' || 
			     trim($dataValues['activity']) == '' || trim($dataValues['comments']) == ''  )														
			{
				//insert blank rows with no staff initials
				$staffInit = '';
				continue;
			}
			//echo dpp($formdata[$i]);

			// Check for overlapping activities
			$query  = "select count(*) from EmploymentServicesActivityCharting where clientID = " . $formdata['resident'] . " and activityDate = '" . sql_quote( $dbHandle,  dbDateFormat($dataValues['activityDate'] )) . "' ";
			$query .= " and ( " . $dataValues['startTimeID'] . " between ( startTimeID + 1 ) and ( endTimeID - 1 ) or "  . $dataValues['endTimeID'] . " between ( startTimeID + 1 ) and ( endTimeID - 1 ) )";
			
			//echo $query;
			//exit;
			
			mysqli_query( $dbHandle, $query  );
			if ( mysqli_errno( $dbHandle ) != 0 )
			{
				
				   // Free result set
				   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }


				closeDB( $dbHandle );
				return array( SQLERROR, "postESChartingInfo Failed:  system was unable to determine whether or not activities overlapped." );
			}
			else {
				$result = mysqli_query( $dbHandle, $query  );
				$row = mysqli_fetch_row( $result );
				if ( $row[0] > 0 )
				{
				
					// Free result set
					if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

					closeDB( $dbHandle );
					return array( OVERLAP, "postESChartingInfo Failed:  activity you are attempting to post for " .
											$dataValues['activityDate'] . " between " . $dataValues['activityStartTime'] . " and " . $dataValues['activityEndTime'] .
											" overlapps with another posted activity. Please check activity date/time and correct." );
				}
			}

			
			$query  = "INSERT INTO EmploymentServicesActivityCharting(clientID, activityDate, startTimeID, endTimeID, startTime, endTime, activityChartingID, comments, staffInitials ) VALUES ( ";
			
			$query .=  $formdata['resident'] . ", '" . sql_quote( $dbHandle,  dbDateFormat($dataValues['activityDate'] )) . "', ";
			$query .=  $dataValues['startTimeID'] . ", " . $dataValues['endTimeID'] . ", ";
			$query .=  " '" . sql_quote( $dbHandle,  $dataValues['activityStartTime'] ) . "', ";
			$query .=  " '" . sql_quote( $dbHandle,  $dataValues['activityEndTime'] ) . "', ";
			$query .=  " " . $dataValues['activity'] . ", ";
			$query .=  " '" . sql_quote( $dbHandle,  $dataValues['comments'] ) . "', ";
			$query .=  " '" . sql_quote( $dbHandle,  $staffInit ) . "' ";
			$query .=  " ) ON DUPLICATE KEY UPDATE ";
			$query .=  " startTime = '" . sql_quote( $dbHandle,  $dataValues['activityStartTime'] ) . "', ";
			$query .=  " endTime = '" . sql_quote( $dbHandle,  $dataValues['activityEndTime'] ) . "', ";
			$query .=  " activityChartingID = " .  $dataValues['activity']  . ", ";
			$query .=  " comments = '" . sql_quote( $dbHandle,  $dataValues['comments'] ) . "', ";
			$query .=  " staffInitials = '" . sql_quote( $dbHandle,  $staffInit ) . "' ";
			
			//echo "<br><br>Query is " . $query;
			//exit;
			
			mysqli_query( $dbHandle, $query  );
			if ( mysqli_errno( $dbHandle ) != 0 )
			{
				$rtnMsg = mysqli_error($dbHandle);
          			
			   // Free result set
			   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

				closeDB( $dbHandle );
				return array( SQLERROR, $rtnMsg );
			}
		}
          			
	   // Free result set
	   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

		closeDB( $dbHandle );
		return array( SUCCESS, "Employment Services Activity Charting for " . getClientName( $formdata['ClientID'] ) . " successfully saved." );

	}
	
	function insertDailyActivity( $staffID, $houseID, $formdata )
	{

		$dbHandle = loginToDB();
		$retStr = array();

		if ( $houseID == 0 )
		{
			$houseID = $formdata['house'];
		}

		$query = "insert into DailyActivity( EntryTime, EntryDate, HouseID, ActivityDescription, StaffID, StartTime, EndTIme ) values ( ";
		$query .= "'" . $formdata['entryTime'] . "', " . "'" . dbDateFormat($formdata['activitydate']) . "', " . $houseID . ", '" . sql_quote( $dbHandle,  $formdata['activitydescription'] ) . "', " . $staffID . ", '" . $formdata['activityStartTime'] . "', '" . $formdata['activityEndTime'] . "' )";

		mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno( $dbHandle ) == 0 )
			$retStr = array( SUCCESS, "Daily Activity Log data successfuly saved." );
		else
			$retStr = array( FAIL, mysqli_error($dbHandle) );
          			
	   // Free result set
	   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

		closeDB( $dbHandle );
		return $retStr;
	}
	
	function getBPCharting( $clientID, $serviceID, $month, $year )
	{

		$dbHandle = loginToDB();
		$retArr = array();

		$query  = "select * from BehaviorCharting where ClientID = " . $clientID . " and ServiceID = " . $serviceID . " and Month = '" . $month . "' and Year = " . $year . " order by  5 ";

		//echo $query;
		
		$result = mysqli_query( $dbHandle, $query  );
		while ( $row = mysqli_fetch_row( $result ) )
		{
			$retArr[] = $row;
		}
          			
	   // Free result set
	   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
	   closeDB( $dbHandle );

	   return $retArr;

   }
   
   function deleteBP( $staffID, $formdata )
	{

		$dbHandle = loginToDB();

		$retStr = array( SUCCESS, '' );

		for ( $i = 0; $i < count($formdata['clientrow']); $i++ )
		{
				list( $cID, $iID, $mth, $yr ) = explode( "-", $formdata['clientrow'][$i] );
				$query = "DELETE FROM BehaviorCharting WHERE ClientID = ". $cID . " and ( IncidentID = " . $iID . " OR  IncidentID is NULL ) and Month = '" . $mth . "' and Year = " . $yr;
				
				mysqli_query( $dbHandle, $query  );

				if ( mysqli_errno( $dbHandle ) != 0 )
			    {
					$retStr = array( FAIL, mysqli_error($dbHandle) );
          			
				   // Free result set
				   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

					closeDB( $dbHandle );
					return $retStr;
				}
		}
          			
	   // Free result set
	   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }


		closeDB( $dbHandle );
		return $retStr;
	}
	
	function getClientIncidentID($cID)
	{
		$incID = 0;
		$dbHandle = loginToDB();

		$query = "select COALESCE(  max( incidentID ), 0 ) from BehaviorCharting where ClientID = ". $cID;
		$result = mysqli_query( $dbHandle, $query  );
		$row = mysqli_fetch_row( $result );
		return $row[0] + 1;
	}
	
	function insertBP( $staffID, $formdata )
	{
		global $nLongMonth;
		$dbHandle = loginToDB();
		$staffInit = getStaffInitials($staffID, $dbHandle);
		$retStr = array( SUCCESS, '' );
		$chart_month = $formdata['chart_month'];

		for ( $i = 1; $i <= 5; $i++ )
		{
			if (empty($formdata["myd".$i]) && empty($formdata["stime".$i]) && empty($formdata["etime".$i])) {
            	continue;
        	}

			$myd = 'myd' . $i;
			$stime = 'stime' . $i;
			$ii = 'i' . $i;
			$etime = 'etime' . $i;
				
			// Get selected values from multiple select fields
			$TargetBehaviorID = "";
			
			$values = $formdata['tb'.$i];
			
			foreach ($values as $a){				
				$TargetBehaviorID .= (( $TargetBehaviorID == "" ) ? $a : ', ' . $a );					
			}
							
			$AntecedentID = "";
			$values = $formdata['al'.$i];
			foreach ($values as $a){
				$AntecedentID .= (( $AntecedentID == "" ) ? $a : ', ' . $a );
			}
							
			$InterventionID = "";
			$values = $formdata['il'.$i];
			foreach ($values as $a){
				$InterventionID .= (( $InterventionID == "" ) ? $a : ', ' . $a );
			}
			
			$InterventionResultID = "";
			$values = $formdata['rslt'.$i];
			foreach ($values as $a){
				$InterventionResultID .= (( $InterventionResultID == "" ) ? $a : ', ' . $a );
			}

			$incidentID = getClientIncidentID($formdata['resident']);

			$query = "insert into BehaviorCharting( ClientID, ServiceID, IncidentID, EntryDate, Month, Year, StartTime, EndTime, TargetBehaviorID,";
			$query .= " IntensityLevelID, AntecedentID, InterventionID, InterventionResultID, StaffID, StaffInitials ) values ( " . $formdata['resident'] ;
			$query .= ( ", " . $formdata['service'] . ", " . $incidentID . ", '" . sql_quote( $dbHandle, dbDateFormat($formdata['myd' . $i])) . "', '" . $nLongMonth[$chart_month] . "', " );
			$query .= ( "" . $formdata['chart_year'] . ", '" . sql_quote( $dbHandle, $formdata['stime' . $i]) . "', '" . sql_quote( $dbHandle, $formdata['etime' . $i]) . "', " );
			$query .= ( "'" . sql_quote( $dbHandle, $TargetBehaviorID) . "', '" . sql_quote( $dbHandle, $formdata['i' . $i]) . "', '" . sql_quote( $dbHandle, $AntecedentID) . "', " );
			$query .= ( "'" . sql_quote( $dbHandle, $InterventionID) . "', " . sql_quote( $dbHandle, $InterventionResultID) . ", " . $staffID . ", '" . $staffInit . "' )" );
echo $query;

			mysqli_query( $dbHandle, $query  );
			if ( mysqli_errno( $dbHandle ) != 0 )
			{
				$retStr = array( FAIL, mysqli_error($dbHandle) );
				
				// Free result set
				if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
				closeDB( $dbHandle );
				return $retStr;
			}

		}
          			
	   // Free result set
	   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

	   closeDB( $dbHandle );
	   return $retStr;

	}
	
	
	function getClientsObjectivesGoals( $clientID, $serviceID, $ipmonth, $ipyear, $hist = 0 )
	{
		$cID = 0;
		$ipMonthYr = $ipyear . "" . ( ( ltrim($ipmonth, '0') < 10 ) ? '0' . ltrim($ipmonth, '0') : $ipmonth );
		$clientsObjGoals = array();
		$dbHandle    = loginToDB();

		$history = ( $hist == 1 ) ? "History " : "";
		$stat = ( $hist == 1 ) ? "Closed" : "Open";
		
		$query  = "SELECT b.ObjectiveID, b.ObjectiveDescription, c.GoalID,  c.GoalDescription, d.BeginDate, d.EndDate, ";
		$query .= " date_format(d.BeginDate, '%m-%d-%Y' ), date_format(d.EndDate, '%m-%d-%Y' ), c.GoalDataFreq, c.GoalDataNumDays ";
		$query .= " FROM   PCPClientsObjectives b, PCPGoals c, PCPObjectivesGoalManagement" . $history . " d ";
		$query .= " where  d.ClientID = " . $clientID . " AND  b.ServiceID = " . $serviceID . " and b.ObjectiveID = d.ObjectiveID  ";  
		$query .= " AND    c.GoalID = d.GoalID AND    c.ObjectiveID = d.ObjectiveID ";
		//$query .= " AND    b.ObjectiveGroup in ( '" . $group . "', 'B' ) ";
		$query .= " AND    " . $ipMonthYr . " between date_format(d.BeginDate, '%Y%m') and date_format(d.EndDate, '%Y%m') ";
		//$query .= " AND    " . $ipyear . " between YEAR(d.BeginDate) and YEAR(d.EndDate) ";
		$query .= " AND    b.ObjectiveStatus = 'Open' AND c.GoalStatus = 'Open' AND d.Status = '" . $stat . "' order by 1, 3";
		
		//echo $query;								
		$result = mysqli_query( $dbHandle, $query  );
		while ( $row = mysqli_fetch_row( $result ) )
		{						
			$clientsObjGoals[$cID++] = array( $row[0], $row[1], $row[2], $row[3], $row[4], $row[5], $row[6], $row[7], $row[8], $row[9]);			
		}
				
	   // Free result set
	   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

		closeDB( $dbHandle );
		return $clientsObjGoals;
	}
		
	function getCurrentIPs( $clientID, $serviceID, $obj, $goal, $mth, $yr, $hist = 0  ) 
	{
		$dbHandle    = loginToDB();
		$hist = ( $hist == 1 ) ? "History " : "";
		
		$query  = "SELECT " . $clientID . " as ClientID, "   . $serviceID . " as ServiceID, "   . $obj . " as ObjectiveID, "   . $goal . " as GoalID, " . $mth . " as Month, " . $yr . " as Year, ";
		$query  .= " `Day1`, `Day2`, `Day3`, `Day4`, `Day5`, `Day6`, `Day7`, `Day8`, `Day9`, `Day10`, `Day11`, `Day12`, `Day13`, `Day14`, ";
		$query  .= " `Day15`, `Day16`, `Day17`, `Day18`, `Day19`, `Day20`, `Day21`, `Day22`, `Day23`, `Day24`, `Day25`, `Day26`, `Day27`, ";
		$query  .= " `Day28`, `Day29`, `Day30`, `Day31`, `Success`, `Negative`, `Percentage` ";
		$query  .= " FROM   PCPCharting" . $hist . " where ClientID = " .  $clientID . " and ServiceID = " . $serviceID . " and ObjectiveID = " . $obj . " ";
		$query  .= " and GoalID = " . $goal . " and Month = " .  $mth . " and Year = " . $yr;					
		//echo "Regular: " . $query;
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_num_rows($result) == 0 )
		{
			//$query  = "SELECT *  FROM   PCPChartingHistory where ClientID = " .  $clientID . " and ServiceID = " . $serviceID . " and ObjectiveID = " . $obj . " and GoalID = " . $goal;
			//$query  .= " and Month = " .  $mth . " and Year = " . $yr;	
			
			$query  = "SELECT " . $clientID . " as ClientID, "   . $serviceID . " as ServiceID, "   . $obj . " as ObjectiveID, "   . $goal . " as GoalID, " . $mth . " as Month, " . $yr . " as Year, ";
			$query  .= " `Day1`, `Day2`, `Day3`, `Day4`, `Day5`, `Day6`, `Day7`, `Day8`, `Day9`, `Day10`, `Day11`, `Day12`, `Day13`, `Day14`, ";
			$query  .= " `Day15`, `Day16`, `Day17`, `Day18`, `Day19`, `Day20`, `Day21`, `Day22`, `Day23`, `Day24`, `Day25`, `Day26`, `Day27`, ";
			$query  .= " `Day28`, `Day29`, `Day30`, `Day31`, `Success`, `Negative`, `Percentage` ";
			$query  .= " FROM   PCPChartingHistory" . $hist . " where ClientID = " .  $clientID . " and ServiceID = " . $serviceID . " and ObjectiveID = " . $obj . " ";
			$query  .= " and GoalID = " . $goal . " and Month = " .  $mth . " and Year = " . $yr;				
			//echo "History: " . $query;
			$result = mysqli_query( $dbHandle, $query  );
		}			
		$row = mysqli_fetch_assoc($result);
				
	   // Free result set
	   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }


		closeDB( $dbHandle );
		return $row;
	}
	
	function getIPDate( $clientID, $hist = 0 )
	{
		$dbHandle    = loginToDB();
		
		$selection = " CurrentIPDate, date_format(CurrentIPDate, '%m-%d-%Y' ) as CurrIPDate ";
		if ( $hist != 0 )
		{
			// Get Previous IP Date
			$selection = " CurrentIPDate - INTERVAL 365 DAY as CurrentIPDate, date_format(CurrentIPDate - INTERVAL 365 DAY, '%m-%d-%Y' ) as CurrIPDate ";
		}
		$query  = "SELECT " . $selection . " FROM PCPDateManagement WHERE ClientID = " . $clientID;
		
		//echo $query;
		
		$result = mysqli_query( $dbHandle, $query  );
		$row = mysqli_fetch_assoc($result);
				
	   // Free result set
	   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

		closeDB( $dbHandle );
		return array( $row['CurrentIPDate'], $row['CurrIPDate'] );
	}
		
	function insUpdIP( $formdata, $isDay = 0 )
	{
		//echo dpp( $formdata );
		//exit;
		
		$objGoals = explode("|", $formdata['objGoals'] );
		$dbHandle    = loginToDB();
		$rtnVal = array();
		
		$hist = ( $formdata['ipFromHistory'] == 1 ) ? "History" : "";
		$tblroot = array( 0 => 'PCPCharting', 'IPDayCharting' );
		foreach ( $objGoals  as $index => $objGoal )
		{
			list( $objID, $goalID ) = explode( "-", $objGoal );
			$success = $failure = $percentage = $totalChk = 0;
			
			// Sum the daily entries
			for ( $i = 1; $i <= 31; $i++ ) {
			
				if (isset($formdata) && is_array($formdata) && isset($formdata['chk-'.$objGoal.'-'.$i])) {
					 if ( $formdata['chk-'.$objGoal."-".$i] == ""  ) {
					 }
					 else {
						$totalChk += 1;
						if ( $formdata['chk-'.$objGoal."-".$i] == 1 ) {
							$success += 1;
						}
						else {
							$failure += 1;
						}
						
					 }
				} 
			}
			$percentage = ($totalChk == 0) ? 0 : $success / $totalChk * 100.0;
			
			//echo "$success | $failure | $percentage | $totalChk";
			//exit;
			
			$query  = " insert into " . $tblroot[$isDay] . $hist . "(  ClientID, ServiceID, ObjectiveID, GoalID, Month, Year, Day1, Day2, Day3, Day4, Day5, Day6, Day7, Day8, Day9, Day10, Day11, Day12, Day13, Day14, Day15, Day16, Day17, Day18, Day19, Day20, Day21, Day22, Day23, Day24, Day25, Day26, Day27, Day28, Day29, Day30, Day31, Success, Negative, Percentage ) ";
			$query .= " values ( ";
			$query .= " " . $formdata['resident'] . ", " . $formdata['service'] . ", " . $objID . ", " . $goalID . ", ";
			$query .=  $formdata['chart_month'] . ", '" . $formdata['chart_year'] . "', ";

			// $query .= " '" . $formdata['ipDate'] . "', " . $formdata['chart_month'] . ", '" . $formdata['chart_year'] . "', ";
			for ( $i = 1; $i <= 31; $i++ ) {
			
				if (isset($formdata) && is_array($formdata) && isset($formdata['chk-'.$objGoal.'-'.$i])  &&  ( trim($formdata['chk-'.$objGoal.'-'.$i]) != '' ) ) 
				{
					 $query .= " " . $formdata['chk-'.$objGoal.'-'.$i] . ", ";
				} 
				else {
					$query .= " NULL, ";
				}
				//$chkValue = $formdata['chk-'.$objGoal.'-'.$i] ?? 'NULL'; 
				//$query .= " " . $chkValue . ", ";
			}
			
			$query .= " " . $success . ", ";
			$query .= " " . $failure . ", ";
			$query .= " " . $percentage . " ) ";
			$query .= " ON DUPLICATE KEY UPDATE " ;
			//$query .= " IPDate = '" . $formdata['ipDate'] . "', ";
			for ( $i = 1; $i <= 31; $i++ ) {
			
				if (isset($formdata) && is_array($formdata) && isset($formdata['chk-'.$objGoal.'-'.$i]) &&  ( trim($formdata['chk-'.$objGoal.'-'.$i]) != '' )  )
				{
					 $query .= " Day" . $i . " = " . $formdata['chk-'.$objGoal.'-'.$i] . ", ";
				} 
				else {
					$query .= " Day" . $i . " =  NULL, ";
				}
				//$chkValue = $formdata['chk-'.$objGoal.'-'.$i] ?? 'NULL'; 
				//$query .= " Day" . $i . " = " . $chkValue . ", ";
			}
			$query .= " Success = " . $success . ", ";
			$query .= " Negative = " . $failure . ", ";
			$query .= " Percentage = " . $percentage . "";
					
			//echo $query . "<br><br><br>";
			
			$result = mysqli_query( $dbHandle, $query  );
			if ( mysqli_errno( $dbHandle ) != 0 )
			{
				//echo "<br>" . mysqli_error( $dbHandle ) . "<br>";
				$rtnVal = array( FAIL, mysqli_errno( $dbHandle ) );
				
			   // Free result set
			   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

				closeDB( $dbHandle );
				return $rtnVal;
			}
			
		}
				
	   // Free result set
	   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

		closeDB( $dbHandle );
		return array( SUCCESS, "" );
	}
?>
