<?php
	
	$localRoot =  __DIR__;
	
	//
	// General Admin Functions
	//
	if ( isset($_SERVER['DOCUMENT_ROOT']) &&  trim($_SERVER['DOCUMENT_ROOT']) <> "" ) {
		include( $_SERVER['DOCUMENT_ROOT'] . '/assets/db/cronjobs.db.php' );
	}
	else {
		include( 'cronjobs.db.php' );
	}
	
	function getTimeZone( $tz )
	{	 
		$dbHandle = loginToDB();
		$tzlist = array();
		
		$query  = "SELECT * FROM `USTimeZones`";
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return "";
		}
		
		while ( $row = mysqli_fetch_assoc( $result ) )
		{
			$tzlist[$row['TimeZoneID']] = $row;
		}
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return $tzlist[$tz]['TimeZoneName'];
	}
	
	function getNextID( $table, $column, $inHandle = -1 )
	{	
		if (($inHandle instanceof mysqli) && ($inHandle->ping())) {
			$dbHandle = $inHandle;
		}
		else {
			$dbHandle = loginToDB();
		}
		
		$query = "LOCK TABLES " . $table . " READ ";
		mysqli_query( $dbHandle, $query  );
		
		$query  = "SELECT COALESCE( MAX(" . $column . "), 0 ) + 1 as NewID FROM " . $table . " ";
				
		$result = mysqli_query( $dbHandle, $query  );
		$row = mysqli_fetch_assoc( $result );
		
		$query = "UNLOCK TABLES";
		mysqli_query( $dbHandle, $query  );
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			return -1;
		}
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		if ( ! $inHandle instanceof mysqli ) {
			closeDB( $dbHandle );
		}
			
		return $row['NewID'];
		
	}
	
	function getKeyFromTime($timefield)
	{
		if ( trim($timefield) == '' ) { return 'NULL'; }
		if ( ! preg_match("/ /", $timefield ) )
		{
			if ( preg_match("/AM|PM/", $timefield ) ) {
				$timefield = str_replace( array( "AM", "PM" ), array( " AM", " PM" ), $timefield );
			}
		}
		
		$timeArr = preg_split( "/:| /", $timefield );
		if ( strcmp( $timeArr[2], 'PM' ) == 0 ) {
			if (  $timeArr[0] != 12 ) 
				$timeArr[0] += 12;
		}
		else if ( strcmp( $timeArr[2], 'AM' ) == 0 ) {
			if  ( $timeArr[0] == 12 )
				$timeArr[0] = '00';
		}
		
		return $timeArr[0] . $timeArr[1];
	}
	
	function verifyEmail( $StaffRec )
	{
		$dbHandle = loginToDB();
		
		$staffID = $StaffRec;
		if ( is_array( $StaffRec) )
		{
			// Verify email matches
			$query = "SELECT `StaffEmail` FROM `Staff` WHERE `StaffID`= " . $StaffRec['staffID'] . " AND `StaffEmail`= '" . sql_quote( $dbHandle, $StaffRec['email'] ) . "' ";
			$result = mysqli_query( $dbHandle, $query  );	
			
			if ( mysqli_errno($dbHandle) != 0 ) {
				$errorNumber = mysqli_errno($dbHandle);
				$errorMessage = mysqli_error($dbHandle);
				if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
				closeDB( $dbHandle );
				return array( FAIL, "verifyEmail() failed with Error Code: " . $errorNumber  . " and Error Message: " . $errorMessage . " " );
			}
			
			if ( mysqli_num_rows($result) == 0 ) {
				if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
				closeDB( $dbHandle );	
				return array( FAIL, "The email you entered does not match our records" );
			}
			
			if ( mysqli_num_rows($result) > 1 ) {
				if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
				closeDB( $dbHandle );	
				return array( FAIL, "More that one record matched the email you entered. Please contact the administrator" );
			}
			
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			
			$staffID = $StaffRec['staffID'];
		}
		
		$query = "UPDATE `StaffIndicators` SET `IsConfirmed`='Y',`isEmailVerified`='Y'  WHERE  `StaffID`= " . $staffID . "  ";
		$result = mysqli_query( $dbHandle, $query  );		 
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return array( FAIL, "" );
		}
		
		closeDB( $dbHandle );					
		return array( SUCCESS, "" );
			
	}
	
	function getServiceName( $serviceID, $stateCD )
	{
		$dbHandle = loginToDB();
		
		$query  = "SELECT  a.`Name` as ServiceName FROM `ServicesProvidedLkup` a, `StateLookup` b  ";
		$query .= "WHERE a.`ServiceID` = " . $serviceID . " AND a.`StateID`=b.`StateID` and b.`StateAbbrev`= '" . $stateCD . "'  ";
		
		//echo $query;
				
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return "";
		}
		
		$row = mysqli_fetch_assoc( $result );
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return $row['ServiceName'];
	}
	
	function getServicesProvided( $state = "" )
	{
		$dbHandle = loginToDB();
		$servicesPrvd = array();
		
		if ( isset($state) && ( $state == "" ) ) {
			$state = $_POST['stateCD'];
		}
		
		$query  = "SELECT  a.`ServiceID`, a.`Name` as ServiceName FROM `ServicesProvidedLkup` a, `StateLookup` b  ";
		$query .= "WHERE a.`StateID`=b.`StateID` and b.`StateAbbrev`= '" . $state . "'  order by 2";
				
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return "";
		}
		
		while ( $row = mysqli_fetch_assoc( $result ) )
		{
			$servicesPrvd[] = $row;
		}
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return $servicesPrvd;
	}
	
	function getConfigServicesProvided()
	{
		$dbHandle = loginToDB();
		$servicesPrvd = array();
		
		$query  = "SELECT * FROM `ConfigServices` ";
				
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return $servicesPrvd;
		}
		
		while ( $row = mysqli_fetch_assoc( $result ) )
		{
			$servicesPrvd[] = $row;
		}
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return $servicesPrvd;
	}
	
	function getClientServices( $clientID, $active = false )
	{
		$dbHandle = loginToDB();
		$servicesPrvd = array();
		
		$endDateCHk = '';
		if ( $active ) {
			$endDateCHk = " ( ( CURDATE() BETWEEN `StartDate` AND `EndDate`  ) or ( CURDATE() >= `StartDate` AND `EndDate` is NULL ) ) AND ";
		}
		
		$query  = "SELECT * FROM `ClientServices` WHERE " . $endDateCHk . " `ClientID` = " . $clientID;
				
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return $servicesPrvd;
		}
		
		while ( $row = mysqli_fetch_assoc( $result ) )
		{
			$servicesPrvd[] = $row;
		}
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return $servicesPrvd;
	}
	
	function getClientChartingServices( $stateCD =  "", $clientID = "" )
	{		
		$dbHandle = loginToDB();
		$servicesPrvd = array();
		
		if ( $clientID == "" ) {
			$clientID = $_POST['clientID'];
			$stateCD = $_POST['stateCD'];
		}
		
		$query  = "SELECT distinct a.`ServiceID`, b.`Name` as ServiceName FROM `ClientServices` a, `ServicesProvidedLkup` b ";
		$query .= " WHERE a.`ServiceID`=b.`ServiceID` AND a.`ClientID`= " . $clientID . " and ";
		$query .= " b.`StateID` in ( SELECT `StateID` FROM `StateLookup` WHERE `StateAbbrev`='" . $stateCD . "' )";
		
		//return $query;
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return $servicesPrvd;
		}
		
		//if ( mysqli_num_rows($result) == 0 ) {
			
		//}
		
		while ( $row = mysqli_fetch_assoc( $result ) )
		{
			$servicesPrvd[] = $row;
		}
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return $servicesPrvd;
	}
	
	function getCorpServicesProvided( $services )
	{
		global $agency_info;
		
		if ( ! is_array( $services) ) {
			return array( FAIL, "There are no services/programs found for " . $agency_info['agency_shortname'] );
		}
		$dbHandle = loginToDB();
		$servicesPrvd = array();
		
		$keys = array_keys($services);
		$query  = "SELECT  a.`ServiceID`, a.`Name` as ServiceName FROM `ServicesProvidedLkup` a ";
		$query .= "WHERE a.`ServiceID` in ( ";
		for ( $i = 0; $i < count($keys); $i++ ) {
			$query .=  $keys[$i] . ( ( $i < count($keys) - 1 ) ? ", " : "" );
		}
		$query .= " ) or ( `StateID` is NULL ) ORDER BY 2";
				
			//echo $query;
				
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			$errorNumber = mysqli_errno($dbHandle);
			$errorMessage = mysqli_error($dbHandle);
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
			return array( FAIL, "getCorpServicesProvided() failed with Error Code: " . $errorNumber  . " and Error Message: " . $errorMessage . " " );
		}
		
		while ( $row = mysqli_fetch_assoc( $result ) )
		{
			$servicesPrvd[] = $row;
		}
		
		//echo dpp($servicesPrvd);
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return array( SUCCESS, $servicesPrvd );
	}
	
	function getSubServices( $serviceID )
	{
		$dbHandle = loginToDB();
		$subServicesPrvd = array();
		
		$query  = "SELECT `SubServiceID`, `Name` as SubServiceName FROM `SubServicesProvidedLkup` WHERE `ServiceID` =  " . $serviceID . "  ";
				
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			$errorNumber = mysqli_errno($dbHandle);
			$errorMessage = mysqli_error($dbHandle);
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
			return array( FAIL, "getSubServices() failed with Error Code: " . $errorNumber  . " and Error Message: " . $errorMessage . " " );
		}
		
		while ( $row = mysqli_fetch_assoc( $result ) )
		{
			$subServicesPrvd[] = $row;
		}
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return $subServicesPrvd;
	}
	
	function getSubServiceName( $serviceID, $subServiceID)
	{
		$dbHandle = loginToDB();
		
		$query  = "SELECT  `Name` as SubServiceName FROM `SubServicesProvidedLkup`  WHERE `ServiceID` = " . $serviceID . " AND  `SubServiceID`= " . $subServiceID . "  ";
		//echo $query;
				
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return "";
		}
		
		$row = mysqli_fetch_assoc( $result );
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return $row['SubServiceName'];
	}
	
	function getMedicationType()
	{
		$dbHandle = loginToDB();
		$medtypes = array();
		
		$query  = "SELECT `MedTypeID`, `MedTypeCd`, `MedTypeName` FROM `MedicationType`";
				
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return array( FAIL, "" );
		}
		
		while ( $row = mysqli_fetch_assoc( $result ) )
		{
			$medtypes[] = $row;
		}
				
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return array( SUCCESS, $medtypes );
	}
	
	function getSubServicesProvided()
	{
		$dbHandle = loginToDB();
		$servicesPrvd = array();
		
		$query  = "SELECT  a.`ServiceID`, b.`SubServiceID`, b.`Name` as SubServiceName FROM `ServicesProvidedLkup` a, `SubServicesProvidedLkup` b  ";
		$query .= "WHERE a.`ServiceID`=b.`ServiceID` and b.`ServiceID`= " . $_POST['serviceID'] . "  ";
				
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return "";
		}
		
		while ( $row = mysqli_fetch_assoc( $result ) )
		{
			$servicesPrvd[] = $row;
		}
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return $servicesPrvd;
	}
	
	function getStates( $wMgmt = false )
	{
		$dbHandle = loginToDB();
		$states = array();
		
		$mgmtWhere = " WHERE StateID > 0 ";
		if ( $wMgmt ) { 
			$mgmtWhere = "";
		}
	 	$query   = "SELECT * FROM `StateLookup` " . $mgmtWhere;
				
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return array( FAIL, "" );
		}
		
		while ( $row = mysqli_fetch_assoc( $result ) )
		{
			$states[] = $row;
		}
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return array( SUCCESS, $states );
	}
	
	function getStaffDocsList()
	{
		$dbHandle = loginToDB();
		$docslist = array();
		
		$query  = "SELECT * FROM `StaffDocsLkup`";
				
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return "";
		}
		
		while ( $row = mysqli_fetch_assoc( $result ) )
		{
			$docslist[$row['DocID']] = $row;
		}
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return $docslist;
	}
	
	function getCorporateDocsList()
	{
		$dbHandle = loginToDB();
		$docslist = array();
		
		$query  = "SELECT * FROM `CorporateDocsLkup` order by 2";
				
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return array( FAIL, "getCorporateDocsList() failed with Error Code: " . $errorNumber  . " and Error Message: " . $errorMessage . " " . PHP_EOL . "Please notify the administrator." );
		}
		
		while ( $row = mysqli_fetch_assoc( $result ) )
		{
			$row['RenewInterval'] = $row['RenewalInterval'];
			//$docslist[$row['DocID']] = $row;
			$docslist[] = $row;
		}
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return array( SUCCESS, $docslist ); 
	}
	
	function getAllHouses()
	{
		$dbHandle = loginToDB();
		$houselist = array();
		
	 	$query   = "SELECT * FROM `Houses` ORDER BY `HouseName`";
				
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return  "";
		}
		
		while ( $row = mysqli_fetch_assoc( $result ) )
		{
			$houselist[] = $row;
		}
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return $houselist;
	}
	
	function getSchoolsListing()
	{
		$dbHandle = loginToDB();
		$schoollist = array();
		
	 	$query   = "SELECT `SchoolID`, `SchoolName` FROM `Schools` ORDER BY `SchoolName`";
				
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return  "";
		}
		
		while ( $row = mysqli_fetch_assoc( $result ) )
		{
			$schoollist[] = $row;
		}
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return $schoollist;
	}
	
	function getCCSListing()
	{
		$dbHandle = loginToDB();
		$stafflist = array();
		
	 	//$query   = "SELECT `CCS_StaffID`, CONCAT(`CCS_StaffFname`, ' ', `CCS_StaffLname` ) AS CCS_StaffName FROM `CCS_Staff` ORDER BY CCS_StaffName";
		$query   = "SELECT `CCS_StaffID`, `CCS_StaffName`, `ssType` FROM `CCS_Staff` WHERE `Status` ='Active' order by 2";
				
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return  "";
		}
		
		while ( $row = mysqli_fetch_assoc( $result ) )
		{
			$stafflist[] = $row;
		}
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return $stafflist;
	}
	
	function getPharmacyListing()
	{
		$dbHandle = loginToDB();
		$pharmacies = array();
		
	 	$query   = "SELECT `PharmacyID`, `PharmacyName` FROM `Pharmacies` ORDER BY PharmacyName";
				
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return  "";
		}
		
		while ( $row = mysqli_fetch_assoc( $result ) )
		{
			$pharmacies[] = $row;
		}
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return $pharmacies;
	}
	
	function getMedicationList()
	{
		$dbHandle = loginToDB();
		$meds = array();
		
	 	$query   = "SELECT `MedID`, `MedName` FROM `Medications` WHERE `Discontinued`='N' ORDER BY MedName";
				
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return  "";
		}
		
		while ( $row = mysqli_fetch_assoc( $result ) )
		{
			$meds[] = $row;
		}
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return $meds;
	}
	
	function getMedicationName( $medID ) 
	{
		$dbHandle = loginToDB();
		
	 	$query   = "SELECT `MedName` FROM `Medications` WHERE `MedID` = " . $medID;
								
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return  "";
		}
		
		$row = mysqli_fetch_assoc( $result );
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return $row['MedName'];
	}
	
	
	function getHousesListing( $nameOrder = false )
	{
		$dbHandle = loginToDB();
		$houselist = array();
		
 		$gettype = '';
		if ( $nameOrder == 'MB' )  {
			$gettype   .=  ", `HouseType` ";
		}
	 	$query   = "SELECT `HouseID`, `HouseName` " . $gettype . " FROM `Houses` WHERE `HouseInUse`='Y' ";
		if ( $nameOrder == 'MB' )  {
			$query   .=  " AND `HouseType` in ( 'A', 'D' ) ";
		}
		$query   .=  " order by 2 ";
			
		//echo $query;
			
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return  "";
		}
		
		while ( $row = mysqli_fetch_assoc( $result ) )
		{
			$houselist[] = $row;
		}
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
							
		return $houselist;
	}
	
	function getGroupHomes()
	{
		$dbHandle = loginToDB();
		$houselist = array();
		
	 	$query   = "SELECT `HouseID`, `HouseName` FROM `Houses` WHERE `HouseInUse`='Y' and `HouseType`='A'";
		$query   .=  " order by `HouseName` ";
				
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return  "";
		}
		
		while ( $row = mysqli_fetch_assoc( $result ) )
		{
			$houselist[] = $row;
		}
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return $houselist;
	}
	
	function getHousesByProgram()
	{
		$dbHandle = loginToDB();
		$houselist = array();
		
	 	$query   = "SELECT `HouseID`, `HouseName` FROM `Houses` WHERE `HouseInUse`='Y' ";
		$query   .=  " AND `HouseID` in ( SELECT distinct `HouseID` FROM `ClientServices` WHERE `ServiceID` =  " . $_REQUEST['programID'] . " ) order by `HouseName` ";

				
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return  "";
		}
		
		while ( $row = mysqli_fetch_assoc( $result ) )
		{
			$houselist[] = $row;
		}
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return $houselist;
	}
	
	/*
	function getClientServices($clientID)
	{
		$dbHandle = loginToDB();
		$serviceslist = array();
		
	 	$query   = "SELECT * FROM `ClientServices` WHERE `ClientID`= " . $clientID;

		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return  "";
		}
		
		while ( $row = mysqli_fetch_assoc( $result ) )
		{
			$serviceslist[] = $row;
		}
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return $serviceslist;
	}
	*/
	
	function getHouseType()
	{
		$dbHandle = loginToDB();
		$houseType = array();
		
	 	$query   = "SELECT * FROM `HouseTypeLkup`";
								
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return  $houseType;
		}
				
		while ( $row = mysqli_fetch_assoc( $result ) )
		{
			$houseType[] = $row;
		}
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return $houseType;
	}
	
	function getHouseName( $houseID )
	{
		$dbHandle = loginToDB();
		
	 	$query   = "SELECT `HouseName` FROM `Houses` WHERE `HouseID`=" . $houseID;
								
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return  "";
		}
		
		$row = mysqli_fetch_assoc( $result );
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return $row['HouseName'];
	}
	
	function getClientImage( $clientID )
	{
		$dbHandle = loginToDB();
		
	 	$query   = "SELECT if(`ClientImage` is NULL or trim(`ClientImage`)='', if(`ClientGender`='M', 'no_image.png','no_image.png'), `ClientImage`) as ClientImage FROM `Clients` WHERE `ClientID`=" . $clientID;
								
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return  "";
		}
		
		$row = mysqli_fetch_assoc( $result );
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return $row['ClientImage'];
	}
	
	//
	// Get Image Name
	//
	function getImageName( $staffID )
	{
		$dbHandle = loginToDB();
		
	 	$query   = "SELECT if(`StaffImage` is NULL or trim(`StaffImage`)='', if(`StaffGender`='M', 'male.png','female.png'), `StaffImage`) as StaffImage FROM `Staff` WHERE `StaffID`=" . $staffID;
								
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return  "";
		}
		else if (  mysqli_num_rows($result) == 0 ) {
			$query   = "SELECT if(`StaffImage` is NULL or trim(`StaffImage`)='', if(`StaffGender`='M', 'male.png','female.png'), `StaffImage`) as StaffImage FROM `ConfigureStaff` WHERE `StaffID`=" . $staffID;
								
			$result = mysqli_query( $dbHandle, $query  );	
		}
		
		$row = mysqli_fetch_assoc( $result );
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return $row['StaffImage'];
	}
	
	//
	// Get Image Name
	//
	function getLogoName( $PharmacyID )
	{
		$dbHandle = loginToDB();
		
	 	$query   = "SELECT ifnull(`LogoFilename`, 0) as  LogoFilename FROM `Pharmacies` WHERE `PharmacyID`=" . $PharmacyID;
								
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return  "";
		}
		
		$row = mysqli_fetch_assoc( $result );
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return $row['LogoFilename'];
	}
	
	function getClientName( $clientID )
	{
		$dbHandle = loginToDB();
		
	 	$query   = "SELECT CONCAT(`ClientFname`, ' ', `ClientLname`) as ClientName FROM `Clients` WHERE `ClientID`=" . $clientID;
								
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return  "";
		}
		
		$row = mysqli_fetch_assoc( $result );
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return $row['ClientName'];
	}
	
	function getStaffListing()
	{
		$dbHandle = loginToDB();
		$stafflist = array();
		
	 	$query   = "SELECT `StaffID`, concat(`StaffFname`, ' ', `StaffLname`) as StaffName FROM `Staff`";
				
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return  "";
		}
		
		while ( $row = mysqli_fetch_assoc( $result ) )
		{
			$stafflist[] = $row;
		}
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return $stafflist;
	}
	
	function getStaffListingByHouse( $houseNameOrder = false )
	{
		$dbHandle = loginToDB();
		$stafflist = array();
		
	 	$query   = "SELECT a.`StaffID`, IF ( d.`AdminByPass` = 'Y',  `ByPassHouseID`, b.`HouseID` ) AS 'HouseID', concat(a.`StaffFname`, ' ', a.`StaffLname`) as StaffName ";
		$query  .= ( ( $houseNameOrder === true ) ? ", b.`HouseName` " : "" ) . " ";
		$query  .= " FROM `Staff` a, `Houses` b, `StaffIndicators` c, `StaffAuthAz` d ";
		$query  .= " WHERE a.`Status`='Active' AND a.`StaffID`=c.`StaffID` AND a.`StaffID`=d.`StaffID`  AND  b.`HouseID`=c.`HouseID` " . ( ( $houseNameOrder === true ) ? " ORDER BY 4 " : " ORDER BY 3 " );
		
		//echo $query;
		
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return  "";
		}
		
		while ( $row = mysqli_fetch_assoc( $result ) )
		{
			$stafflist[] = $row;
		}
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return $stafflist;
	}
	
	function getFormerStaffListing( $houseNameOrder = false )
	{
		$dbHandle = loginToDB();
		$stafflist = array();
		
	 	$query   = "SELECT a.`StaffID`, IF ( d.`AdminByPass` = 'Y',  `ByPassHouseID`, b.`HouseID` ) AS 'HouseID', concat(a.`StaffFname`, ' ', a.`StaffLname`) as StaffName ";
		$query  .= ( ( $houseNameOrder === true ) ? ", b.`HouseName` " : "" ) . " ";
		$query  .= " FROM `StaffHistory` a, `Houses` b, `StaffIndicatorsHistory` c, `StaffAuthAzHistory` d ";
		$query  .= " WHERE a.`StaffID` not in ( Select `StaffID` from Staff where `Status`='Active' ) And ";
		$query  .= " a.`Status`='Inactive' AND a.`StaffID`=c.`StaffID` AND a.`StaffID`=d.`StaffID`  AND  b.`HouseID`=c.`HouseID` " . ( ( $houseNameOrder === true ) ? "ORDER BY 4 " : "" );
		
		//echo $query;
		
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return  "";
		}
		
		while ( $row = mysqli_fetch_assoc( $result ) )
		{
			$stafflist[] = $row;
		}
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return $stafflist;
		
		
	}
	  
	function getStaffRoles()
	{
		$dbHandle = loginToDB();
		$rolelist = array();
		
	 	$query   = "SELECT `RoleID`, `RoleCode`, `RoleName` FROM `StaffRoleLkup` ORDER BY 3";
				
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return  "";
		}
		
		while ( $row = mysqli_fetch_assoc( $result ) )
		{
			$rolelist[] = $row;
		}
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return $rolelist;
	}
	
	function getStaffHouse()
	{
		$dbHandle = loginToDB();
		$staffhouse = array();
		
		//$myfile = fopen("error.txt", "w") or die("Unable to open file!");

	 	$query   = "SELECT b.`HouseName` FROM `Staff` a, `Houses` b WHERE a.`StaffID` = " . $_GET['staffID'] . " and a.`HouseID` = b.`HouseID` and b.`HouseInUse`='Y' ";
		
		//fwrite($myfile,$query);				
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			$staffhouse[] = array( "HouseName" => "" );				
			return  $staffhouse;
		}
		
		if ( mysqli_num_rows($result) == 0 ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );	
			$staffhouse[] = array( "HouseName" => "No House Currently Assigned" );				
			return  $staffhouse;
		}
		
		while ( $row = mysqli_fetch_assoc( $result ) )
		{
			$staffhouse[] = $row;
			//fwrite($myfile, dpp($row));	
		}
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
		
		//fclose($myfile);			
		return $staffhouse;
	}
	
	function getStaffRecord($emplRec, $fromHistory = false )
	{
		$dbHandle = loginToDB();
		
		$history = ($fromHistory) ? "History" : ""; 
		
		$query    = "SELECT a.`StaffID`, `SupervisorID`, `StaffFname`, `StaffMInit`, `StaffLname`, `StaffType`, `StaffInitials`, ";
		$query   .= " `StaffGender`, FormatDateMMDDYYYY(`StaffHireDate`) AS StaffHireDate, `PhoneNum`, `PhoneGateway`, `StaffEmail`, `Status`, ";
		$query   .= " `StatusDate`, `StatusReason`, `StaffRootDir`, `EmergencyContactName`, `EmergencyContactPhone`, `CanAssignClientMeds`, ";
		$query   .= " `EmergencyContactEmail`, `StaffRoleID`, `PositionID`, `HouseID`,  `IsDriver`, `IsQuarantined`, `IsDayStaff`, `IsWeekendStaff`, ";
		$query   .= " `IsPickDropStaff`, `ByPassHouseID`, `AdminByPass`, `IsConfirmed`, `isEmailVerified`, `UsesOwnCar`, `CarIsInsured`, `Username` ";
		$query   .= " FROM `StaffIndicators" . $history . "` b, `Staff" . $history . "` a, `StaffAuthAz" . $history . "` c WHERE a.`StaffID` = b.`StaffID` ";
		$query   .= " AND  a.`StaffID` = c.`StaffID` AND  a.`StaffID` = " . $emplRec['staffname'] . "  ";
 
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			$errorMessage = mysqli_error($dbHandle);
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );								
			return array(FAIL, "Staff record retrieval failed with the following error: " . $errorMessage );
		}
		
		if ( ( mysqli_num_rows($result) == 0 ) || ( mysqli_num_rows($result) > 1 ) ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );	
			return array(FAIL, "Staff record retrieval failed as either Staff record was not found or more than one record was found" );
		}
		
		$row = mysqli_fetch_assoc( $result );
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
		
		//fclose($myfile);			
		return array( SUCCESS, $row );
		
	}
	
	function getActiveClientListing( $houseID )
	{
		$dbHandle = loginToDB();
		$clientlist = array();
		$houseAND = "";
		
	 	$query   = "SELECT a.`ClientID`, a.`ClientFname`, a.`ClientLname`, a.`ResidenceID` ";
		$query .= " FROM `Clients` a ";
		if ( $houseID != MANAGEMENT ) {
			$query .= ", ClientServices b, Houses c ";
			$houseAND = " AND a.`ClientID`=a.`ClientID` AND b.`HouseID`=c.`HouseID` AND c.`HouseID` = " . $houseID . " ";
		}
		$query .= " WHERE `ClientStatus` = 'Open' " . $houseAND . " ORDER BY `ClientFname`, `ClientLname` ";		
		
		//echo $query;
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return  "";
		}
		
		while ( $row = mysqli_fetch_assoc( $result ) )
		{
			$clientlist[] = $row;
		}
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return $clientlist;
	}
	
	function getClientListing()
	{
		$dbHandle = loginToDB();
		$clientlist = array();
		
	 	$query   = "SELECT `ClientID`, `CCS_StaffID`, `SchoolID`, `CCS_StaffAsignDate`, `ClientFname`, `ClientLname`, ";
		$query .= " `ClientAdmisionDate`, `AdultAdmitDate`, `DayAdmitDate`, `ClientSSN`, `ClientBirthDate`, `ParentName`, ";
		$query .= " `ParentPhone`, `ParentEmail`, `ClientCaseNum`, `ClientMedicaidNum`, `ClientRootDir`, `ClientStatus`, `ClientDischargeDate`, "; 
		$query .= " `ClientDischargedSummary`, `IsAwakeOvernight`, `PharmacyID`, `ResidenceID` FROM `Clients` ";
		$query .= " ORDER BY `ResidenceID`, `ClientFname`, `ClientLname` ";		
		
		//echo $query;
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return  "";
		}
		
		while ( $row = mysqli_fetch_assoc( $result ) )
		{
			$clientlist[] = $row;
		}
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return $clientlist;
	}
	
	function getClientListingByResidence( $houseID = MANAGEMENT, $houseNameOrder = false )
	{
	
		$dbHandle = loginToDB();
		$stafflist = array();
		
	 	$query   = "SELECT distinct a.`ClientID`, a.`ResidenceID` as HouseID, concat(a.`ClientFname`, ' ', a.`ClientLname`) as ClientName ";
		$query  .= ( ( $houseNameOrder === true ) ? ", b.`HouseName` " : "" ) . " ";
		$query  .= " FROM `Clients` a, `Houses` b ";
		$query  .= " WHERE a.`ClientStatus`='Open' AND b.`HouseID`=a.`ResidenceID` " . ( ( $houseID == MANAGEMENT ) ? "" : " AND b.`HouseID`=" . $houseID ) . " ";
		$query  .= " AND b.`HouseType` not in ( 'P', 'M' )  AND b.`HouseInUse` = 'Y' ";
		$query  .= ( ( $houseNameOrder === true ) ? " ORDER BY 4, 3 " : " ORDER BY 2, 3" );
		
		//echo $query;
				
		$result = mysqli_query( $dbHandle, $query  );		
				
		if ( mysqli_errno($dbHandle) != 0 ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return  "";
		}
		
		while ( $row = mysqli_fetch_assoc( $result ) )
		{
			$stafflist[] = $row;
		}
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return $stafflist;
	}
	
	function getClientListingByHouse( $houseID = MANAGEMENT, $houseNameOrder = false )
	{
	
		$dbHandle = loginToDB();
		$stafflist = array();
		
	 	$query   = "SELECT distinct a.`ClientID`, a.`ResidenceID`, concat(a.`ClientFname`, ' ', a.`ClientLname`) as ClientName ";
		$query  .= ( ( $houseNameOrder === true ) ? ", b.`HouseName` " : "" ) . " ";
		$query  .= " FROM `Clients` a, `Houses` b, `ClientServices` c ";
		$query  .= " WHERE a.`ClientStatus`='Open' AND a.`ClientID` = c.`ClientID` AND b.`HouseID`=c.`HouseID` " . ( ( $houseID == MANAGEMENT ) ? "" : " AND b.`HouseID`=" . $houseID ) . " ";
		$query  .= ( ( $houseNameOrder === true ) ? " ORDER BY 4, 3 " : " ORDER BY 2, 3" );
		
		//echo $query;
				
		$result = mysqli_query( $dbHandle, $query  );		
				
		if ( mysqli_errno($dbHandle) != 0 ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return  "";
		}
		
		while ( $row = mysqli_fetch_assoc( $result ) )
		{
			$stafflist[] = $row;
		}
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return $stafflist;
	}
	
	function getClientRecord($clientRec)
	{
		$dbHandle = loginToDB();
		
		$query    = "SELECT `ClientID`, `ResidenceID`, `CCS_StaffID`, `SchoolID`, FormatDateMMDDYYYY(`CCS_StaffAsignDate`) AS CCS_StaffAsignDate, `ClientFname`, `ClientLname`, `ClientGender`, ";
		$query   .= "  FormatDateMMDDYYYY(`ClientAdmisionDate`) AS ClientAdmisionDate, FormatDateMMDDYYYY(`AdultAdmitDate`) AS AdultAdmitDate, ";
		$query   .= " FormatDateMMDDYYYY(`DayAdmitDate`) AS DayAdmitDate, `ClientSSN`, FormatDateMMDDYYYY(`ClientBirthDate`) AS ClientBirthDate, `ParentName`, `ParentPhone`, ";
		$query   .= " `ParentEmail`, `ClientCaseNum`, `ClientMedicaidNum`, `ClientRootDir`, `ClientStatus`, ";
		$query   .= "  `IsAwakeOvernight`, `PharmacyID`, `IsEmpScvClient`, `ClientLtssID` FROM `Clients` WHERE `ClientID` = " . $clientRec['clientname'];		
		
		//echo $query;
		
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			$errorMessage = mysqli_error($dbHandle);
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );								
			return array(FAIL, "Client record retrieval failed with the following error: " . $errorMessage );
		}
		
		if ( ( mysqli_num_rows($result) == 0 ) || ( mysqli_num_rows($result) > 1 ) ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );	
			return array(FAIL, "Client record retrieval failed as either Client record was not found or more than one record was found" );
		}
		
		$row = mysqli_fetch_assoc( $result );
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
		
		//fclose($myfile);			
		return array( SUCCESS, $row );
		
	}
	
	
	
	function getClientsForHouse( $houseID = 1, $clientID = -1, $forBus = '' )
	  {
				$dbHandle = loginToDB();

				$sel = "";
	
				$ANDHOUSE = "";
				if ( $houseID != MANAGEMENT )
				{
					$ANDHOUSE = "HouseID = " . $houseID . " AND ";
				}
				
				$hgroups = array ();
				$counts = array();
				$query  = "select HouseID, HouseName from Houses  WHERE  HouseInUse = 'Y'  order by 2";
				//$query  = "select HouseID, HouseName from Houses  WHERE " . $ANDHOUSE . " HouseInUse = 'Y'  order by 2";
				$result = mysqli_query( $dbHandle, $query  );
				while ( $row = mysqli_fetch_row( $result ) )
				{
					$hgroups[$row[0]] = "<optgroup label=\"" . $row[1] . "\">";
					$counts[$row[0]] = 0;
				}					
				
				$rtn = ""; 	
				
				if ( $forBus == 'Y' )
				{
					$query  = "SELECT DISTINCT HouseID FROM SchoolBuses";
				}
				else
				{
					$query  = "SELECT DISTINCT HouseID FROM Houses";
				}
				$validHouses = array ();
				
				$result = mysqli_query( $dbHandle, $query  );
				while ( $row = mysqli_fetch_row( $result ) )
				{
					$validHouses[$row[0]] =  $row[0];
				}	
				//echo dpp($validHouses);
				//$query  = "select ClientID, ClientFname, ClientLname, HouseID from Clients  WHERE ClientType = 'Y' AND houseType in ( 'B', 'Y' ) AND ";
				$query  = "select a.ClientID, CONCAT( a.ClientFname, ' ', a.ClientLname ) AS ClientName, a.HouseID from Clients a, Houses b  WHERE  a.HouseID = b.HouseID and HouseInUse = 'Y'  AND ";

				$query .= ( $houseID == MANAGEMENT ) ? "" : ( " a.HouseID = " . $houseID . " AND " );

				$query .= " UPPER(a.ClientStatus) = 'OPEN'";

//echo $query;

				$result = mysqli_query( $dbHandle, $query  );
//echo $query;
				while ( $row = mysqli_fetch_row( $result ) )
				{

//echo $clientID . " == " . $row[0] . " == " . trim( $row[1] ) . " " . trim( $row[2] ) . '<br>';

					if (in_array($row[3], $validHouses)) {

						$sel = ( $clientID == $row[0] ) ? "selected=\"selected\"" : "";
						$ename = trim( $row[1] ) ;
						//if ( $houseID == 0 )
						//{
							$hgroups[$row[3]] .= ( "<option value=\"" . $row[0] . "\" " . $sel . ">" .  $ename. "</option>");
							$counts[$row[3]] += 1;
						//}
						//else
						//{
						//	$rtn .=  ( "<option value=\"" . $row[0] . "\" " . $sel . ">" .  $ename. "</option>");
						//}
					}
				}
          			
                               // Free result set
                               if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }


		closeDB( $dbHandle );
				//if ( $houseID == 0 )
				//{
				//echo pp($hgroups);
					//asort($hgroups);
					//echo pp($hgroups);
					
					//for( $i = 1; $i <= count($hgroups); $i++ )
					foreach( $hgroups as $k => $val )
					{
						$hgroups[$k] .= "</optgroup>";
						//if ( $counts[$i] > 0  ) {
						//	$rtn .= $hgroups[$i] . " ";
						//}
					}
					
					foreach( $hgroups as $k => $val )
					{
						if ( $counts[$k] > 0  ) {
							$rtn .= $val . " ";
						}
					}
					
					//$rtn = implode( " ", $hgroups );
				//}
//echo $rtn;
				return $rtn;
	  }
	
	function getAwakeClientsForHouse( $houseID = 1 )
  	{
			$dbHandle = loginToDB();
			$clients = array();
			
			$ANDHOUSE = "";
			if ( $houseID != MANAGEMENT )
			{
				$ANDHOUSE = "HouseID = " . $houseID . " AND ";
			}
			
			$query  = "select a.ClientID, CONCAT( a.ClientFname, ' ', a.ClientLname ) AS ClientName, a.ResidenceID as HouseID, b.HouseName from Clients a, Houses b  WHERE  a.ResidenceID = b.HouseID and b.HouseInUse = 'Y'  AND a.IsAwakeOvernight='Y' AND ";

			$query .= ( $houseID == MANAGEMENT ) ? "" : ( " a.ResidenceID = " . $houseID . " AND " );
			$query .= " UPPER(a.ClientStatus) = 'OPEN' ORDER by 4,2 ";

			//echo $query;
			
			$result = mysqli_query( $dbHandle, $query  );
			while ( $row = mysqli_fetch_assoc( $result ) )
			{
					$clients[] = $row;
			}
				
		   // Free result set
		   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }


			closeDB( $dbHandle );
			return $clients;
  	}
	
	function getAwakeOptions()
	{
		$rtnArray = array();
		$dbHandle    = loginToDB();
		
		$query  = "SELECT awakeCd, awakeDescription FROM AwakeOvernightLkup";
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno( $dbHandle ) == 0 )
		{
			while ( $row = mysqli_fetch_row( $result ) )
			{
				$retStr[$row[0]] = $row[1];
			}
          			
                               // Free result set
                               if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }


		closeDB( $dbHandle );
			return $retStr; 			
		}
	}
	
	function getCorpInfo()
	{
		$retStr = array();
		$dbHandle    = loginToDB();
		
		$query  = "SELECT * FROM `CorporateInformation`";
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno( $dbHandle ) == 0 )
		{
			while ( $row = mysqli_fetch_assoc( $result ) )
			{
				$retStr[] = $row;
			}
          			
		   // Free result set
		   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }


			closeDB( $dbHandle );
			return $retStr; 			
		}
	}
	
	function  getMissionComponents()
	{
		$retStr = array();
		$dbHandle    = loginToDB();
		
		$query  = "SELECT * FROM `CorpKeyComponents`";
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno( $dbHandle ) == 0 )
		{
			while ( $row = mysqli_fetch_assoc( $result ) )
			{
				$retStr[] = $row;
			}
          			
		   // Free result set
		   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }


			closeDB( $dbHandle );
			return $retStr; 			
		}
	}
	
	function  getMissionValues()
	{
		$retStr = array();
		$dbHandle    = loginToDB();
		
		$query  = "SELECT * FROM `CorpMissionValues`";
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno( $dbHandle ) == 0 )
		{
			while ( $row = mysqli_fetch_assoc( $result ) )
			{
				$retStr[] = $row;
			}
          			
		   // Free result set
		   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }


			closeDB( $dbHandle );
			return $retStr; 			
		}
	}
	
	
	function  getAgencyObjectives()
	{
		$retStr = array();
		$dbHandle    = loginToDB();
		
		$query  = "SELECT * FROM `AgencyObjectives`";
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno( $dbHandle ) == 0 )
		{
			while ( $row = mysqli_fetch_assoc( $result ) )
			{
				$retStr[] = $row;
			}
          			
		   // Free result set
		   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }


			closeDB( $dbHandle );
			return $retStr; 			
		}
	}
	
	function  getAgencyGoals()
	{
		$retStr = array();
		$dbHandle    = loginToDB();
		
		$query  = "SELECT * FROM `AgencyGoals`";
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno( $dbHandle ) == 0 )
		{
			while ( $row = mysqli_fetch_assoc( $result ) )
			{
				$retStr[] = $row;
			}
          			
		   // Free result set
		   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }


			closeDB( $dbHandle );
			return $retStr; 			
		}
	}
	
	function saveRedirectURL( $redirectID, $redirectURL  )
	{
		$dbHandle = loginToDB();
		
	 	$query  = "REPLACE INTO `Redirects`(`RedirectID`, `RedirectURL`) VALUES ( '";
		$query .= $redirectID. "', '" . sql_quote( $dbHandle, $redirectURL ) . "' ";
		$query .= " )";
								
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return  "";
		}
		
		//$row = mysqli_fetch_assoc( $result );
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		//return $row['URL'];
	}
	
	function deleteRedirectURL( $redirectID )
	{
		$dbHandle = loginToDB();
		
	 	$query  = "DELETE FROM `Redirects` WHERE `RedirectID`='" . $redirectID . "'";
								
		$result = mysqli_query( $dbHandle, $query  );		
				
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return 0;
	}
	
	function getRedirectURL( $redirectID )
	{
		$dbHandle = loginToDB();
		
	 	$query   = "SELECT `RedirectID`, IFNULL(`RedirectURL`, 0) AS RedirectURL FROM `Redirects` WHERE `RedirectID`='" . $redirectID . "'";
									
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( ( mysqli_errno($dbHandle) != 0 ) || ( mysqli_num_rows($result) == 0 ) ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return  "0";
		}
		
		$row = mysqli_fetch_assoc( $result );
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
		
		deleteRedirectURL( $redirectID );
					
		return $row['RedirectURL'];
	}
	
	function startSession( $sessionID, $staffID, $dbHndl = null )
	{
			$dbHandle =  ( $dbHndl == null ) ? loginToDB() : $dbHndl;
			$newtime = time();

			$query = "INSERT INTO Sessions ( SessionID, StaffID, SessionTime ) VALUES ( '" . $sessionID . "', " . $staffID . ", " . $newtime . " )";
			$query .= " ON DUPLICATE KEY UPDATE SessionID = '" . $sessionID . "', SessionTime = " . $newtime . "";
			//echo $query;
			
			$result = mysqli_query( $dbHandle, $query  );

			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			
			if ( mysqli_errno( $dbHandle ) != 0 )
			{
				if  ( $dbHndl == null ) {
					closeDB( $dbHandle );
				}
				return false;
			}
			else
			{
				if  ( $dbHndl == null ) {
					closeDB( $dbHandle );
				}
				return true;
			}
	  }

	  function getSessionTime( $id = null )
	  {
			$dbHandle = loginToDB();

			if ( isset( $id ) )
			{
				$query  = "SELECT COALESCE( `SessionTime`, 0 ) as  SessionTime FROM Sessions WHERE SessionID = '" . $id . "'";
				$result = mysqli_query( $dbHandle, $query  );
				$row = mysqli_fetch_assoc( $result );
				
			    // Free result set
			    if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
				closeDB( $dbHandle );

				return $row['SessionTime'];

			}
			else
				return 0;
	  }

	  function updateSession( $id = null )
	  {
			$dbHandle = loginToDB();
			$newtime = time();

			$query  = "UPDATE Sessions SET SessionTime = " . $newtime  .  " WHERE SessionID = '" . $id . "'";
			$result = mysqli_query( $dbHandle, $query  );
				
			// Free result set
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
	  }

      function deleteSession( $id = null )
	  {
			$dbHandle = loginToDB();
			$delQuery = "DELETE FROM Sessions WHERE SessionID = '" . $id . "'";

			$result = mysqli_query( $dbHandle, $delQuery );
				
		    // Free result set
		    if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
	  }
	  
	function getPharmacyDetails( $formdata )
	{
		$dbHandle = loginToDB();
		$rtn = "";
		
		$query  = "SELECT * FROM `Pharmacies` WHERE `PharmacyID` = " . $formdata['pharmID'] . "";
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno( $dbHandle ) != 0 )
		{
						
		   // Free result set
		   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
	
			closeDB( $dbHandle );
			return array( FAIL, mysqli_error( $dbHandle ));
		}
		$row = mysqli_fetch_assoc( $result );
		return array( SUCCESS, $row );	
	}
		
	function getPharmacies( $clientID = 0 )
	{
		$dbHandle = loginToDB();
		$rtn = array();
		
		$pharmacyAND = "";
		
		if ( $clientID != 0 )
		{
			$query  = "SELECT PharmacyID FROM  `Clients` where ClientID = " . $clientID . "";
			$result = mysqli_query( $dbHandle, $query  );
			$row = mysqli_fetch_assoc( $result );
			$pharmacyID = $row['PharmacyID'];
			
			$pharmacyAND = " `PharmacyID` = " . $pharmacyID . " AND ";
			
			// Free result set
		   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		}
		 
		$query  = "SELECT distinct a.* FROM  `Pharmacies` a where " . $pharmacyAND . " `Discontinued` = 'N'";
		//echo $query;
		
		$result = mysqli_query( $dbHandle, $query  );
		while ( $row = mysqli_fetch_assoc( $result ) )
		{
			$rtn[] =  $row;
		}
						
	   // Free result set
	   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
	
		closeDB( $dbHandle );
		return $rtn;
	}

	function getProviders( $providerID = 0 )
	{
		$dbHandle = loginToDB();
		$rtn = array();
		
		if ( $providerID != 0 )
		{
			$query  = "SELECT ProviderID FROM  `Providers` where ProviderID = " . $providerID . "";
			$result = mysqli_query( $dbHandle, $query  );
			$row = mysqli_fetch_assoc( $result );
			$providerID = $row['ProviderID'];
			
			// Free result set
		   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		}
		 
		$query  = "	SELECT `ProviderID`, `ProviderName` FROM `Providers` WHERE `Discontinued` = 'N' ORDER BY 2";
		//echo $query;
		
		$result = mysqli_query( $dbHandle, $query  );
		while ( $row = mysqli_fetch_assoc( $result ) )
		{
			$rtn[] =  $row;
		}
						
	   // Free result set
	   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
	
		closeDB( $dbHandle );
		return $rtn;
	}
	
	function getPrimaryDoctors()
	{
		$retStr = array();
		$dbHandle    = loginToDB();
		$query  = "SELECT `ProviderID`, `ProviderName` FROM `Providers` Order by 2 ";
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno( $dbHandle ) == 0 )
		{
			while ( $row = mysqli_fetch_assoc( $result ) )
			{
				$retStr[] =  $row;
			}
          			
		   // Free result set
		   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

			closeDB( $dbHandle );
			return $retStr;
		}
		else
			return array();
		
	}
	
	function getProviderTypes()
	{
		$retStr = array();
		$dbHandle    = loginToDB();
		$query  = "SELECT * FROM `ProviderTypeLkup` order by 2";
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno( $dbHandle ) == 0 )
		{
			while ( $row = mysqli_fetch_assoc( $result ) )
			{
				$retStr[] =  $row;
			}
          			
		   // Free result set
		   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

			closeDB( $dbHandle );
			return $retStr;
		}
		else
			return array();
	}
	
	function getProviderDetails( $formdata )
	{
		$dbHandle = loginToDB();
		$rtn = "";
		
		$query  = "SELECT * FROM `Providers` WHERE `ProviderID` = " . $formdata['providerID'] . "";
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno( $dbHandle ) != 0 )
		{
						
		   // Free result set
		   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
	
			closeDB( $dbHandle );
			return array( FAIL, mysqli_error( $dbHandle ));
		}
		$row = mysqli_fetch_assoc( $result );
		return array( SUCCESS, $row );	
	}
	
	function getCCS_StaffListing( $ssType = 'C', $clientID = 0 )
  	{
		$dbHandle = loginToDB();
		$retStr = array();
		
		$clientTable = ( $clientID == 0 ) ? "" : ", `Clients` b";
		$clientIDAND = ( $clientID == 0 ) ? "" : " AND a.`CCS_StaffID` = b.`CCS_StaffID` AND b.`ClientID` = " . $clientID;
		
		$query  = " SELECT a.`CCS_StaffID`, a.`CCS_StaffName`, a.`ssType` ";
		$query .= " FROM `CCS_Staff` a " . $clientTable;
		$query .= " WHERE a.`Status` = 'Active' " . $clientIDAND;
		$query .= " AND a.`ssType` = '" . $ssType . "' AND a.`Status` = 'Active'" ;
		$query .= " ORDER BY 2";
		
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno( $dbHandle ) == 0 )
		{
			while ( $row = mysqli_fetch_assoc( $result ) )
			{
				$retStr[] =  $row;
			}
          			
		   	// Free result set
		   	if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

			closeDB( $dbHandle );
			return $retStr;
		}
		else {
			// Free result set
		    if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			return array();
		}
  	}
	
	function getCCS_ClientListing()
  	{
		$dbHandle = loginToDB();
		$retStr = array();
			
		$query  = " SELECT concat(a.`ClientFname`, ' ', a.`ClientLname`) as ClintName, b.`CCS_StaffName`,   ";
		$query .= " FormatDateMMMDYYYY(a.`CCS_StaffAsignDate`) as CCS_StaffAsignDate ";
		$query .= " FROM `Clients` a, `CCS_Staff` b WHERE a.`CCS_StaffID`=b.`CCS_StaffID` AND a.`ClientStatus`='Open'";
		$query .= " ORDER BY 2, 1";
		
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno( $dbHandle ) == 0 )
		{
			while ( $row = mysqli_fetch_assoc( $result ) )
			{
				$retStr[] =  $row;
			}
          			
		   	// Free result set
		   	if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

			closeDB( $dbHandle );
			return $retStr;
		}
		else {
			// Free result set
		    if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			return array();
		}
  	}
	
	function getCCS_StaffName( $staffID = 0, $history = 'History' )
  	{
		$dbHandle = loginToDB();
		$retStr = array();
		
		$query  = " SELECT a.`CCS_StaffName` FROM `CCS_Staff" . $history . "` a WHERE a.`CCS_StaffID` = " . $staffID;
		//echo $query;
		
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno( $dbHandle ) == 0 )
		{
			$row = mysqli_fetch_assoc( $result );
          			
		   	// Free result set
		   	if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

			closeDB( $dbHandle );
			return $row['CCS_StaffName'];
		}
		else {
			// Free result set
		    if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			return "";
		}
  	}
	
	function getCCS_StaffDetails( $formdata )
	{
		$dbHandle = loginToDB();
		$rtn = "";
		
		$query  = "SELECT * FROM `CCS_Staff` WHERE `CCS_StaffID` = " . $formdata['staffname'] . "";
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno( $dbHandle ) != 0 )
		{
						
		   // Free result set
		   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
	
			closeDB( $dbHandle );
			return array( FAIL, mysqli_error( $dbHandle ));
		}
		$row = mysqli_fetch_assoc( $result );
		return array( SUCCESS, $row );	
	}
	
	function getMyServicesProvided()
	{
		global $agency_info;
		
		$dbHandle = loginToDB();
		$servicesPrvd = array();
		
		$services = array_keys($agency_info['services_provided'] );
		
		$query  = "SELECT  a.`ServiceID`, a.`Name` as ServiceName FROM `ServicesProvidedLkup` a ";
		$query .= "WHERE a.`ServiceID` in ( " . implode(", ", $services ) ;
		
		$query .= " ) ";
				
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return "";
		}
		
		while ( $row = mysqli_fetch_assoc( $result ) )
		{
			$servicesPrvd[] = $row;
		}
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return $servicesPrvd;
	}
	
	function getStaffInitials($staffID, $dbHandle = NULL )
	{

		$closeIt = 0;
		if ( ! $dbHandle )
		{
			$dbHandle = loginToDB();
			$closeIt = 1;
		}
		$query = "SELECT `StaffInitials` FROM `Staff` WHERE `StaffID` = " . $staffID ;

//echo "<br>" . $query;

		$result = mysqli_query( $dbHandle, $query  );



		$row = mysqli_fetch_assoc( $result );

		// Free result set
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }


		if ( $closeIt == 1)
			closeDB( $dbHandle );
				
		return $row['StaffInitials'];



	}
		
	function getProgramClients( $programRec = '', $byHouse = false )
	{
		$dbHandle = loginToDB();
		$clientlist = array();
		if ( isset($programRec['attendancemonth'] ) ) {
			list( $atMonth, $atYear ) = explode("/", $programRec['attendancemonth'] );
			$attendaceMonth = implode( "", array( $atYear, $atMonth ));
		}
		else {
			$attendaceMonth = date('Ym');
		}
		
		global $DAY_REHABILITATION_SERVICES, $PERSONAL_SUPPORTS;
			
		if ( isset($_GET['programID']) ) {
			$programRec = array();
			$programRec['programID'] = $_GET['programID'];
			$programRec['houseID'] = $_GET['houseID'];
		}
		if ( isset($_POST['programID']) ) {
			$programRec = array();
			$programRec['program'] = $_POST['programID'];
			$programRec['attendancemonth'] = ( isset( $_POST['attendancemonth'] ) ) ? $_POST['attendancemonth'] : $attendaceMonth;
			$programRec['houseID'] = ( isset($_POST['houseID']) ? $_POST['houseID'] : '' );
		}
			
		//echo dpp($programRec);
			
		$whereClause = "";
		if ( is_numeric( $programRec['program'] ) ) {
			$whereClause = " WHERE ( a.`ClientID` = b.`ClientID` AND b.`ServiceID` = ". $programRec['program'];
			if ( isset($programRec['attendancemonth'] ) ) {
				$whereClause .=  " AND ( ( $attendaceMonth >= DATE_FORMAT( b.`StartDate`,'%Y%m') AND b.`EndDate` is NULL ) OR  ";
				$whereClause .=  " ( $attendaceMonth BETWEEN DATE_FORMAT( b.`StartDate`,'%Y%m') and date_format(`EndDate`, '%Y%m') ) ) ";
			}
			else {
				$whereClause .=  " AND ( $attendaceMonth >= DATE_FORMAT( b.`StartDate`,'%Y%m') AND b.`EndDate` is NULL ) ";
			}
			if ( $byHouse === true ) {
				$whereClause .= " AND c.`HouseID` = b.`HouseID` AND HouseID = " . $programRec['houseID'];
			}
			$whereClause .= " ) ";
			
			if ( in_array( $programRec['program'], $DAY_REHABILITATION_SERVICES ) )  {
				//$whereClause .= " OR ( IsDayClient = 'Y' ) ";
			}

		}
		else  if ( $byHouse === true  ) {
			$whereClause = " WHERE c.`HouseID` = b.`HouseID` AND c.`HouseID` = ". $programRec['houseID'];
		}
		else {
			$whereClause = " WHERE a.`ClientID` = b.`ClientID`  AND c.`HouseID` = b.`HouseID` ";
		}
			
		//echo 	$whereClause;
		
		$dateColumn = ( in_array($programRec['program'], $DAY_REHABILITATION_SERVICES ) ) ? ", DATE_FORMAT(a.`DayAdmitDate`, \"%Y%m%d\" ) " : ( ( in_array($programRec['program'], $PERSONAL_SUPPORTS )) ? ", DATE_FORMAT(a.`ClientAdmisionDate`, \"%Y%m%d\" ) " : ", DATE_FORMAT(a.`AdultAdmitDate`, \"%Y%m%d\" ) " );
		$dateColumn .= " AS ClientStartDate ";
	 	$query  = "SELECT distinct a.`ClientID`, CONCAT( a.`ClientFname`, ' ', a.`ClientLname` ) As ClientName, b.`HouseID`  ";
		$query .= $dateColumn . " FROM `Clients` a, `ClientServices` b, `Houses` c ";
		$query .=  $whereClause . " ORDER BY `ClientName`";		
				
		//echo $query;
				
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			$error = mysqli_error($dbHandle);
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return  array( FAIL, $error );
		}
				
		while ( $row = mysqli_fetch_assoc( $result ) )
		{
			$clientlist[] = $row;
		}
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
			
		//echo dpp($clientlist);		
		return array( SUCCESS, $clientlist );
	}
	
	/*
	function getMedicationName( $inMedID, $handle = -1 )
	{
		$dbHandle    = ( $handle == -1 ) ? loginToDB() : $handle;
		if ( strpos($inMedID, "-") !== false )
	    {
		    list( $medID, $seqID ) = explode( "-", $inMedID );
		    $seqAND = " and SeqID = " . $seqID;
	    }
	    else
		    $medID = $inMedID;
			  
		$query  = "SELECT  MedName FROM Medications where MedID = " . $medID;
		//echo $query . "<br />";
		$result = mysqli_query( $dbHandle, $query  );
		$row = mysqli_fetch_row( $result );
		if ( $handle == -1 ) {
				
		   // Free result set
		   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		   closeDB( $dbHandle ); 
		}
		return $row[0];
	}
	
	
		function getMARClientMedications( $formdata, $dupsOK = FALSE )
		{
			$retMedAdmin = $retPRNMedAdmin = $retFYIMedAdmin = array();
			$clientName = getClientName($formdata['clientID']);
			$dbHandle    = loginToDB();
			
			$getDistinct = ( $dupsOK === TRUE ) ? "" : " distinct ";
			$query  = "SELECT  " . $getDistinct . " a.MedID, b.MedName, a.MedDosage, a.SeqID, a.MedTime, date_format(a.`StartDate`, '%m/%d/%Y' ) as 'StartDate',
			a.TimeKey, a.Direction, a.`StartDate`, a.`MedType` FROM ClientMedications a, Medications b where a.ClientID = " . $formdata['clientID'] . " and a.MedID = b.MedID and a.MedStatus != 'Discontinued' and a.`MedProgram` = '" . sql_quote( $dbHandle,  $formdata['programCd'] ) . "'";
			$query  .= " UNION ";
			$query  .= "SELECT  " . $getDistinct . " a.MedID, b.MedName, a.MedDosage, a.SeqID, a.MedTime, date_format(a.`StartDate`, '%m/%d/%Y' ) as 'StartDate',
			a.TimeKey, a.Direction, a.`StartDate`, a.`MedType` FROM ClientMedicationsHistory a, Medications b where a.ClientID = " . $formdata['clientID'] . " and a.MedID = b.MedID and a.MedStatus != 'Discontinued' and a.`MedProgram` = '" . sql_quote( $dbHandle,  $formdata['programCd'] ) . "'";
			$query  .= " ORDER BY 9, 1, 7, 4 ";
			
			//echo $query;
			
			$result = mysqli_query( $dbHandle, $query  );
			
			$i = $j = $k = 1;
			while ( $row = mysqli_fetch_row( $result ) )
			{	
				if ( $row[9] == 'P' )	
					$retPRNMedAdmin[$k++] = $row;
				else if ( $row[9] == 'F' )
					$retFYIMedAdmin[$j++] = $row;
				else				
					$retMedAdmin[$i++] = $row;
			}
          			
                               // Free result set
                               if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }


		closeDB( $dbHandle );
			return array( $retMedAdmin, $retFYIMedAdmin, $retPRNMedAdmin );
		}
	*/
		
	function getClientsMedications( $medParms, $dupsOK = FALSE )
	{
			global $CLIENTREF;
			$retMedAdmin = array();
			$dbHandle    = loginToDB();
			
			$programAND = "";
			if ( is_array ( $medParms ) )
			{
				$clientID = $medParms['clientID'];
				$programCd = $medParms['programID'];
				if ( $medParms['programID'] != 'A' ) {
					$programAND = " and a.ServiceID = " . $programCd . " ";
				}
			}
			else {
				$clientID = $medParms;
			}
				
			$getDistinct = ( $dupsOK === TRUE ) ? "" : " distinct ";
			$query  = "SELECT  " . $getDistinct . " a.MedID, b.MedName, a.MedDosage, a.Direction, a.SeqID, FormatDateMMDDYYYY(a.`AdminDate`) AS PrescriptionDate, ";
			$query .= " a.MedTime, FormatDateMMDDYYYY(a.`StartDate`) AS StartDate, a.TimeKey, a.ServiceID, a.MedStatus, a.MedType FROM ClientsMedications a, Medications b ";
			$query .= " where a.ClientID = " . $clientID . " and a.MedID = b.MedID " . $programAND . " and a.MedStatus != 'Discontinued' ORDER BY 2, 5";
			
			//echo $query;
			$result = mysqli_query( $dbHandle, $query  );
			if ( mysqli_num_rows($result) == 0 ) {
							
				// Free result set
		   		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
				
				closeDB( $dbHandle );
				return array( FAIL, "There are no medications to update for " . ( isset($CLIENTREF) ? rtrim(trim($CLIENTREF), "s") : 'Client ' ) . " ( " . getClientName( $clientID ) . " ) " );
				
			}
						
			while ( $row = mysqli_fetch_assoc( $result ) )
			{	
				$retMedAdmin[] = $row;
			}
          			
		   // Free result set
		   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

			closeDB( $dbHandle );
			return array( SUCCESS, $retMedAdmin );
		}
		
	function getClientMedicationDetail( $medParms )
	{
			global $CLIENTREF;
			$retMedAdmin = array();
			$dbHandle    = loginToDB();
			
			$medParmsArr = explode("-", $medParms );
			
			$query  = "SELECT  " . $getDistinct . " a.MedID, b.MedName, a.MedDosage, a.Direction, a.SeqID, FormatDateMMDDYYYY(a.`AdminDate`) AS PrescriptionDate, ";
			$query .= " a.MedTime, FormatDateMMDDYYYY(a.`StartDate`) AS StartDate, a.TimeKey, a.ServiceID, a.MedStatus, a.MedType FROM ClientsMedications a, Medications b, Clients c";
			$query .= " where a.ClientID = " . $medParmsArr[0] . " and a.MedID = " . $medParmsArr[1] . "  and SeqID = " . $medParmsArr[2] . " "; 
			$query .= " and a.TimeKey = " . $medParmsArr[3] . " and a.ServiceID = " . $medParmsArr[4] . " and ";
			$query .= " a.ClientID = c.ClientID  and a.MedID = b.MedID and a.ServiceID = c.ClientServiceID  and a.MedStatus != 'Discontinued' ORDER BY 2, 5";
			
			//echo $query;
			$result = mysqli_query( $dbHandle, $query  );
			if ( mysqli_num_rows($result) == 0 ) {
							
				// Free result set
		   		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
				
				closeDB( $dbHandle );
				return array( FAIL, "There are no medications to update for " . ( isset($CLIENTREF) ? rtrim(trim($CLIENTREF), "s") : 'Client ' ) . " ( " . getClientName( $clientID ) . " ) " );
				
			}
						
			while ( $row = mysqli_fetch_assoc( $result ) )
			{	
				$retMedAdmin[] = $row;
			}
          			
		   // Free result set
		   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

			closeDB( $dbHandle );
			return array( SUCCESS, $retMedAdmin );
	}
		
	function getPhoneGateways( $clientID = 0 )
	{
			$dbHandle = loginToDB();
			$rtn = "";
				
			if ( $clientID != 0 )
			{
				$query  = "SELECT PhoneGateway FROM  `Staff` where StaffID = " . $clientID . "";
						
				$result = mysqli_query( $dbHandle, $query  );
				if ( mysqli_num_rows($result) == 0 ) {
					$query  = "SELECT PhoneGateway FROM  `StaffHistory` where StaffID = " . $clientID . "";
						
					$result = mysqli_query( $dbHandle, $query  );
				}
				$row = mysqli_fetch_row( $result );
				$gatewayID = $row[0];
			}
			
			$query  = "SELECT distinct a.* FROM  `PhoneGateways` a ";
			
			$result = mysqli_query( $dbHandle, $query  );
			while ( $row = mysqli_fetch_row( $result ) )
			{
			//echo "Gateway = " . $gatewayID . " and row[0] = " . $row[0] ;
				$slctd = "";
				if ( $gatewayID == $row[0] ) { $slctd = " selected "; }
				$rtn .=  ( "<option  value=\"" . $row[0] . "\" " . $slctd . ">" .  $row[2] . "</option>");
			}
							
		   // Free result set
		   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		
		
			closeDB( $dbHandle );
			return $rtn;
	}
	
	function getStaffUsername( $staffID = -1 )
  	{
		$dbHandle = loginToDB();

		$query  = "select rtrim(Username) from StaffAuthAz where StaffID = " .  $staffID; 
		$result = mysqli_query( $dbHandle, $query  );
		$row = mysqli_fetch_row( $result );
				
	   // Free result set
	   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

		closeDB( $dbHandle );
		return $row[0];
  	}
	
	function getStaffName( $staffID = -1 )
  	{
		$dbHandle = loginToDB();

		$query  = "select rtrim(StaffFname), coalesce(trim(StaffMInit), '' ), rtrim(StaffLname) from Staff where StaffID = " .  $staffID; 
		//echo $query;
		
		$result = mysqli_query( $dbHandle, $query  );
		$row = mysqli_fetch_row( $result );
				
	   // Free result set
	   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

	   closeDB( $dbHandle );
	   return $row[0] . (( $row[1] == '' ) ? " " : ( $row[1] . ". " )) .  $row[2];
  	}
	
	/*
	function getCCS_StaffName( $staffID = -1 )
  	{
		$dbHandle = loginToDB();

		$query  = "SELECT `CCS_StaffName` FROM `CCS_Staff` WHERE `Status`='Active' AND `CCS_StaffID`= " .  $staffID; 
		//echo $query;
		
		$result = mysqli_query( $dbHandle, $query  );
		$row = mysqli_fetch_row( $result );
				
	   // Free result set
	   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

	   closeDB( $dbHandle );
	   return $row[0];
  	}
	*/
	
	function getSickVacationHours( $staffID )
	{
		$dbHandle = loginToDB();
		$hours = array();
		
		$query   = "SELECT a.`RequestTypeID`, b.`RequestName`, a.`CarryOverHours`, a.`HoursGranted`, a.`HoursAvailable`, a.`HoursUsed` FROM `TimeOffHoursUsed` a, `TimeOffRequestLkup` b "; 
		$query  .= " WHERE a.`RequestTypeID`=b.`RequestTypeID` and curdate() between a.`AnnivStartDate` and a.`AnnivEndDate` and a.`StaffID`=" . $staffID . " ";

		$result = mysqli_query( $dbHandle, $query  );

		while ($row = mysqli_fetch_assoc($result)) {
			$hours[] = $row;
		}

		// Free result set
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );		
		return $hours;
	}
	
	//
	// Get Unapproved Time Off Requests
	//
	function getUnapprovedTimeOffRequests( $staffID )
	{
		$dbHandle = loginToDB();
		$requests = array();
		
		$query   = "Select a.`RequestID`, a.`RequestMonth`, a.`RequestDay`, a.`RequestYear`, b.`RequestName`, a.`HoursRequested`, a.`RequestTypeID` FROM `TimeOffRequest` a, `TimeOffRequestLkup` b ";
		$query  .= " WHERE a.`StaffID`=" . $staffID . " AND a.`RequestTypeID` = b.`RequestTypeID` order by 4, 2, 3, 5 ";

		$result = mysqli_query( $dbHandle, $query  );

		while ($row = mysqli_fetch_assoc($result)) {
			$requests[] = $row;
		}

		// Free result set
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );		
		return $requests;
	}
	
		function getTimeOffStaffListing( $staffID, $adminType )
	  	{
			$dbHandle = loginToDB();
			$houseOptGroups = array();
			$tempStaffList = array();
			$stafflist =  "";
			
			$query  = "SELECT `HouseID`,`HouseName` FROM `Houses` WHERE `HouseInUse`='Y'";
			$result = mysqli_query( $dbHandle, $query  );
			while ( $row = mysqli_fetch_row( $result ) )
			{
				$houseOptGroups[$row[0]] = "<optgroup label='" . $row[1] . "'>";
			}
			
			if ( $adminType == ADMINISTRATOR ||  $adminType == IT_STAFF ) {
				$query  = "select a.StaffID, StaffFname, StaffLname, StaffEmail, HouseID from Staff a, StaffIndicators b where  a.StaffID = b.StaffID and Status = 'Active'";
			}
			else {
				$query  = "select a.StaffID, StaffFname, StaffLname, StaffEmail, HouseID from Staff a,  StaffIndicators b where SupervisorID=" . $staffID . " and a.StaffID = b.StaffID and Status = 'Active'" . $mgmtand;
			}
			
			//echo $query;
			
			
			
			$result = mysqli_query( $dbHandle, $query  );
			while ( $row = mysqli_fetch_row( $result ) )
			{
				$tempStaffList[] = $row;
			}
			
			foreach( $houseOptGroups as $houseID => $optVal )
			{
				$keep = false;
				for( $i = 0; $i < count($tempStaffList); $i++ )
				{
					if ( $houseID == $tempStaffList[$i][4] ) { $keep = true; }
				}
				if ( $keep === false ) { unset($houseOptGroups[$houseID]); }
			}
			
			for( $i = 0; $i < count($tempStaffList); $i++ )
			{
				$ename = ucwords(trim( $tempStaffList[$i][1] ) . " " . trim( $tempStaffList[$i][2] ));
				$selected =  "";
				$houseOptGroups[$tempStaffList[$i][4]] .=  ( "<option value=\"" . $tempStaffList[$i][0] . "\"" . $selected . ">" .  $ename . "</option>");
			}
				
			/*
			while ( $row = mysqli_fetch_row( $result ) )
			{
				$ename = ucwords(trim( $row[1] ) . " " . trim( $row[2] ));
				$selected =  "";
				$houseOptGroups[$row[4]] .=  ( "<option value=\"" . $row[0] . "\"" . $selected . ">" .  $ename . "</option>");
			}
			*/
			
		   // Free result set
		   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }


			closeDB( $dbHandle );
			
			//if ( $admin != 0 ) {
			//	unset($houseOptGroups[0]);
			//}
			foreach( $houseOptGroups as $akey => $avalue )
			{
				$stafflist .= ( $avalue . "</optgroup><br>" );
			}
			//echo "<br /><br />" . $mstafflist . "<br /><br />" . $stafflist;;
			return $stafflist;
		}
	
		
	  function getStaffDetails( $formdata, $formerStaff = 0 )
	  {
	  		$retArray = array();
	  		$dbHandle = loginToDB();
		
			$query  = "SELECT a.`StaffID`, b.`HouseID`, `StaffFname`, `StaffMInit`, `StaffLname`, `PhoneNum`, `StaffEmail`, `StaffInitials`, `StaffRoleID`, `IsDayStaff`, `IsQuarantined`, `StaffHireDate`, `PhoneGateway`, `IsWeekendStaff`, `CanAssignClientMeds`,  `IsPickDropStaff`   FROM `Staff" .  (($formerStaff == 1) ? "History" : "" ) . "` a, `StaffIndicators" .  (($formerStaff == 1) ? "History" : "" ) . "` b, `StaffAuthAz" .  (($formerStaff == 1) ? "History" : "" ) . "` c WHERE  a.`StaffID` = b.`StaffID` AND a.`StaffID` = c.`StaffID` AND a.`StaffID`= " . $formdata['staffID'] . " ";
			$result = mysqli_query( $dbHandle, $query  );
       		if ( mysqli_errno( $dbHandle ) == 0 )
       		{
          		if ( mysqli_num_rows( $result ) == 0 )
          		{
               		$retArray = array( 0 => FAIL, NOT_EMP_SW, $query );
          		}
          		else {
               		$row = mysqli_fetch_row( $result );
                    $retArray = array( 0 => SUCCESS, $row[0], $row[1], $row[2], $row[3], $row[4], $row[5], $row[6], $row[7], $row[8], $row[9], $row[10], $row[11], $row[12], $row[13], $row[14], $row[15]);
          		}
       		}
			else {
				$errMsg = mysqli_error( $dbHandle );
				$errNo  = mysqli_errno( $dbHandle );
				$retArray = array( 0 => FAIL, SQLERROR, "Error No: " . $errNo . ": Error Message: " . $errMsg . "<br>" . $query );
			}
          			
                               // Free result set
                               if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }


		closeDB( $dbHandle );
			return $retArray;
		
	  }
	  
	  //
	// Get  Staff Manager
	//
	function getStaffManager( $staffID, $admin = 'S' )
	{
		$dbHandle = loginToDB();
		
		if ( $admin == 'S' ) {
			$query  = "SELECT IFNULL(a.`StaffEmail`, 'NO VALID SUPERVISOR ASSIGNED' ) AS  SupervisorEmail, concat(a.`StaffFname`, ' ', a.`StaffLname`) as NAME ";
			$query .= " FROM `Staff` a, `Staff` b WHERE a.`StaffID`=b.`SupervisorID` and b.`StaffID`=". $staffID . " ";
		}
		else {
			$query  = "SELECT a.`StaffEmail` as SupervisorEmail, concat(a.`StaffFname`, ' ', a.`StaffLname`) as NAME FROM `Staff` a, `StaffAuthAz` b ";
			$query .= " WHERE a.`StaffID`=b.`StaffID` AND b.`StaffRoleID`=1";
		}
				
		$result = mysqli_query( $dbHandle, $query  );

		$row = mysqli_fetch_assoc($result);
		$staffRecord = $row;
		
		// Free result set
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );	
			
		return $staffRecord;
	}
	
	function getStaffSMSGateway( $staffID )
	{
		$dbHandle = loginToDB();
		
		$query = "SELECT a.`Gateway` FROM `PhoneGateways` a, `Staff` b WHERE a.`GatewayID`=b.`PhoneGateway` AND b.`StaffID`=" . $staffID . " ";
		$result = mysqli_query( $dbHandle, $query  );

		$row = mysqli_fetch_assoc($result);
		$gateway = $row['Gateway'];
		
		// Free result set
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );	
			
		return $gateway;
	}
	
	function getRequestDetails( $staffID, $requestID, $action = 'A' )
	{
		$dbHandle = loginToDB();
		$requests = array();
	
		$query   = "Select a.`RequestMonth`, a.`RequestDay`, a.`RequestYear`, b.`RequestName`, a.`HoursRequested`,  a.`RequestTypeID` ";
		$query  .= " FROM  " . ( ( $action == 'A' ) ? " `TimeOffApproved` " : " `TimeOffRejected` " ) . " a, `TimeOffRequestLkup` b ";
		$query  .= " WHERE a.`StaffID`=" . $staffID . " AND a.`RequestID`= " . $requestID . " AND a.`RequestTypeID` = b.`RequestTypeID` ";
		
		$result = mysqli_query( $dbHandle, $query  );

		while ($row = mysqli_fetch_assoc($result)) {
			$requests[] = $row;
		}

		// Free result set
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );		
		return $requests;
	}
	
	function getAnniversariesToExtend()
	{
		$dbHandle = loginToDB();
		$anniversaries = array();
		
		$query = "SELECT `StaffID`, `AnnivEndDate` as CurrentEndDate, `AnnivEndDate`+interval 1 day as AnnivStartDate FROM `TimeOffHoursUsed` WHERE `AnnivEndDate` = curdate()
";
		
		$result = mysqli_query( $dbHandle, $query  );

		while ($row = mysqli_fetch_assoc($result)) {
			$anniversaries[] = $row;
		}

		// Free result set
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );		
		return $anniversaries;
	}
	
	function resetStaffAnniversaryYear( $anniversaries, $whichOne )
	{
	
		$dbHandle = loginToDB();
		
		// Get Carry Over hours
		$query = "SELECT if( (`CarryOverHours` + `HoursAvailable` - `HoursUsed`) > 0, (`CarryOverHours` + `HoursAvailable` - `HoursUsed`) , 0 ) as CarryOver,  ";
		$query .= " HoursGranted as HrsAvailable ";
		$query .= " FROM `TimeOffHoursUsed` WHERE `StaffID`=" . $anniversaries['StaffID']  . " AND `AnnivEndDate`='" . $anniversaries['CurrentEndDate'] . "' AND `RequestTypeID`=" . $whichOne . " ";
		
		$result = mysqli_query( $dbHandle, $query  );
		$row = mysqli_fetch_assoc($result);
		$carryOver = $row['CarryOver'];
		$hrsavailable = $row['HrsAvailable'];
		//echo $query . "<br />";
		
		// Free result set
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		
		$query ="INSERT IGNORE INTO `TimeOffHoursUsed`(`StaffID`, `AnnivStartDate`, `AnnivEndDate`, `RequestTypeID`, `CarryOverHours`, `HoursGranted`,  `HoursAvailable`, `HoursUsed`) ";
		$query .= " VALUES ( ";
		$query .= $anniversaries['StaffID'] . ", '" . $anniversaries['AnnivStartDate'] . "', ";
		$query .= "'" . $anniversaries['AnnivStartDate'] . "' + INTERVAL 365 DAY, " . $whichOne . ", " . $carryOver . ", ";
		$query .= " if( ( `RequestTypeID` = 3 ), 40, 0 ), if( ( `RequestTypeID` = 1 ), 40, " . $hrsavailable . " ), 0 ";
		$query .= " ) ";
		
		//echo $query . "<br />";
		
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno( $dbHandle ) != 0 )
		{
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
			return FAIL;
		}
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
		return SUCCESS;
	}
	
	//
	//  Get Staff Positions
	//
	function getPositionName( $positionID = '' )
	{
		$dbHandle = loginToDB();
		$positiona = array();
		
		
		if ( $positionID == '' ) { return array( 'PositionID' => 0, 'Position' => 'N/A' ); }
		
		$query  = "SELECT * FROM `StaffPositions` WHERE PositionID =" . $positionID . " order by 2  ";
				
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return "";
		}
		
		$row = mysqli_fetch_assoc( $result );
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return $row;
	}
	
	//
	//  Get House Clients
	//
	function getHouseClients( $houseID )
	{
		$dbHandle = loginToDB();
		$clients = array();
						
		$query  = "select distinct a.ClientID, a.ClientFname, a.ClientLname, b.HouseID from Clients a, Houses b, ClientServices c ";
		$query .= " WHERE  a.ClientID = c.ClientID AND b.HouseID = c.HouseID and b.HouseInUse = 'Y'  AND b.HouseID = " . $houseID . " AND UPPER(a.ClientStatus) = 'OPEN' order by 2,3";
					
		$result = mysqli_query( $dbHandle, $query  );		
		
		//echo $query;
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return "";
		}
		
		while ($row = mysqli_fetch_assoc($result)) {
			$clients[] = $row;
		}
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return $clients;
	}

	//
	// Get Clients Root Dir
	//
	function getStaffRootDirs( $staffID = 0 )
    {
		$dbHandle = loginToDB();
		$retStr = array(); 
		$idx = 0;
		
		if ( $clientID == 0 )
		{
			$query = "SELECT StaffRootDir FROM Staff WHERE Status = 'Active'" ;
		}
		else {
			$query = "SELECT StaffRootDir FROM Staff WHERE StaffID = " . $staffID ;
			$query .= " UNION ";
			$query .= "SELECT StaffRootDir FROM StaffHistory WHERE StaffID = " . $staffID ;
		}
		//echo $query;
		
		$result = mysqli_query( $dbHandle, $query  );
		
		while ( $row = mysqli_fetch_row( $result ) )
		{
			$rtnStr[$idx++] = $row[0];
		}
				
	   // Free result set
	   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }


	    closeDB( $dbHandle );
		return $rtnStr;
    }
		
	//
	// Get Clients Root Dir
	//
	function getRootDirs( $clientID = 0 )
    {
		$dbHandle = loginToDB();
		$retStr = array(); 
		$idx = 0;
		
		if ( $clientID == 0 )
		{
			$query = "SELECT ClientRootDir FROM Clients WHERE ClientStatus = 'Open'" ;
		}
		else {
			$query = "SELECT ClientRootDir FROM Clients WHERE ClientID = " . $clientID ;
			$query .= " UNION ";
			$query .= "SELECT ClientRootDir FROM ClientsHistory WHERE ClientID = " . $clientID ;
		}
		//echo $query;
		
		$result = mysqli_query( $dbHandle, $query  );
		
		while ( $row = mysqli_fetch_row( $result ) )
		{
			$rtnStr[$idx++] = $row[0];
		}
				
						   // Free result set
						   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }


	    closeDB( $dbHandle );
		return $rtnStr;
    }
	
	//
	// Get Residents Root Dir
	//
	function getResidentsRootDirs()
    {
		$dbHandle = loginToDB();
		$retStr = array(); 
		$idx = 0;
					
		$query = "SELECT trim(ClientFname), trim(ClientLName), ClientRootDir FROM Clients WHERE ClientStatus = 'Open'" ;			
			
		//echo $query;
		
		$result = mysqli_query( $dbHandle, $query  );
		
		while ( $row = mysqli_fetch_row( $result ) )
		{
			$rtnStr[$idx++] = array( $row[0] . ' ' . $row[1], $row[2] );
		}
				
	   // Free result set
	   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }


		closeDB( $dbHandle );
		return $rtnStr;
    }
  
	function getSocialWorker( $swID )
	{

		$dbHandle = loginToDB();

		$query = "select CCS_StaffName from CCS_Staff where CCS_StaffID = " . $swID;
		$result = mysqli_query( $dbHandle, $query  );
		$row = mysqli_fetch_row( $result );
          			
	   // Free result set
	   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
	   closeDB( $dbHandle );

		return trim($row[0]) ;

	}
	
	function getProblemTypes()
	{
	  			$dbHandle = loginToDB();
				$retStr = "";

	  			$query  = "select distinct `TBDescription` from TargetBehavior order by 1";
	  			$result = mysqli_query( $dbHandle, $query  );
				while ( $row = mysqli_fetch_row( $result ) )
				{
						$retStr .= "<option value=\"" . $row[0] . "\">" . $row[0] .  "</option><br />";
				}
          			
                               // Free result set
                               if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }


		closeDB( $dbHandle );
				return $retStr;
		}
	
	  function getCriticalProblemID( )
	{
		$dbHandle = loginToDB();
	
		$query  = "select COALESCE( max( ProblemID ), 0 ) + 1 as ProblemID from CriticalProblems" ;
		
		$result = mysqli_query( $dbHandle, $query  );
		$row = mysqli_fetch_row( $result );
          			
                               // Free result set
                               if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }


		closeDB( $dbHandle );
		return $row[0];
	}
		

	  
	  function getOpenCriticalProblems()
	  {
	  			$dbHandle = loginToDB();
				$retStr = array(); 
				$i = 0;

	  			$query  = "select b.problemID, DATE_FORMAT( b.IncidentDate, '%M %e, %Y' ), b.ProblemType, trim(a.ClientFname), trim(ClientLname) from Clients a, CriticalProblems b where a.clientID = b.clientID and UPPER(b.problemStatus) = 'OPEN' order by 4,5";
	  			$result = mysqli_query( $dbHandle, $query  );
				while ( $row = mysqli_fetch_row( $result ) )
				{
						$retStr[$i++] = array( $row[0], $row[3] .  " " . $row[4], $row[1], $row[2] );
				}
          			
                               // Free result set
                               if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }


		closeDB( $dbHandle );
				return $retStr;
	  }
		
	  function getResidentCriticalProblem( $problemID = 0 )
	  {
		$dbHandle = loginToDB();
		$retStr = array(); 
		$i = 0;

		$query  = "select b.problemID, trim(a.ClientFname), trim(a.ClientLname), DATE_FORMAT( b.IncidentDate, '%M %e, %Y' ), b.ProblemType, b.ProblemDescription, b.ProblemSolution, b.problemStatus, b.SubmittedBy, b.DiscussedWith, b.NotificationTime from Clients a, CriticalProblems b where b.problemID = " . $problemID  . " and a.clientID = b.clientID and UPPER(b.problemStatus) = 'OPEN'";
		//echo $query;
		$result = mysqli_query( $dbHandle, $query  );
		while ( $row = mysqli_fetch_row( $result ) )
		{
				$retStr[$i++] = array( $row[0], $row[1] .  " " . $row[2], $row[3], $row[4], $row[5], $row[6], $row[7], $row[8], $row[9], $row[10] );
		}
			
					   // Free result set
					   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }


		closeDB( $dbHandle );
		return $retStr;
    }
		
	function menuAccessAllowed( $staffID ) 
	{
		$dbHandle = loginToDB();
		$menus = array();
		
	 	$query   = "SELECT c.`MenuID` FROM `StaffAuthAz` a, `StaffRoleLkup` b, `RoleMenuLkup` c  WHERE a.`StaffID` = " . $staffID ;
		$query  .= " AND b.`RoleID` = a.`StaffRoleID` AND c.`RoleID` = b.`RoleID` ";
								
		$result = mysqli_query( $dbHandle, $query  );
		//if (  mysqli_num_rows($result) == 0 ) {
			
		//	$query   = "SELECT c.`MenuID` FROM `ConfigureStaffAuthAz` a, `StaffRoleLkup` b, `RoleMenuLkup` c  WHERE a.`StaffID` = " . $staffID ;
		//	$query  .= " AND b.`RoleID` = a.`StaffRoleID` AND c.`RoleID` = b.`RoleID` ";
		//	$result = mysqli_query( $dbHandle, $query  );
		//}
		
		while ( $row = mysqli_fetch_assoc( $result ) )
		{
			$menus[] = $row['MenuID'];
		}
			
	   // Free result set
	   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

		closeDB( $dbHandle );					
		return $menus;
	}
	
	function getCurrentIPDates( $services, $stateID )
	{
		$dbHandle = loginToDB();
		$retStr = array();
		$dayPgm = "";
		
		//$dayPgm =  ( $services['pcpprogram'] == DAY_REHABILITATION_SERVICES ) ? "and a.IsDayClient = 'Y' " : "";
		
		$query  = "SELECT a.ClientID, concat( trim(a.ClientFName), ' ', trim(a.ClientLName) ), FormatDateMMDDYYYY(b.OriginalIPDate), FormatDateMMDDYYYY(b.CurrentIPDate), FormatDateMMDDYYYY(b.NextIPDate) ";
		$query .= " From Clients a, PCPDateManagement b, `ClientServices` c WHERE a.ClientID =  b.ClientID AND  a.ClientID =  c.ClientID AND a.ClientStatus = 'Open' " . $dayPgm;
		$query .= " AND c.`ServiceID` = " . $services['pcpprogram'] . " AND b.`ServiceID` = " . $services['pcpprogram'];
		
		//echo $query;
		$result = mysqli_query( $dbHandle, $query  );
		while ( $row = mysqli_fetch_row( $result ) )
		{
				$retStr[] = array( $row[0],  $row[1], $row[2], $row[3], $row[4] );
		}
          			
	   // Free result set
	   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }


		closeDB( $dbHandle );

		return $retStr;
	}
	
	function getConfigFromDB()
	{
		$dbHandle = loginToDB();
		$config = $agency = $services = $mgmtteam = $bodteam = array();
		
		$query  = "SELECT `ConfigID`, `SHOWMGMT`, `SHOWBOD`, `CHART_BACK`, `CHART_BACK_DAYS`, `CHART_PERIOD`, ";
		$query .= " `STATEID`, `OFC_MAIL_SAME`, `TIMEZONE`, `OTHER_CALL`, `CLIENTREF`, `SHOWMAP`, `ONLINEDOCS`, `FILEUPLOAD`, ";
		$query .= " `EMPLOYMENT`, `IDLE_TIMEOUT`, `AgencyID`, `ServicesID`, `ManagerID`, `BodID` FROM `AgencyConfig` ";
		
		//echo $query . "<br>";
		$result = mysqli_query( $dbHandle, $query  );
		if ( ( mysqli_errno($dbHandle) != 0 ) || ( mysqli_num_rows($result) == 0 )  ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return array( FAIL, "" );
		}
		while ( $row = mysqli_fetch_assoc( $result ) )
		{
				$config[] = $row;
		}
		// Free result set
	    if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
	   
		$query  = "SELECT a.`AgencyID`, `AgencyFullname`, `AgencyShortname`, `NPR_Number`, `LicenseNumber`, `OfficeAddress`, ";
		$query .= " `OfficeCity`, `OfficeStateZip`, `OfficeRegion`, `OfficeHoursStart`, `OfficeHoursEnd`, `WorkDays`, ";
		$query .= " `MailingAddress`, `MailingCity`, `MailingStateZip`, `Telephone`, `Fax`, `Email`, `AltTelephone`, ";
		$query .= " `AltFax`, `AltEmail`, `Copyright` FROM `AgencyDetails` a, ";
		$query .= "  `AgencyConfig` b WHERE a.AgencyID = b.AgencyID ";
		
		//echo $query . "<br>";
		
		$result = mysqli_query( $dbHandle, $query  );
		if ( ( mysqli_errno($dbHandle) != 0 ) || ( mysqli_num_rows($result) == 0 )  ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return array( FAIL, "" );
		}
		while ( $row = mysqli_fetch_assoc( $result ) )
		{
				$agency[] = $row;
		}
		// Free result set
	    if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		
		$query  = "SELECT a.`ServicesID`, `Service`, `SubService` FROM `ConfigServices` a, ";
		$query .= "  `AgencyConfig` b WHERE a.ServicesID = b.ServicesID ORDER BY 1, 2, 3";
		
		//echo $query . "<br>";
		
		$result = mysqli_query( $dbHandle, $query  );
		if ( ( mysqli_errno($dbHandle) != 0 ) || ( mysqli_num_rows($result) == 0 )  ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return array( FAIL, "" );
		}
		while ( $row = mysqli_fetch_assoc( $result ) )
		{
				$services[] = $row;
		}
		// Free result set
	    if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		
		$query  = "SELECT a.* FROM `ManagementTeam` a, ";
		$query .= "  `AgencyConfig` b WHERE a.ManagerID = b.ManagerID ";
		
		//echo $query . "<br>";
		
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno($dbHandle) != 0 )  {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return array( FAIL, "" );
		}
		while ( $row = mysqli_fetch_assoc( $result ) )
		{
				$mgmtteam[] = $row;
		}
		// Free result set
	    if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		
		$query  = "SELECT a.* FROM `BODTeam` a, ";
		$query .= "  `AgencyConfig` b WHERE a.BodID = b.BodID ";
		
		//echo $query . "<br>";
		
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno($dbHandle) != 0 )  {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return array( FAIL, "" );
		}
		while ( $row = mysqli_fetch_assoc( $result ) )
		{
				$bodteam[] = $row;
		}
		// Free result set
	    if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		
		return array( SUCCESS, array( $config,  $agency, $services, $mgmtteam, $bodteam ) );
	}
	
	function getHRCFromDB()
	{
		$dbHandle = loginToDB();
		$hrcteam = array();
				
		$query  = "SELECT a.* FROM `HRCTeam` a ";
		$result = mysqli_query( $dbHandle, $query  );
		if ( ( mysqli_errno($dbHandle) != 0 ) || ( mysqli_num_rows($result) == 0 )  ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return array( FAIL, "" );
		}
		while ( $row = mysqli_fetch_assoc( $result ) )
		{
				$hrcteam[] = $row;
		}
		// Free result set
	    if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		return array( SUCCESS, array( $hrcteam ) );
	}
		
	function getStaffServices( $staffID )
	{
		$dbHandle = loginToDB();
		$hrcteam = array();
				
		$query  = "SELECT * FROM `StaffServices` WHERE `StaffID`= " . $staffID ; 
		$result = mysqli_query( $dbHandle, $query  );
		if ( ( mysqli_errno($dbHandle) != 0 ) ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return array( FAIL, $hrcteam );
		}
		while ( $row = mysqli_fetch_assoc( $result ) )
		{
			$hrcteam[] = $row['ServiceID'];
		}
		// Free result set
	    if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		return array( SUCCESS, $hrcteam );
	}
		
	function getMARDetails( $formdata )
	{

		$retStr = "";
		$dbHandle    = loginToDB();
		
		$query = "SELECT CONCAT( c.`HouseName` ,  ' ( CIS&H )' ), b.`Diagnosis`, b.`Allergies`, b.`Diet`, ";
		$query .= " CONCAT( TRIM( a.`ClientFname` ) ,  ' ', TRIM( a.`ClientLname` ) ) , DATE_FORMAT( a.ClientBirthDate,  '%m/%d/%Y' ), ";
		$query .= " e.`ProviderName`, e.`ProviderPhone`, e.ProviderID, a.`ClientGender` ";
		$query .= " FROM Clients a, `45DayNursesReport` b, Houses c, ClientsProvider d, Providers e, ClientServices f ";
		$query .= " WHERE a.ClientID = " . $formdata['clientID'] . " and a.ClientID = b.ClientID and f.HouseID = c.HouseID ";
		$query .= " and a.ClientID = d.ClientID and a.ClientID = f.ClientID  and d.ProviderID = e.ProviderID and e.ProviderTypeID = 1 ";
		
		//echo $query;
		
		$result = mysqli_query( $dbHandle, $query  );
		$row = mysqli_fetch_row( $result );
		
		return $row;
	}
	
	function  getMARPRNStat( $formdata )
	{
		$i = 0;
		$retStr = array();
		$dbHandle    = loginToDB();
		list ( $marMonth, $marYear ) = explode("/", $formdata['monthYr'] );
		
		$query = "SELECT * FROM `MARPRNStat` WHERE `ClientID` = " . $formdata['clientID'] . " and `Month` = '" . $marMonth . "' and `Year` = '" . $marYear . "' and `MARType` = '" . sql_quote( $dbHandle,  $formdata['programCd'] ) . "'";
		//echo $query;					
		$result = mysqli_query( $dbHandle, $query  );
		while ( $row = mysqli_fetch_row( $result ) )
		{
			$retStr[$i++] =  $row;
		}
          			
                               // Free result set
                               if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }


		closeDB( $dbHandle );
		return $retStr;
	}
	
	function  getMARErrors( $formdata )
	{
		$i = 0;
		$retStr = array();
		$dbHandle    = loginToDB();
		list ( $marMonth, $marYear ) = explode("/", $formdata['monthYr'] );
		
		$query = "SELECT * FROM `MARErrors` WHERE `ClientID` = " . $formdata['clientID'] . " and `Month` = '" . $marMonth . "' and `Year` = '" . $marYear . "' and `MARType` = '" . sql_quote( $dbHandle,  $formdata['programCd'] ) . "'";
		//echo $query;					
		$result = mysqli_query( $dbHandle, $query  );
		while ( $row = mysqli_fetch_row( $result ) )
		{
			$retStr[$i++] =  $row;
		}
          			
                               // Free result set
                               if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }


		closeDB( $dbHandle );
		return $retStr;
	}
	
	function  getMARChanges( $formdata )
	{
	
		$i = 0;
		$retStr = array();
		$dbHandle    = loginToDB();
		list ( $marMonth, $marYear ) = explode("/", $formdata['monthYr'] );
		
		$query = "SELECT * FROM `MARChanges` WHERE `ClientID` = " . $formdata['clientID'] . " and `Month` = '" . $marMonth . "' and `Year` = '" . $marYear . "' and `MARType` = '" . sql_quote( $dbHandle,  $formdata['programCd'] ) . "'";
		//echo $query;					
		$result = mysqli_query( $dbHandle, $query  );
		while ( $row = mysqli_fetch_row( $result ) )
		{
			$retStr[$i++] =  $row;
		}
          			
                               // Free result set
                               if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }


		closeDB( $dbHandle );
		return $retStr;
	}
	
	function getCMTStaff()
	{
		$retStr = "";
		$dbHandle    = loginToDB();
		
		$query = "SELECT a.`StaffID`, b.`Initials`, concat( trim(b.`StaffFname`), ' ', trim(b.`StaffMInit`), ' ', trim(b.`StaffLname`) ) FROM `EmployeesDocMonitor` a, Employees b WHERE  a.`DocID` = 5 and a.`DocRequired` = 'Y' and curdate() <= a.`RenewalDate` and a.`StaffID`=b.`StaffID` and b.`Status`='Active'";
		$result = mysqli_query( $dbHandle, $query  );
		while ( $row = mysqli_fetch_row( $result ) )
		{
			$retStr .=  "<option value=\"" . $row[0] . "-" . $row[1]. "\">" . $row[2] . "</option><br />";
			$cmtIDs .= $row[0] . "-";
		}
          			
                               // Free result set
                               if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }


		closeDB( $dbHandle );
		return $retStr;
	}
	
	function isHRC_Staff( $loginID )
	{
		$dbHandle    = loginToDB();
		
		$query = "SELECT * FROM `HRCTeam` WHERE `StaffID` =  " . $loginID;
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_num_rows($result) == 0 ) {
			$hrcStaff = false;
			$hrcRole = '';
		}
		else {
			$hrcStaff = true;
			$row = mysqli_fetch_assoc( $result );
			$hrcRole = $row['Role'];
		}
          			
	   // Free result set
	   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }


		closeDB( $dbHandle );
		return array( $hrcStaff, $hrcRole );
	}
	
	function getCMTStatus( $loginID )
	{
		$dbHandle    = loginToDB();
		$mttp = '';
		
		$query = "SELECT 'Y' as 'MTTP' FROM `EmployeesDocMonitor` WHERE  `DocID` = 5 and `DocRequired` = 'Y' and curdate() <= `RenewalDate` and `StaffID`= " . $loginID;
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_num_rows($result) == 0 ) {
			$mttp = 'N';
		}
		else {
			$row = mysqli_fetch_row( $result );
			$mttp =  $row[0];
		}
          			
                               // Free result set
                               if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }


		closeDB( $dbHandle );
		return $mttp;
	}
	
	function approveMAR( $formdata, $approve = 'N' )
	{
		$retStr = array();
		$dbHandle    = loginToDB();
		list ( $marMonth, $marYear ) = explode("/", $formdata['monthYr'] );
				
		$query = "REPLACE INTO `MARApprovals`(`ClientID`, `Month`, `Year`, `MARType`, `Approved`) VALUES ( ";
		$query .= $formdata['marClientID'] . ", ";
		$query .= "'" . sql_quote( $dbHandle,  $marMonth ) . "', ";
		$query .= "'" . sql_quote( $dbHandle,  $marYear ) . "', ";
		$query .= "'" . sql_quote( $dbHandle,  $formdata['marProgramCd'] ) . "', ";
		$query .= "'" . sql_quote( $dbHandle,  $approve ) . "' )";
		
		//echo $query;
		//exit;
		mysqli_query( $dbHandle, $query  );

		if ( mysqli_errno( $dbHandle ) != 0 )
		{
			$rtnMsg = mysqli_error($dbHandle);
          			
                               // Free result set
                               if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }


		closeDB( $dbHandle );
			return array( SQLERROR, $rtnMsg );
		}
          			
                               // Free result set
                               if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }


		closeDB( $dbHandle );
		return array( SUCCESS, "" );
	}
	
	function isMARApproved( $formdata )
	{
		$dbHandle    = loginToDB();
		list ( $marMonth, $marYear ) = explode("/", $formdata['marDate'] );
		
		$query = "SELECT coalesce(`Approved`, 'N') FROM `MARApprovals` WHERE `ClientID` = " . $formdata['clientID'] . " AND ";
		$query .= " `Month` = '" . sql_quote( $dbHandle,  $marMonth ) . "' AND `Year` = '" . sql_quote( $dbHandle,  $marYear ) . "' AND `MARType` = " . $formdata['programID'] . " ";
		
		$result = mysqli_query( $dbHandle, $query  );
		$row = mysqli_fetch_row( $result );
          			
	   // Free result set
	   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }


		closeDB( $dbHandle );
		return $row[0];
		
	}
	
	function overrideMARApproval( $formdata )
	{
		//echo pp($formdata);
		$dbHandle    = loginToDB();
		list ( $marMonth, $marYear ) = explode("/", $formdata['btmmonthYr'] );
		
		$query = "UPDATE `MARApprovals` SET `Approved` = 'N' WHERE `ClientID` = " . $formdata['btmclientID'] . " AND ";
		$query .= " `Month` = '" . sql_quote( $dbHandle,  $marMonth ) . "' AND `Year` = '" . sql_quote( $dbHandle,  $marYear ) . "' AND `MARType` = '" . sql_quote( $dbHandle,  $formdata['btmprogramCd'] ) . "'";
		
		//echo "<br><br>" . $query;
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno( $dbHandle ) != 0 )
		{
          			
                               // Free result set
                               if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }


		closeDB( $dbHandle );
			return FAIL;
		}
          			
                               // Free result set
                               if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }


		closeDB( $dbHandle );
		return SUCCESS;
	}
	
	
?>
