<?php
	
	function getBudgetItems()
	{
		$dbHandle = loginToDB();
		$houses = array();
		
		$query  = "SELECT * FROM `BudgetItems` where budgetItemID > 1 order by 2";	
		//echo $query;
		
		$result = mysqli_query( $dbHandle, $query  );
		while ( $row = mysqli_fetch_row( $result ) )
		{
			$houses[$row[0]]= $row[1];
		}
						
	   // Free result set
	   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
	
		closeDB( $dbHandle );
		return $houses;
	
	}

	function getCardnumbers( $formdata )
	{
		global  $month_names;
		
		$program = array( 'A' => 'Adult Residential Program', 'Y' => 'Youth Residential Program', 'D' => 'Adult Day Program',
		                  'MA' => 'Management ( Administrator )', 'MN' => 'Management ( Nurse )' );
		list( $mth, $yy ) = explode(" ", $formdata['summarymonth'] );		
		$cardnumbers = array();
		$rIdx = 0;
		$dbHandle = loginToDB();
		
		$query  = "SELECT distinct `cardnumber` FROM `ReconcilationDetails` WHERE `reconFor` = '" . sql_quote( $dbHandle,  $formdata['homename'] ) . "' and `month` = " . $month_names[$mth] . " and `year` = '" . sql_quote( $dbHandle,  $yy ) . "'";
		//echo $query;
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_num_rows($result) == 0 ) {
          			
                               // Free result set
                               if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }


		closeDB( $dbHandle );
			//echo "<br><br><br>RETURNING NOTHING FOUND<br><br><br>";
			return array( FAIL, "There is no saved reconciliation data for the " . $program[$formdata['homename']] . " for " . date("F Y", mktime(0,0,0,$month_names[$mth],1,$yy)));
		}
		else {
			while ( $row = mysqli_fetch_row( $result ) )
			{						
				$cardnumbers[$rIdx++] = $row[0];
			}
		}
          			
                               // Free result set
                               if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }


		closeDB( $dbHandle );
		return array( SUCCESS, $cardnumbers );
	}
	
	function getReconDetails( $formdata )
	{
		global  $month_names;
		
		//echo " <br><br> ======================= TOP of getReconDetails ==================== <br><br> ";
		//var_dump($formdata);
		
		$program = array( 'A' => 'Adult Residential Program', 'Y' => 'Youth Residential Program', 'D' => 'Adult Day Program',
						  'MA' => 'Management ( Administrator )', 'MN' => 'Management ( Nurse )' );
		list( $mth, $yy ) = explode(" ", $formdata['summarymonth'] );		
		$reconBalances = array();
		$reconDetails = array();
		$dbHandle = loginToDB();
		$dIdx = 1;
		//echo " <br><br> ======================= TOP of getReconDetails ==================== <br><br> " .
		//    "Month = " .  $formdata['summarymonth'] . "<br>" . 
		// "Month = " . $mth . " and value = " . $month_names[$mth] . "<br>" .
		//	 "Year = " .  $yy . "<br>" .
		
		$query = "SELECT  `beginBalance`, `additions`, `subtractions`, `approved`, `staffID`, `comments` FROM `ReconDetailsBalance` WHERE `reconFor` = '" . sql_quote( $dbHandle,  $formdata['homename'] ) . "' and `month` = " . $month_names[$mth] . " and `year` = '" . sql_quote( $dbHandle,  $yy ) . "' and `cardnumber` = '" . sql_quote( $dbHandle,  $formdata['cardnumber'] ) . "'";
		 //echo $query . "<br>";
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_num_rows($result) == 0 ) {
          			
                               // Free result set
                               if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }


		closeDB( $dbHandle );
			return array( FAIL, "There is no saved reconciliation data for the " . $program[$formdata['homename']] . " ( Card Number: " . $formdata['cardnumber'] . " ) for " . date("F Y", mktime(0,0,0,$month_names[$mth],1,$yy)));
		}
		else
		{
			while ( $row = mysqli_fetch_array($result, MYSQLI_ASSOC) )
			{						
				$reconBalances = $row;
			}
		}
		
		//echo " <br><br> ======================= Retrieved reconBalances ==================== <br><br> ";
		//var_dump($reconBalances);

		$query = "SELECT  `reconDetailID`, DATE_FORMAT(`reconDate`, '%m/%d/%Y') as reconDate, `reconDetailDesc`, `reconItemAmt1`, `reconItemAmt2`, `reconItemAmt3`, `reconItemAmt4`, `reconItemAmt5`, ";
		$query .= " `reconItemAmt6`, `reconItemAmt7`, `reconItemAmt8`, `reconItemAmt9`, `reconItemAmt10`, `reconItemAmt11`, `reconItemAmt12`, ";
		$query .= " `reconItemAmt13`, `reconItemAmt14`, `reconItemAmt15`, `reconItemAmt16`, `reconItemAmt17`, `reconItemAmt18`, `reconItemAmt19` ";
		$query .= " FROM `ReconcilationDetails` WHERE  `reconFor` = '" . sql_quote( $dbHandle,  $formdata['homename'] ) . "' and `month` = " . $month_names[$mth] . " and `year` = '" . sql_quote( $dbHandle,  $yy ) . "' and `cardnumber` = '" . sql_quote( $dbHandle,  $formdata['cardnumber'] ) . "'";
		$query .= " ORDER BY `reconDate`";
		//echo $query;
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_num_rows($result) == 0 ) {
          			
                               // Free result set
                               if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }


		closeDB( $dbHandle );
			return array( FAIL, "There is no saved reconciliation data for the " . $program[$formdata['homename']] . " ( Card Number: " . $formdata['cardnumber'] . " ) for " . date("F Y", mktime(0,0,0,$month_names[$mth],1,$yy)));
		}
		else
		{
			while ( $row = mysqli_fetch_array($result, MYSQLI_ASSOC) )
			{						
				$reconDetails[$dIdx++]  = $row;
			}
		}
		
		//echo " <br><br> ======================= Retrieved reconDetails ==================== <br><br> ";
		//var_dump($reconDetails);
          			
                               // Free result set
                               if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }


		closeDB( $dbHandle );
		return array( SUCCESS, $reconBalances, $reconDetails );
	}
	
	function getBudgetFor( $budgetBalID, $budgetDetailID, $returnCode = false )
	{
		$program = array( 'A' => 'Community Living - Group Home', 'Y' => 'Youth Residential Program', 'D' => 'Day Habilitation',
						  'MA' => 'Management ( Administrator )', 'MN' => 'Management ( Nurse )' );
						  
		$dbHandle = loginToDB();
		
		$query = "SELECT `budgetFor` FROM `BudgetDetailsBalance` WHERE `BudgetBalID` = " . $budgetBalID . " AND `BudgetDetailID` =  " . $budgetDetailID . "";
		$result = mysqli_query( $dbHandle, $query  );
		
		if ( mysqli_num_rows($result) == 0 ) {
          			
			// Free result set
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

			closeDB( $dbHandle );
			return "";
		}
		else
		{
			$row = mysqli_fetch_array($result, MYSQLI_ASSOC);
			closeDB( $dbHandle );
			if ( $returnCode === true) {
				return $row['budgetFor'];
			}
			else {
				return $program[$row['budgetFor']];
			}
			
		}
	}
	
	function getBudgetMonthYear( $budgetBalID, $budgetDetailID )
	{
		$dbHandle = loginToDB();
		
		$query = "SELECT distinct `month`, `year` FROM `BudgetDetailsBalance` WHERE `BudgetBalID` = " . $budgetBalID . " AND `BudgetDetailID` =  " . $budgetDetailID . "";
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_num_rows($result) == 0 ) {
          			
			// Free result set
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

			closeDB( $dbHandle );
			return array();
		}
		else
		{	
			$row = mysqli_fetch_array($result, MYSQLI_ASSOC);
			closeDB( $dbHandle );					
			return $row;
		}
	}
	
	
	//function getSavedBuget( $budgetfor, $month, $year )
	function getSavedBuget( $budgetBalID, $budgetDetailID )
	{
	
		$program = array( 'A' => 'Community Living - Group Home', 'Y' => 'Youth Residential Program', 'D' => 'Day Habilitation',
						  'MA' => 'Management ( Administrator )', 'MN' => 'Management ( Nurse )' );
						  
		$budgetfor = getBudgetFor( $budgetBalID, $budgetDetailID );	
		$monthYear = getBudgetMonthYear( $budgetBalID, $budgetDetailID );			  
		$budgetHouseSlct = array();
		$budgetDetails = array();
		$savedBudgetItems = array();
		$balance = array();
		$bhIdx = $rIdx = $balIdx = 0;
		$retStr = array( SUCCESS, "" );
		$dbHandle = loginToDB();
		
		$query = "select `houseID`, `houseName` from `Houses` where `houseID` in ( ";
		$query .= " SELECT DISTINCT  `houseID`  FROM `BudgetDetails` WHERE `BudgetDetailID` = " . $budgetDetailID . " ) order by 2";

		//echo $query;
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_num_rows($result) == 0 ) {
          			
		   // Free result set
		   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

			closeDB( $dbHandle );
			return array( FAIL, "There is no saved " . $budgetfor . " budget for " . date("F Y", mktime(0,0,0,$monthYear['month'],1,$monthYear['year'])));
		}
		else
		{
			while ( $row = mysqli_fetch_array($result, MYSQLI_ASSOC) )
			{						
				$budgetHouseSlct[] = $row['houseID'];
			}
		}
		
		$query = "SELECT DISTINCT  `budgetItemID`  FROM `BudgetDetails` WHERE `BudgetDetailID` = " . $budgetDetailID;
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_num_rows($result) == 0 ) {
          			
			// Free result set
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

			closeDB( $dbHandle );
			return array( FAIL, "There is no saved " . $budgetfor . " budget for " . date("F Y", mktime(0,0,0,$monthYear['month'],1,$monthYear['year'])));
		}
		else
		{
			while ( $row = mysqli_fetch_array($result, MYSQLI_ASSOC) )
			{						
				$savedBudgetItems[] = $row['budgetItemID'];
			}
		}
		
		$query = "SELECT `amount`, `approved`, `staffID`, `comments`  FROM `BudgetDetailsBalance`  WHERE `BudgetDetailID` = " . $budgetDetailID . " and `BudgetBalID` = " . $budgetBalID;
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_num_rows($result) == 0 ) {
          			
			// Free result set
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

			closeDB( $dbHandle );
			return array( FAIL, "There is no saved " . $budgetfor . " budget for " . date("F Y", mktime(0,0,0,$monthYear['month'],1,$monthYear['year'])));
		}
		else
		{
			while ( $row = mysqli_fetch_array($result, MYSQLI_ASSOC) )
			{						
				$balance = $row;
			}
		}
          			
	   // Free result set
	   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }


		closeDB( $dbHandle );
		return array( SUCCESS, $budgetHouseSlct, $savedBudgetItems, $balance );
	}
	
	//function getCellValue( $budgetfor, $month, $year, $budgetHouseSlct, $savedBudgetItems )
	function getCellValue( $budgetDetailID, $month, $year, $budgetHouseSlct, $savedBudgetItems )
	{
		$cellVall = 0;
		$dbHandle = loginToDB();
		
		$query = "SELECT `amount` FROM `BudgetDetails`  WHERE `BudgetDetailID` = " . $budgetDetailID . " AND `month` = " . $month . " AND `year` = '" . sql_quote( $dbHandle,  $year ) . "' AND `houseID` = " . $budgetHouseSlct . " AND budgetItemID = " . $savedBudgetItems . "";
		$result = mysqli_query( $dbHandle, $query  );
		
		while ( $row = mysqli_fetch_array($result, MYSQLI_ASSOC) )
		{						
			$cellVall = $row['amount'];
		}
          			
		// Free result set
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

		closeDB( $dbHandle );
		return $cellVall;
	}
	
	function saveReconToDB( $formdata )
	{
		//var_dump($formdata);
		  $retStr = array( SUCCESS, "" );
		  $dbHandle = loginToDB();
		  list( $mth, $yy ) = explode(" ", $formdata['summarymonth'] );
		  global  $month_names;

		  // Save Reconciliation Data
		  $query  = "REPLACE INTO `ReconDetailsBalance`(`reconFor`, `month`, `year`, `cardnumber`, `beginBalance`, `additions`, `subtractions`, `staffID`, `comments` )  ";
		  $query .= "VALUES ( "; 
		  $query .=  "'" . sql_quote( $dbHandle,  $formdata['homename'] ) . "', ";				 
		  $query .=  $month_names[$mth] . ", ";
		  $query .=  "'" . sql_quote( $dbHandle,  $yy ) . "', ";		
		  $query .=  "'" . sql_quote( $dbHandle,  $formdata['cardnumber'] ) . "', ";	 
		  $query .=  $formdata['beginbalance']  . ", ";
		  $query .=  zeroValue( $formdata['additions'] ) . ", ";
		  $query .=  $formdata['subtractions']  . ", ";
		  $query .=  $formdata['staffID']  . ", ";
		  $query .=  "'" . sql_quote( $dbHandle,  addslashes( $formdata['comments'] ) ) . "' ";
		  $query .= " )";		  
		  //echo $query . "<br>"; 
		  //exit;
		  mysqli_query( $dbHandle, $query  );
		  if ( mysqli_errno( $dbHandle ) != 0 )
		  {
			$retStr = array( FAIL, mysqli_error($dbHandle) );
          			
                               // Free result set
                               if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }


		closeDB( $dbHandle );
			return $retStr;
		  }
		  
		  // Save Budget item details		  
		  for ( $i = 1; $i <= $formdata['tablerows']; $i++ )
		  {
		  	  if ( trim($formdata['activitydate'.$i]) == '' ) { continue; }
		  	  list( $reconDtMth, $reconDtDy, $reconDtYr )  = explode("/", $formdata['activitydate'.$i] );
			  $dbDate = $reconDtYr . "-" . ( ($reconDtMth < 10) ? ( '0' . $reconDtMth ) : $reconDtMth ) . "-" . ( ($reconDtDy < 10) ? ( '0' . $reconDtDy ) : $reconDtDy );
			  $query  = "REPLACE  INTO `ReconcilationDetails`( `reconDetailID`, `reconFor`, `month`, `year`, `cardnumber`, `reconDate`, `reconDetailDesc`, `reconItemAmt1`, `reconItemAmt2`, `reconItemAmt3`, `reconItemAmt4`, `reconItemAmt5`, `reconItemAmt6`, `reconItemAmt7`, `reconItemAmt8`, `reconItemAmt9`, `reconItemAmt10`, `reconItemAmt11`, `reconItemAmt12`, `reconItemAmt13`, `reconItemAmt14`, `reconItemAmt15`, `reconItemAmt16`, `reconItemAmt17`, `reconItemAmt18`, `reconItemAmt19`) ";
			  $query .= "VALUES ( "; 
			  $query .=  zeroValue( $formdata['reconDetailID'.$i] ) . ", ";
			  $query .=  "'" . sql_quote( $dbHandle,  $formdata['homename'] ) . "', ";				
			  $query .=  $month_names[$mth] . ", ";
		  	  $query .=  "'" . sql_quote( $dbHandle,  $yy ) . "', ";		
		  	  $query .=  "'" . sql_quote( $dbHandle,  $formdata['cardnumber'] ) . "', ";	 
			  $query .=  "'" . sql_quote( $dbHandle,  $dbDate ) . "', ";
			  $query .=  "'" . sql_quote( $dbHandle,  addslashes($formdata['details'.$i]) ) . "', ";
			  $query .=  zeroValue( $formdata['income'.$i] )  . ", " . zeroValue( $formdata['gasbought'.$i] )  . ", " . zeroValue( $formdata['beginmileage'.$i] )  . ", ";
			  $query .=  zeroValue( $formdata['endmileage'.$i] )  . ", " . zeroValue( $formdata['totalmileage'.$i] )  . ", " . zeroValue( $formdata['otherexpenses'.$i] )  . ", ";
			  $query .=  zeroValue( $formdata['kidsallowance'.$i] )  . ", " . zeroValue( $formdata['bankcharges'.$i] )  . ", " . zeroValue( $formdata['grocery'.$i] )  . ", ";
			  $query .=  zeroValue( $formdata['food'.$i] )  . ", " . zeroValue( $formdata['schoolexpenses'.$i] )  . ", " . zeroValue( $formdata['clothing'.$i] )  . ", ";
			  $query .=  zeroValue( $formdata['utilitybills'.$i] )  . ", " . zeroValue( $formdata['houserepairs'.$i] )  . ", " . zeroValue( $formdata['carrepairs'.$i] )  . ", ";
			  $query .=  zeroValue( $formdata['officefood'.$i] )  . ", " . zeroValue( $formdata['eatout'.$i] )  . ", " . zeroValue( $formdata['traffic'.$i] )  . ", ";
			  $query .=  zeroValue( $formdata['totalexpenses'.$i] )  . " ";			  
			  $query .= " )";
			  			  				
			 // echo "<br><br><br>" . $query . "<br>"; 
			  
			  mysqli_query( $dbHandle, $query  );
			  if ( mysqli_errno( $dbHandle ) != 0 )
			  {
				$retStr = array( FAIL, mysqli_error($dbHandle) );
          			
                               // Free result set
                               if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }


		closeDB( $dbHandle );
				return $retStr;
			  }
		  }
          			
                               // Free result set
                               if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }


		closeDB( $dbHandle );		
	  	  return $retStr;
	}
	
	function getBudgetHouses( $budgetDetailID )
	{
		  $houselist = array();
		  $dbHandle = loginToDB();
		  
		  $query  = "SELECT  distinct b.`HouseName` FROM `BudgetDetails` a, `Houses` b WHERE a.`BudgetDetailID`=" . $budgetDetailID . " and a.`houseID`=b.`houseID` order by 1";
		  
		  //echo $query;
		  
		  $result = mysqli_query( $dbHandle, $query  );
		  while ( $row = mysqli_fetch_row( $result ) )
		  {
			 $houselist[]= $row[0];
		  }
						
	      // Free result set
	      if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
	
		  closeDB( $dbHandle );
		  return implode(", ", $houselist );
	}
	
	function getUnapprovedBugets() 
	{
		  $budgetlist = array();
		  $dbHandle = loginToDB();

		  $query  = "SELECT `BudgetDetailID`, `budgetFor`, `month`, `year`, `BudgetBalID` FROM `BudgetDetailsBalance` WHERE `approved` = 'N' ";
		  $query  .= " ORDER by 4 ASC, 3 ASC ";
		  $result = mysqli_query( $dbHandle, $query  );
		  while ( $row = mysqli_fetch_row( $result ) )
		  {
			 $budgetlist[]= $row;
		  }
						
	      // Free result set
	      if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
	
		  closeDB( $dbHandle );
		  return $budgetlist;
	}
		
	function saveBudgetToDB( $formdata, $staffID )
	{
	
		  $retStr = array( SUCCESS, "" );
		  $dbHandle = loginToDB();
		  
		  // Insert new budget Items
		  for( $i = 0; is_array($formdata['budgetItem']) && $i <= count($formdata['budgetItem']); $i++ )
		  {
		  		if ( !array_key_exists( $i, $formdata['budgetItem'] ) ) { continue; }
				
				if ( $formdata['budgetItem'][$i] == 1 ) {
					
					$query = " INSERT INTO `BudgetItems`(`budgetItem`) VALUES ('" . $formdata['newbudgetitem'][$i] . "')";
					mysqli_query( $dbHandle, $query  );
				  	if ( mysqli_errno( $dbHandle ) != 0 )
				  	{
						$retStr = array( FAIL, mysqli_error($dbHandle) );
							
						// Free result set
						if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		
						closeDB( $dbHandle );
						return $retStr;
				  	}
					$formdata['budgetItem'][$i] = mysqli_insert_id($dbHandle);
				}
		  }
		  
		  $balanceID = isset($formdata['budgetBalID']) ? $formdata['budgetBalID'] : getNextID( 'BudgetDetailsBalance', 'BudgetBalID', $dbHandle );
		  $budgetID = isset($formdata['budgetDetailID']) ? $formdata['budgetDetailID'] : getNextID( 'BudgetDetails', 'BudgetDetailID', $dbHandle );
		  
		  // Delete Old budget Balance for this budgetID
		  $query  = "DELETE FROM `BudgetDetailsBalance` WHERE `BudgetDetailID` = " . $budgetID . "";
		  mysqli_query( $dbHandle, $query  );
		  if ( mysqli_errno( $dbHandle ) != 0 )
		  {
				$retStr = array( FAIL, mysqli_error($dbHandle) );
          			
              	// Free result set
               	if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

				closeDB( $dbHandle );
				return $retStr;
		  }
		  
		  
		  $amount = ( trim($formdata['balance']) == "" ) ? 0 : trim($formdata['balance']);
		  // Save Balance brought forward
		  $query  = "INSERT INTO  `BudgetDetailsBalance`(`BudgetBalID`, `BudgetDetailID`, `budgetFor`, `month`, `year`, `amount`, `staffID`, `comments` ) ";
		  $query .= "VALUES ( " .  $balanceID . ", " . $budgetID . ", "; 
		  $query .=  "'" . sql_quote( $dbHandle,  $formdata['budgetfor'] ) . "', ";				 
		  $query .=  $formdata['budgetmth'] . ", ";
		  $query .=  "'" . sql_quote( $dbHandle,  $formdata['budgetyear'] ) . "', ";		 
		  $query .=  $amount  . ", ";
		  $query .=  $staffID  . ", ";
	      $query .=  "'" . sql_quote( $dbHandle,  addslashes( $formdata['comments'] ) ) . "' ";
		  $query .= " )";		  
		  
		  //echo $query . "<br>"; 
		  mysqli_query( $dbHandle, $query  );
		  if ( mysqli_errno( $dbHandle ) != 0 )
		  {
				$retStr = array( FAIL, mysqli_error($dbHandle) );
          			
              	// Free result set
               	if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

				closeDB( $dbHandle );
				return $retStr;
		  }
		  
		  
		  // Delete Old budget Balance for this budgetID
		  $query  = "DELETE FROM `BudgetDetails` WHERE `BudgetDetailID` = " . $budgetID . "";
		  mysqli_query( $dbHandle, $query  );
		  if ( mysqli_errno( $dbHandle ) != 0 )
		  {
				$retStr = array( FAIL, mysqli_error($dbHandle) );
          			
              	// Free result set
               	if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

				closeDB( $dbHandle );
				return $retStr;
		  }
		  
		  // Save Budget item details		  
		  for ( $i = 0; $i <= count($formdata['budgetItem']); $i++ )
		  {
		  	  if ( !array_key_exists( $i, $formdata['budgetItem'] ) ) { continue; } 
			  
		  	  for ( $j = 0; $j < count($formdata['budgetHouseSlct']); $j++ )
		  	  {
				  $query  = "INSERT INTO  `BudgetDetails`(`BudgetDetailID`, `budgetFor`, `month`, `year`, `houseID`, `budgetItemID`, `amount`) ";
				  $query .= "VALUES ( " .  $budgetID . ", " ; 
				  $query .=  "'" . sql_quote( $dbHandle,  $formdata['budgetfor'] ) . "', ";				 
				  $query .=  $formdata['budgetmth'] . ", ";
				  $query .=  "'" . sql_quote( $dbHandle,  $formdata['budgetyear'] ) . "', ";
				  $query .=  $formdata['budgetHouseSlct'][$j]  . ", ";
				  $query .=  $formdata['budgetItem'][$i]  . ", ";
				  $query .=  ( ( trim($formdata['itemAmount' . ($j + 1)][$i]) == "" ) ? 0 : trim($formdata['itemAmount' . ($j + 1)][$i]) )  . " ";
				  $query .= " )";
				 //echo $query . "<br>"; 
				  mysqli_query( $dbHandle, $query  );
				  if ( mysqli_errno( $dbHandle ) != 0 )
				  {
					$retStr = array( FAIL, mysqli_error($dbHandle) );
          			
				   	// Free result set
				   	if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

					closeDB( $dbHandle );
					return $retStr;
				  }
			  }
		  }
          			
	     // Free result set
	     if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

		  closeDB( $dbHandle );
		  $retStr[1] = $budgetID;
	  	  return $retStr;
	}
?>