<?php
	
	function getStateTimezone()
	{
		$dbHandle = loginToDB();
		$timezone = array();
		
	 	$query   = "SELECT `TimeZoneID` FROM `StateLookup` WHERE `StateAbbrev` = '" . $_POST['stateCD'] . "'";
				
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return  "";
		}
		
		while ( $row = mysqli_fetch_assoc( $result ) )
		{
			$timezone[] = $row;
		}
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return $timezone;
	}
	
	function getTimezones()
	{
		$dbHandle = loginToDB();
		$timezones = array();
		
	 	$query   = "SELECT * FROM `USTimeZones`  ";
				
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return array( FAIL, "" );
		}
		
		while ( $row = mysqli_fetch_assoc( $result ) )
		{
			$timezones[] = $row;
		}
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return array( SUCCESS, $timezones );
	}
	
	function getServiceRegion( $stateID )
	{
		$dbHandle = loginToDB();
		$stateRgn = array();
		
	 	$query   = "SELECT * FROM `ServiceRegionsByState` WHERE `StateID` =  " .$stateID . "";
				
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return array( FAIL, "" );
		}
		
		while ( $row = mysqli_fetch_assoc( $result ) )
		{
			$stateRgn[] = $row;
		}
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return array( SUCCESS, $stateRgn );
	}
	
	function getServiceRegionsByStateID( $stateID )
	{
		$dbHandle = loginToDB();
		$stateRgn = array();
		
	 	$query   = "SELECT * FROM `ServiceRegionsByState` WHERE `StateID` =  " .$stateID . "";
				
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return array( FAIL, "" );
		}
		
		while ( $row = mysqli_fetch_assoc( $result ) )
		{
			$stateRgn[] = $row;
		}
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return array( SUCCESS, $stateRgn );
	}
	
	function getServiceRegionsByStateCD()
	{
		$dbHandle = loginToDB();
		$stateRgn = array();
		if ( !$dbHandle ) {
			return $stateRgn;
		}
				
	 	$query  = "SELECT  a.`RegionID`, a.`RegionName` FROM `ServiceRegionsByState` a, `StateLookup` b  ";
		$query .= "WHERE a.`StateID`=b.`StateID` and b.`StateAbbrev`= '" . $_POST['stateCD'] . "'  ";
									
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return array( FAIL, "Unable to retrieve your state's service regions." );
		}
		
		while ( $row = mysqli_fetch_assoc( $result ) )
		{
			$stateRgn[] = $row;
		}
				
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return $stateRgn;
	}
	
	function getStateID( $stateCd )
	{
		$dbHandle = loginToDB();
		
	 	$query   = "SELECT `StateID` FROM `StateLookup` WHERE `StateAbbrev`='" . $stateCd . "'";
				
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return 0;
		}
		
 		$row = mysqli_fetch_assoc( $result );

		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return $row['StateID'];
	}
	
	function writeCorpInfoToDB( $configRec )
	{
		$dbHandle = loginToDB();
		
		$query ="DELETE FROM `CorporateInformation` ";
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return array( FAIL, "Unable to save Corporate Information to the database. Please contact the systems administrator" );
		}
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		
		$query  = "INSERT INTO `CorporateInformation`(`Vision`, `Mission`) VALUES ( ";
		$query   .= "'" . sql_quote( $dbHandle, $configRec['vision'] ) . "', ";	
		$query   .= "'" . sql_quote( $dbHandle, $configRec['mission'] ) . "' ";		
		$query .= " )  ";
		
		$result = mysqli_query( $dbHandle, $query  );		
	
		if ( mysqli_errno($dbHandle) != 0 ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return array( FAIL, "Unable to save Corporate Information to the database. Please contact the systems administrator" );
		}
		else {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
			return array( SUCCESS, "" );
		}
			
	}
	
	function writeProgramsToDB( $configRec )
	{
		$dbHandle = loginToDB();
		
		$query ="DELETE FROM `Programs` ";
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return array( FAIL, "Unable to save Programs to the database. Please contact the systems administrator" );
		}
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		
		foreach( $configRec as $cgfKey => $cfgValue )
		{
			$query  = "INSERT INTO `Programs`(`ProgramID`, `ProgramDescription`)  ";
			$query .= "SELECT `ServiceID`, `Name` as ServiceName FROM `ServicesProvidedLkup` WHERE `ServiceID`=" . $cfgValue;
			
			$result = mysqli_query( $dbHandle, $query  );		
		
			if ( mysqli_errno($dbHandle) != 0 ) {
				if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
				closeDB( $dbHandle );					
				return array( FAIL, "Unable to save Programs to the database. Please contact the systems administrator" );
			}
		} 
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
		
		return array( SUCCESS, "" );
	}
	
	function getMissionStaement()
	{
		$dbHandle = loginToDB();
		
	 	$query   = "SELECT  `Mission` FROM `CorporateInformation`";
				
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return "";
		}
		
 		$row = mysqli_fetch_assoc( $result );

		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return isset($row['Mission']) ? $row['Mission'] : '';
	}
	
	function getVisionInfo()
	{
		$dbHandle = loginToDB();
		
	 	$query   = "SELECT  `Vision` FROM `CorporateInformation`";
				
		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return "";
		}
		
 		$row = mysqli_fetch_assoc( $result );

		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return isset($row['Vision']) ? $row['Vision'] : '';
	}
	
	
	function writeConfigToDB( $configRec )
	{	
		$dbHandle = loginToDB();
		$query    = " Delete from `ConfigServices` ";
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno($dbHandle) != 0 ) {
			$errorNumber = mysqli_errno($dbHandle);
			$errorMessage = mysqli_error($dbHandle);
			mysqli_rollback($dbHandle);
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
			return array( FAIL, "writeConfigToDB() failed with Error Code: " . $errorNumber  . " and Error Message: " . $errorMessage . " " );
		}
		
		$query    = " Delete from `ManagementTeam` ";
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno($dbHandle) != 0 ) {
			$errorNumber = mysqli_errno($dbHandle);
			$errorMessage = mysqli_error($dbHandle);
			mysqli_rollback($dbHandle);
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
			return array( FAIL, "writeConfigToDB() failed with Error Code: " . $errorNumber  . " and Error Message: " . $errorMessage . " " );
		}
		
		$query    = " Delete from `BODTeam` ";
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno($dbHandle) != 0 ) {
			$errorNumber = mysqli_errno($dbHandle);
			$errorMessage = mysqli_error($dbHandle);
			mysqli_rollback($dbHandle);
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
			return array( FAIL, "writeConfigToDB() failed with Error Code: " . $errorNumber  . " and Error Message: " . $errorMessage . " " );
		}
		
		closeDB( $dbHandle );
						
		$configID = ( isset($configRec['configID']) && $configRec['configID'] <> 0 ) ? $configRec['configID'] : getNextID( 'AgencyConfig', 'ConfigID' );
		$agencyID = ( isset($configRec['agencyID']) && $configRec['agencyID'] <> 0 ) ? $configRec['agencyID'] : getNextID( 'AgencyDetails', 'AgencyID' );		
		$servicesID = ( isset($configRec['servicesID']) && $configRec['servicesID'] <> 0 ) ? $configRec['servicesID'] : getNextID( 'ConfigServices', 'ServicesID' );
		$managerID = ( isset($configRec['managerID']) && $configRec['managerID'] <> 0 ) ? $configRec['managerID'] : getNextID( 'ManagementTeam', 'ManagerID' );
		$bodID = ( isset($configRec['bodID']) && $configRec['bodID'] <> 0 ) ? $configRec['bodID'] : getNextID( 'BODTeam', 'BodID' );
		$stateID = getStateID( trim( $configRec['officestate'] ) );
		
		$dbHandle = loginToDB();
		
		if ( ! mysqli_begin_transaction( $dbHandle, MYSQLI_TRANS_START_READ_WRITE ) ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
						
			return array( FAIL, "Unable to begin an insert transaction in writeConfigToDB(). Please notify the application administrator" );
		}
		
		//
		// Management Team
		//
		$seqID = 1;
		for ( $i = 0; isset($configRec['managername']) && $i < count($configRec['managername']); $i++ )
		{
			if (  !isset($configRec['managername'][$i]) || ( isset($configRec['managername'][$i]) && ( trim($configRec['managername'][$i]) == '' ) ) ) {
				continue;
			}
			$query    = "REPLACE INTO `ManagementTeam`(`ManagerID`, `SeqID`, `Officer`, `Sex`, `Title`, `PhotoFile` ) VALUES ( ";
			$query   .= "" . $managerID . ", " . $seqID++ . ", ";
			$query   .= "'" . sql_quote( $dbHandle, $configRec['managername'][$i] ) . "', ";
			$query   .= "'" . sql_quote( $dbHandle, $configRec['managersex'.($i+1)] ) . "', ";
			$query   .= "'" . sql_quote( $dbHandle, $configRec['managertitle'][$i] ) . "', ";
			$query   .= "'" . sql_quote( $dbHandle, $configRec['mgmtPhotoFile'][$i] ) . "' ";
			$query   .= " ) ";
			
			//echo $query . "<br/>";
			$result = mysqli_query( $dbHandle, $query  );
			if ( mysqli_errno($dbHandle) != 0 ) {
				$errorNumber = mysqli_errno($dbHandle);
				$errorMessage = mysqli_error($dbHandle);
				mysqli_rollback($dbHandle);
				if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
				closeDB( $dbHandle );
				return array( FAIL, "writeConfigToDB() failed with Error Code: " . $errorNumber  . " and Error Message: " . $errorMessage . " " );
			}
		}
		
		//
		// BOD Tesm
		//
		$seqID = 1;
		for ( $i = 0; isset($configRec['bodname']) && $i < count($configRec['bodname']); $i++ )
		{
			if (  !isset($configRec['bodname'][$i]) || ( isset($configRec['bodname'][$i]) && ( trim($configRec['bodname'][$i]) == '' ) ) ) {
				continue;
			}
			$query    = "REPLACE INTO `BODTeam`(`BodID`, `SeqID`, `Director`, `Sex`, `Title`, `PhotoFile` ) VALUES ( ";
			$query   .= "" . $bodID . ", " . $seqID++ . ", ";
			$query   .= "'" . sql_quote( $dbHandle, $configRec['bodname'][$i] ) . "', ";
			$query   .= "'" . sql_quote( $dbHandle, $configRec['bodsex'.($i+1)] ) . "', ";
			$query   .= "'" . sql_quote( $dbHandle, $configRec['bodtitle'][$i] ) . "', ";
			$query   .= "'" . sql_quote( $dbHandle, $configRec['bodPhotoFile'][$i] ) . "' ";
			$query   .= " ) ";

			$result = mysqli_query( $dbHandle, $query  );
			if ( mysqli_errno($dbHandle) != 0 ) {
				$errorNumber = mysqli_errno($dbHandle);
				$errorMessage = mysqli_error($dbHandle);
				mysqli_rollback($dbHandle);
				if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
				closeDB( $dbHandle );
				return array( FAIL, "writeConfigToDB() failed with Error Code: " . $errorNumber  . " and Error Message: " . $errorMessage . " " );
			}
		}
		
		//
		// Config Services and Sub Services
		//
			
		$k = 1;
		$subServ = array( 1 => 0 );
		
		for ( $i = 0; $i < count($configRec['services-provided']); $i++ )
		{
			
			$tmpquery    = "REPLACE INTO `ConfigServices`(`ServicesID`, `Service`, `SubService` ) VALUES ( ";
			$tmpquery   .= "" . $servicesID . ", " . $configRec['services-provided'][$i] . ", ";
			
			for ( $j = 0; isset($configRec['sub-services-provided']) && is_array($configRec['sub-services-provided']) && $j < count($configRec['sub-services-provided']); $j++ )
			{
				list( $serv, $subserv ) = explode( "-", $configRec['sub-services-provided'][$j] );
				if ( $serv == $configRec['services-provided'][$i] ) {
					$subServ[$k++] = $subserv;
				}
			}
			for( $ss = 1; $ss <= count($subServ); $ss++ )
			{
				//$query   = $tmpquery . $subServ[$ss] . ( ( $ss < count($subServ) ) ? ", " : "" ) . " ) ";
				$query   = $tmpquery . $subServ[$ss] .  " ) ";
								
				$result = mysqli_query( $dbHandle, $query  );
				if ( mysqli_errno($dbHandle) != 0 ) {
					$errorNumber = mysqli_errno($dbHandle);
					$errorMessage = mysqli_error($dbHandle);
					mysqli_rollback($dbHandle);
					if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
					closeDB( $dbHandle );
					return array( FAIL, "writeConfigToDB() failed with Error Code: " . $errorNumber  . " and Error Message: " . $errorMessage . " " );
				}
			}
			
			$k = 1;
			$subServ = array( 1 => 0 );
		}
		
		// 
		// Agency Details
		//
		$query    = "REPLACE INTO `AgencyDetails`(`AgencyID`, `AgencyFullname`, `AgencyShortname`, `NPR_Number`, `LicenseNumber`, ";
		$query   .= " `OfficeAddress`, `OfficeCity`, `OfficeStateZip`, `OfficeRegion`, `OfficeHoursStart`, `OfficeHoursEnd`, ";
		$query   .= " `WorkDays`, `MailingAddress`, `MailingCity`, `MailingStateZip`, `Telephone`, `Fax`, `Email`, ";
		$query   .= " `AltTelephone`, `AltFax`, `AltEmail`, `Copyright` ) VALUES ( ";
		$query   .= "" . $agencyID . ", "; 
		$query   .= "'" . sql_quote( $dbHandle, $configRec['agencyfname'] ) . "', ";
		$query   .= "'" . sql_quote( $dbHandle, $configRec['agencysname'] ) . "', ";
		$query   .= "'" . sql_quote( $dbHandle, $configRec['nprnumber'] ) . "', ";
		$query   .= "'" . sql_quote( $dbHandle, $configRec['licensenumber'] ) . "', ";
		
		$query   .= "'" . sql_quote( $dbHandle, $configRec['officeaddress'] ) . "', ";
		$query   .= "'" . sql_quote( $dbHandle, $configRec['officecity'] ) . "', ";
		$query   .= "'" . sql_quote( $dbHandle, $configRec['officestate'] . " " . $configRec['officezip']) . "', ";
		$query   .= "'" . sql_quote( $dbHandle, $configRec['officeregion'] ) . "', ";
		$query   .= "'" . sql_quote( $dbHandle, $configRec['office_hours_start'] ) . "', ";
		$query   .= "'" . sql_quote( $dbHandle, $configRec['office_hours_end'] ) . "', ";
		
		$query   .= "'" . sql_quote( $dbHandle, "Monday - Friday" ) . "', ";
		$query   .= "'" . sql_quote( $dbHandle, $configRec['mailingaddress'] ) . "', ";
		$query   .= "'" . sql_quote( $dbHandle, $configRec['mailingcity'] ) . "', ";
		$configRec['mailingstate'] = ( (trim($configRec['mailingstate']) == '') && ($configRec['mailchecked'] == 1) ) ? trim($configRec['officestate']) : trim($configRec['mailingstate']);
		$query   .= "'" . sql_quote( $dbHandle, $configRec['mailingstate'] . " " . $configRec['mailingzip'] ) . "', ";
		$query   .= "'" . sql_quote( $dbHandle, $configRec['agencyphone'] ) . "', ";
		$query   .= "'" . sql_quote( $dbHandle, $configRec['agencyfax'] ) . "', ";
		$query   .= "'" . sql_quote( $dbHandle, $configRec['agencyemail'] ) . "', ";
		
		$query   .= "'" . sql_quote( $dbHandle, $configRec['altagencyphone'] ) . "', ";
		$query   .= "'" . sql_quote( $dbHandle, $configRec['altagencyfax'] ) . "', ";
		$query   .= "'" . sql_quote( $dbHandle, $configRec['altagencyemail'] ) . "', ";
		$query   .= "'" . sql_quote( $dbHandle, ( ( isset($configRec['copyright']) ) ? $configRec['copyright'] : date("Y") ) ) . "' ";
				
		$query   .= " ) ";
			
		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno($dbHandle) != 0 ) {
			$errorNumber = mysqli_errno($dbHandle);
			$errorMessage = mysqli_error($dbHandle);
			mysqli_rollback($dbHandle);
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
			return array( FAIL, "writeConfigToDB() failed with Error Code: " . $errorNumber  . " and Error Message: " . $errorMessage . " " );
		}
		
		//
		// Agency Config
		//
		$query   = "REPLACE INTO `AgencyConfig`(`ConfigID`, `SHOWMGMT`, `SHOWBOD`, `CHART_BACK`, `CHART_BACK_DAYS`, ";
		$query   .= "`CHART_PERIOD`, `STATEID`, `OFC_MAIL_SAME`, `TIMEZONE`, `OTHER_CALL`, `CLIENTREF`, `SHOWMAP`, `ONLINEDOCS`, ";
		$query   .= "`FILEUPLOAD`, `EMPLOYMENT`, `IDLE_TIMEOUT`, `AgencyID`, `ServicesID`, `ManagerID`, `BodID`) VALUES ( ";
		$query   .= "" . $configID . ", " ;
		//$query   .= "'" . ( isset($configRec['currenv']) ? $configRec['currenv'] : '' ) . "', " ;
		$query   .= "'" . trim(strtoupper($configRec['mgmtlist'])) . "', " ;
		$query   .= "'" . trim(strtoupper($configRec['bodlist'])) . "', " ;
		$query   .= "'" . trim(strtoupper($configRec['chartback'])) . "', " ;
		if ( $configRec['chartback'] == 'N' ) {
			$chartdays =  0;
	   }
	   else {
			$chartdays = $configRec['chartbacklength'];
	   }
	   $query   .= "" . $chartdays . ", " ;
		
	   $query   .= "" . trim(strtoupper($configRec['chartbackperiod'])) . ", " ;
	   $query   .= "" . $stateID . ", " ;
	   $query   .= "" . $configRec['mailchecked'] . ", " ;
	   $query   .= "" . $configRec['time_zone'] . ", " ;
	   if ( strtoupper(trim($configRec['clientcall'])) == 'OTHER' ) {
	   		$query   .= "'Y', " ;
	   		$query   .= "'" . trim($configRec['othercallvalue']) . "', " ;
	   }
	   else {
			$query   .= "'N', " ;
			$query   .= "'" . trim($configRec['clientcall']) . "', " ;
	   }
	   $query   .= "'" . trim(strtoupper($configRec['contactmap'])) . "', " ;
	   /*
	   $query   .= "'" . trim(strtoupper($configRec['onlinedocs'])) . "', " ;
	   $query   .= "'" . trim(strtoupper($configRec['fileupload'])) . "', " ;
	   $query   .= "'" . trim(strtoupper($configRec['employment'])) . "', " ;
	   */
	   $query   .= "'N', 'N', 'N', ";
	   
	   $query   .= "" . ( (isset($configRec['idletimeout']) && (trim($configRec['idletimeout']) != '')) ? $configRec['idletimeout'] : 30 )   . ", " ;
	   $query   .= "" . $agencyID . ", " . $servicesID . ", " . $managerID . ", " . $bodID . " " ;
	   $query   .= " ) ";

		$result = mysqli_query( $dbHandle, $query  );
		if ( mysqli_errno($dbHandle) != 0 ) {
			$errorNumber = mysqli_errno($dbHandle);
			$errorMessage = mysqli_error($dbHandle);
			mysqli_rollback($dbHandle);
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
			return array( FAIL, "writeConfigToDB() failed with Error Code: " . $errorNumber  . " and Error Message: " . $errorMessage . " " );
		}
		
		/* If code reaches this point without errors then commit the data in the database */
		mysqli_commit($dbHandle);
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
		
		return array( SUCCESS, '' );
	}
	
	function copyConfigureAdminToStaff() 
	{
			$mysqli = loginToDB();
			
			// Disable foreign key checks
			$query  = "SET foreign_key_checks = 0";
			$statement = mysqli_prepare($mysqli, $query);
			mysqli_stmt_execute($statement);
			
				
			// now get the highest Staff ID plus 1 from the staff table
			$query = "SELECT ifnull(max(`StaffID`), 0 ) + 1 as StaffID FROM `Staff`";
			$result = mysqli_query( $mysqli, $query  );	
			$staffRow = mysqli_fetch_assoc( $result );
			$staffID = $staffRow['StaffID'];
		
			
			// Update configue tables but make sure they exists
			$query = "SHOW TABLES LIKE 'Configure%'";
			$result = mysqli_query($mysqli, $query);
		
			// Check if any result is returned
			if (mysqli_num_rows($result) > 0) {
			
				if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
				
				// Make sure Configure ID not in Main Staff tables
				$query = "SELECT a.* FROM `StaffAuthAz` a, `ConfigureStaffAuthAz` b WHERE a.Username=b.Username";
				$result = mysqli_query( $mysqli, $query  );	
				if (mysqli_num_rows($result) > 0) {
					
					if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
					
					// enable foreign key checks
					$query  = "SET foreign_key_checks = 1";
					$statement = mysqli_prepare($mysqli, $query);
					mysqli_stmt_execute($statement);
					
					closeDB( $mysqli );
					return array( SUCCESS, '' );
				}
				
				// update Staff ID on configure tables
				$query = "UPDATE `ConfigureStaff` SET `StaffID`=" . $staffID . "";
				$result = mysqli_query($mysqli, $query);
				
				$query = "UPDATE `ConfigureStaffAuthAz` SET `StaffID`=" . $staffID . "";
				$result = mysqli_query($mysqli, $query);
				
				$query = "UPDATE `ConfigureStaffIndicators` SET `StaffID`=" . $staffID . "";
				$result = mysqli_query($mysqli, $query);
				
				// Update done, so copy Configure tables to Staff
				$query = "insert into Staff select * from ConfigureStaff";
				$result = mysqli_query($mysqli, $query);
				
				$query = "insert into StaffAuthAz select * from ConfigureStaffAuthAz";
				$result = mysqli_query($mysqli, $query);
				
				$query = "insert into StaffIndicators select * from ConfigureStaffIndicators";
				$result = mysqli_query($mysqli, $query);
				
			}
				
			// enable foreign key checks
			$query  = "SET foreign_key_checks = 1";
			$statement = mysqli_prepare($mysqli, $query);
			mysqli_stmt_execute($statement);
			
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $mysqli );
			
			return array( SUCCESS, '' );
			
	}
?>
