<?php
	
	//
	// Get  Health Appointment Types
	//
	function getAppointmentTypes( $src = 0 )
	{
		$retStr = array();
		$dbHandle = loginToDB();
		
		$query  = "SELECT * FROM ClientHealthAppointmentItems";
		
		$result = mysqli_query( $dbHandle, $query  );
		while ( $row = mysqli_fetch_row( $result ) )
		{						
			$retStr[$row[0]] = ( $src == 0 ) ? array( $row[1], $row[2] ) : $row[2];
		}
          			
	   // Free result set
	   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

	   closeDB( $dbHandle );	
	   return $retStr;
	}
	
	
	//
	// Get  Health Items
	//
	function getClientHealthItems()
	{
		$dbHandle = loginToDB();
		$healthlist = array();
		
		$query  = "SELECT `HealthExamID`, `ItemName`, `NextDue` FROM `ClientHealthAppointmentItems` ORDER BY 2";

		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			$errorNumber = mysqli_errno($dbHandle);
			$errorMessage = mysqli_error($dbHandle);
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return array( FAIL, "getClientHealthItems() failed with Error Code: " . $errorNumber  . " and Error Message: " . $errorMessage . " " . PHP_EOL . "Please notify the administrator." );
		}
		
		while ( $row = mysqli_fetch_assoc( $result ) )
		{
			$healthlist[] = $row;
		}
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return array( SUCCESS, $healthlist );
	}
	
	function setHealthAppointments( $clientRec )
	{
		$retStr = array();
		$nextAppt = getAppointmentTypes( 1 );
		$dbHandle = loginToDB();
		
		for ( $i = 1; $i <= 10; $i++ )   
		{
			if ( isset($clientRec['clientname'.$i]) && isset($clientRec['appointment'.$i]) && 
			     ( isset($clientRec['apptdate'.$i]) && ( trim($clientRec['apptdate'.$i]) != '' ) )  )
			{
				$query  = "INSERT INTO `ClientHealthAppointments`(`ClientID`, `HealthExamID`, `DateOfVisit`, `DateOfNextVisit`, `Comments`) ";
				$query .= " VALUES ( " . $clientRec['clientname'.$i] . ", " . $clientRec['appointment'.$i] . ", ";
				$query .=  "STR_TO_DATE('" . sql_quote( $dbHandle,  $clientRec['apptdate'.$i] ) . "', '%m/%d/%Y'), ";
								
				$query .=  "STR_TO_DATE('" . sql_quote( $dbHandle,  $clientRec['apptdate'.$i] ) . "', '%m/%d/%Y') + INTERVAL " . $nextAppt[$clientRec['appointment'.$i]] . " DAY, ";
				$query .=  "'" . sql_quote( $dbHandle,  $clientRec['comments'.$i] ) . "' ";
				$query .= " )";
				$query .= " ON DUPLICATE KEY UPDATE " ;
				$query .= " DateOfVisit = STR_TO_DATE('" . sql_quote( $dbHandle,  $clientRec['apptdate'.$i] ) . "', '%m/%d/%Y'), ";
				$query .= " DateOfNextVisit = STR_TO_DATE('" . sql_quote( $dbHandle,  $clientRec['apptdate'.$i] ) . "', '%m/%d/%Y') + INTERVAL " . $nextAppt[$clientRec['appointment'.$i]] . " DAY, ";
				$query .= " Comments = '" . sql_quote( $dbHandle,  $clientRec['comments'.$i] ) . "' ";
				
				//echo $query . "<br/>";
				
			
				mysqli_query( $dbHandle, $query  );
			  	if ( mysqli_errno( $dbHandle ) != 0 )
				{
					$retStr = array( FAIL, mysqli_error($dbHandle) );
          			
				   // Free result set
				   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }


					closeDB( $dbHandle );	
					return $retStr;	
				}
				
			}
		}
          			
	   // Free result set
	   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }


		closeDB( $dbHandle );	
		$retStr = array( SUCCESS, "All requested appointments were successfully set" );
		return $retStr;	  
	}
	
	function updtHealthAppointments( $clientRec )
	{
		$retStr = array();
		$nextAppt = getAppointmentTypes( 1 );
		$dbHandle = loginToDB();
		
		if ( ! mysqli_begin_transaction( $dbHandle, MYSQLI_TRANS_START_READ_WRITE ) ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );
						
			return array( FAIL, "Unable to begin an updatre transaction. Please notify the application administrator" );
		}
		
		for ( $i = 0; $i < $clientRec['numclientappts']; $i++ )   
		{
			if ( isset($clientRec['appointment'.$i]) && ( isset($clientRec['apptdate'.$i]) && ( trim($clientRec['apptdate'.$i]) != '' ) )  )
			{
				$query  = "UPDATE `ClientHealthAppointments` SET ";
				$query .= " DateOfVisit = STR_TO_DATE('" . sql_quote( $dbHandle,  $clientRec['apptdate'.$i] ) . "', '%m/%d/%Y'), ";
				$query .= " DateOfNextVisit = STR_TO_DATE('" . sql_quote( $dbHandle,  $clientRec['apptdate'.$i] ) . "', '%m/%d/%Y') + INTERVAL " . $nextAppt[$clientRec['appointment'.$i]] . " DAY, ";
				$query .= " Comments = '" . sql_quote( $dbHandle,  $clientRec['comments'.$i] ) . "' ";		
				$query .= " where `ClientID`=" . $clientRec['clientname']. " AND `HealthExamID`=" . $clientRec['appointment'.$i] . " ";
			
				mysqli_query( $dbHandle, $query  );
			  	if ( mysqli_errno( $dbHandle ) != 0 )
				{
					$errorNumber = mysqli_errno($dbHandle);
					$errorMessage = mysqli_error($dbHandle);
					mysqli_rollback($dbHandle); 
					
					// Free result set
					if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
					closeDB( $dbHandle );
					$retStr =  array( FAIL, "updtHealthAppointments() failed with Error Code: " . $errorNumber  . " and Error Message: " . $errorMessage . " " );
				
					return $retStr;		
				}
				
			}
		}
          			
	   // Free result set
	   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

		/* If code reaches this point without errors then commit the data in the database */
		mysqli_commit($dbHandle);
		
		closeDB( $dbHandle );	
		$retStr = array( SUCCESS, "Appointments for " . getClientName( $clientRec['clientname'] ) . " were successfully updated." );
		return $retStr;	  
	}
	
	function cancelHealthAppointments( $clientRec )
	{
		$retStr = array();		
		$dbHandle = loginToDB();
		for ( $i = 1; $i <= 10; $i++ )
		{
			if ( isset($clientRec['clientname'.$i]) && isset($clientRec['appointment'.$i]) )
			{
				$query  = "DELETE FROM `ClientHealthAppointments` where ClientID = " . $clientRec['clientname'.$i] . " and  HealthExamID = " . $clientRec['appointment'.$i] . "";

				mysqli_query( $dbHandle, $query  );
			  	if ( mysqli_errno( $dbHandle ) != 0 )
				{
					$retStr = array( FAIL, mysqli_error($dbHandle) );
          			
				   // Free result set
				   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }


					closeDB( $dbHandle );	
					return $retStr;	
				}
			}
		}
          			
	   // Free result set
	   if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }


		closeDB( $dbHandle );	
		$retStr = array( SUCCESS, "All valid cancellation requests were successfully done." );
		return $retStr;	  
	}
	
	function getHealthAppointments( $clientRec )
	{
		$dbHandle = loginToDB();
		$healthlist = array();
		
		$query  = "SELECT `ClientID`, `HealthExamID`, FormatDateMMDDYYYY(`DateOfVisit`) AS DateOfVisit, FormatDateMMDDYYYY(`DateOfNextVisit`) AS DateOfNextVisit, `Comments` FROM `ClientHealthAppointments` WHERE `ClientID`=" . $clientRec['clientname'] . "";

		$result = mysqli_query( $dbHandle, $query  );		
		
		if ( mysqli_errno($dbHandle) != 0 ) {
			$errorNumber = mysqli_errno($dbHandle);
			$errorMessage = mysqli_error($dbHandle);
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return array( FAIL, "getHealthAppointments() failed with Error Code: " . $errorNumber  . " and Error Message: " . $errorMessage . " " . PHP_EOL . "Please notify the administrator." );
		}
		
		if ( mysqli_num_rows($result) == 0 ) {
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			closeDB( $dbHandle );					
			return array( ZEROROWS, "There are no appointments set for " . getClientName($clientRec['clientname']) . "." );
		}
		
		while ( $row = mysqli_fetch_assoc( $result ) )
		{
			$healthlist[] = $row;
		}
		
		if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
		closeDB( $dbHandle );
					
		return array( SUCCESS, $healthlist );
	
	}
	
?>