<?php
	list( $fncRtn, $medtypes) = getMedicationType();
	list( $stateCD, $zipCode ) = explode( " ", $agency_info['office_statezip'] );
	
	function getMedType( $inMedType )
	{
		global $medtypes;
		
		foreach( $medtypes as $mkey => $medtype	)
		{
			if ( $medtype['MedTypeID'] == $inMedType ) {
				return $medtype['MedTypeName'];
			}
		}
		return "";
	}
	
	if (  $step == 2 ) {
		
		$isFail = false;
		$medRec = getClientsMedications($_REQUEST);	
		$updtMessage = $medRec[1];	
		if ( $medRec[0] == FAIL ) {
			$isFail = true;
			$step = 1;
		}
		else {
			$medRec = $medRec[1];	
		}
	}
	else if (  $step == 3 ) {
		
		$meds = getMedicationList();
		list( $fncRtn, $medtypes) = getMedicationType();
		$programs = getCorpServicesProvided( $agency_info['services_provided'] );
		if ($programs[0] == SUCCESS ) {
			$programs = $programs[1];
		}
		else {
			$updtMessage = $programs[1];
			$isFail = true;
		}
		
		$medRec = getClientMedicationDetail($updmedparms);	
		
		if ( $medRec[0] == FAIL ) {
			$updtMessage = $medRec[1];	
			$isFail = true;
			$step = 1;
		}
		else {
			$medRec = $medRec[1];	
		}
	}
	else if (  $step == 4 ) {
		
		$_REQUEST['serviceName'] = getServiceName($_REQUEST['programID'], $stateCD );
		$isFail = false;
		$medRec = updateClientsMedication($_REQUEST);	
		$updtMessage = $medRec[1];	
		if ( $medRec[0] == FAIL ) {
			$isFail = true;
		}
		$step = 1;
	}
	
	if ( $step == 1 ) { 
		$meds = getMedicationList();
		$programs = getCorpServicesProvided( $agency_info['services_provided'] );
		if ($programs[0] == SUCCESS ) {
			$programs = $programs[1];
		}
		else {
			$updtMessage = $programs[1];
			$isFail = true;
		}
		
		//echo dpp($medtypes);
		
?>
		<form id="updtmed" class="row g-3 needs-validation" method="post" action="<?php echo $protocol; ?>://<?php echo $_SERVER['SERVER_NAME']; ?>/admin/index/dest/<?php echo $dest; ?>/step/2/" enctype="multipart/form-data" novalidate>
		<div class="card">
            <div class="card-body">
			   <h5 class="card-title"><?php echo $ADMIN_BREADCRUMB[$dest]; ?></h5>
			   <?php if ( isset($isFail) ) { ?>
			   		<div class="row mt-3 mb-3">
						<div class="col-md-1"></div>
						<div class="col-md-10 col-sm-offset-1 text-center">
							  <div class="alert  <?php echo ( $isFail === false ) ? "alert-success" : "alert-danger"; ?> text-center mb-1">
								<h4>
								<?php 
									echo $updtMessage;
								?>
								</h4>
								</div>
						</div>
						<div class="col-md-1"></div>
					</div>
			   <?php } ?>
              <!-- Floating Labels Form -->
              <div class="row">
			  		<div class="col-md-2 position-relative"></div>
					<div class="col-md-4 position-relative">
						<div class="form-floating mt-3">
							<select class="form-select js-select" name="programID" id="programID" aria-label="Service Program Name" required>
								  <option selected disabled value="">Choose a Service Program</option>
								  <option value="A">All Service Programs</option>
								  <?php 
								  	for ( $i = 0; $i < count($programs); $i++ ) { 
								  ?>
										<option value="<?php echo $programs[$i]['ServiceID']; ?>"><?php echo $programs[$i]['ServiceName']; ?></option>
								 <?php } ?>
							</select>
							<label  for="programID">Service Program Name</label>
							<div class="invalid-feedback">
								Please select a Service Program Name.
							</div>
					  	</div>
					</div>
					
					<div class="col-md-4 position-relative">
						<div class="form-floating mt-3">
							<select class="form-select js-select" name="clientID" id="clientID" aria-label="<?php echo ( isset($CLIENTREF) ? rtrim(trim($CLIENTREF), "s") : 'Client ' ); ?> Name" required>
								  <option selected disabled value="">Choose a <?php echo ( isset($CLIENTREF) ? rtrim(trim($CLIENTREF), "s") : 'Client ' ); ?></option>
							</select>
							<label  for="clientID"><?php echo ( isset($CLIENTREF) ? rtrim(trim($CLIENTREF), "s") : 'Client ' ); ?> Name</label>
							<div class="invalid-feedback">
								Please select a <?php echo ( isset($CLIENTREF) ? rtrim(trim($CLIENTREF), "s") : 'Client ' ); ?> Name.
							</div>
					  	</div>
					</div>
					
					<div class="col-md-2 position-relative"></div>
					
			</div>
								
			<div class="text-center mt-5 mb-5">
					<input type="hidden" name="clientTag" id="clientTag" value="<?php echo ( isset($CLIENTREF) ? rtrim(trim($CLIENTREF), "s") : 'Client ' ); ?>" />
                   <button type="submit" id="configureit" class="btn btn-primary mt-3 configbtn" name="submit">Get <?php echo ( isset($CLIENTREF) ? rtrim(trim($CLIENTREF), "s") : 'Client ' ); ?> Medications</button>
				   <button type="reset" class="btn btn-secondary mt-3 configbtn" name="btnreset">Start Over</button>
                </div>	
 			</div>
	   </div>
		
	</form>
<?php
	} else if ( $step == 2 ) {
?>
	<div class="card">
            <div class="card-body">
			   <h5 class="card-title"><?php echo $ADMIN_BREADCRUMB[$dest]; ?></h5>
			   
		<table class="table  datatable"> <!-- table-borderless -->
			<thead>
			  <tr>
				<th scope="col">Medication</th>
				<th scope="col">Prescription Date</th>
				<th scope="col">Start Date</th>
				<th scope="col">Medication Time</th>
				<th scope="col">Medication Type</th>
				<th scope="col">Dosage</th>
				<th scope="col">Medication Direction(s)</th>
				<th scope="col">Status</th>
				<th scope="col">Action(s)</th>
			  </tr>
			</thead>
			<tbody>
			<?php 
				for( $i = 0; $i < count($medRec); $i++ ) { 						
			?>
			  <tr>
				<td class="align-middle"><?php echo $medRec[$i]['MedName']; ?></td>
				<td class="align-middle"><?php echo $medRec[$i]['PrescriptionDate']; ?></td>
				<td class="align-middle"><?php echo $medRec[$i]['StartDate']; ?></td>
				<td class="align-middle"><?php echo $medRec[$i]['MedTime']; ?></td>
				
				<td class="align-middle"><?php echo getMedType( $medRec[$i]['MedType']); ?></td>
				
				<td class="align-middle"><?php echo $medRec[$i]['MedDosage']; ?></td>
				
				<td class="align-middle"><?php echo $medRec[$i]['Direction']; ?></td>
				
				<td class="align-middle"><?php echo $medRec[$i]['MedStatus']; ?></td>
				
				<td class="align-middle"><a href="<?php echo $protocol; ?>://<?php echo $_SERVER['SERVER_NAME']; ?>/admin/index/dest/updtmed/step/3/uparms/<?php echo $_REQUEST['clientID']; ?>-<?php echo $medRec[$i]['MedID']; ?>-<?php echo $medRec[$i]['SeqID']; ?>-<?php echo $medRec[$i]['TimeKey']; ?>-<?php echo $medRec[$i]['ServiceID']; ?>/"><i class="bi bi-pencil-square text-success fs-6" rel="tooltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Update <?php echo $medRec[$i]['MedTime']; ?> <?php echo $medRec[$i]['MedName']; ?>"></i></a> </td>
			  </tr>
		   <?php } ?>
		   </tbody>
		</table>
	</div>
	</div>
<?php
	} else if ( $step == 3 ) {
		
?>
	<form id="updtmed1" action="<?php echo $protocol; ?>://<?php echo $_SERVER['SERVER_NAME']; ?>/admin/index/dest/<?php echo $dest; ?>/step/4/" method="post" enctype="multipart/form-data" name="updtmeds" class="row g-3 needs-validation" id="asgnmeds" novalidate>
		<div class="card">
            <div class="card-body">
			   <h5 class="card-title"><?php echo $ADMIN_BREADCRUMB[$dest]; ?></h5>
			   <?php if ( isset($isFail) ) { ?>
			   		<div class="row mt-3 mb-3">
						<div class="col-md-1"></div>
						<div class="col-md-10 col-sm-offset-1 text-center">
							  <div class="alert  <?php echo ( $isFail === false ) ? "alert-success" : "alert-danger"; ?> text-center mb-1">
								<h4>
								<?php 
									echo $updtMessage;
								?>
								</h4>
						  </div>
						</div>
						<div class="col-md-1"></div>
					</div>
			   <?php } ?>
              <!-- Floating Labels Form -->
              <div class="row">
					<div class="col-md-4 position-relative">
						<div class="form-floating mt-3">
							<select class="form-select js-select" name="programID" id="programID" aria-label="Service Program Name" required>
								  <option selected disabled value="">Choose a Service Program</option>
								  <?php 
								  	for ( $i = 0; $i < count($programs); $i++ ) { 
									$svcSelected = ( $programs[$i]['ServiceID'] == $medRec[0]['ServiceID'] ) ? " SELECTED " : "";
								  ?>
										<option value="<?php echo $programs[$i]['ServiceID']; ?>" <?php echo $svcSelected ?>><?php echo $programs[$i]['ServiceName']; ?></option>
								 <?php } ?>
							</select>
							<label  for="programID">Service Program Name</label>
							<div class="invalid-feedback">
								Please select a Service Program Name.
							</div>
					  	</div>
					</div>
					
					<div class="col-md-4 position-relative">
						<div class="form-floating mt-3">
							<?php list( $uClientID, $uMedID, $uSeqID, $uTimeKey, $uServiceID ) = explode( "-", $updmedparms ); ?>
							<select class="form-select js-select" name="clientID" id="clientID" aria-label="<?php echo ( isset($CLIENTREF) ? rtrim(trim($CLIENTREF), "s") : 'Client ' ); ?> Name" readonly>
								  <option disabled value="">Choose a <?php echo ( isset($CLIENTREF) ? rtrim(trim($CLIENTREF), "s") : 'Client ' ); ?></option>
								   <option selected value="<?php echo $uClientID; ?>"><?php echo getClientName($uClientID); ?></option>
							</select>
							<label  for="clientID"><?php echo ( isset($CLIENTREF) ? rtrim(trim($CLIENTREF), "s") : 'Client ' ); ?> Name</label>
							<div class="invalid-feedback">
								Please select a <?php echo ( isset($CLIENTREF) ? rtrim(trim($CLIENTREF), "s") : 'Client ' ); ?> Name.
							</div>
					  	</div>
					</div>
					
					<div class="col-md-4 position-relative">
						<div class="form-floating mt-3">
							<select class="form-select js-select" name="medID" id="medID" aria-label="Medication Name" required>
								  <option selected disabled value="">Choose a Medication</option>
								  <option value="-1">New Medication</option>
								  <?php 
								  	
								  	for ( $i = 0; $i < count($meds); $i++ ) { 
									$medSelected = ( $meds[$i]['MedID'] == $medRec[0]['MedID'] ) ? " SELECTED " : "";
								  ?>
										<option value="<?php echo $meds[$i]['MedID']; ?>" <?php echo $medSelected ?>><?php echo $meds[$i]['MedName']; ?></option>
								 <?php } ?>
								 </optgroup>
							</select>
							<label  for="medID">Medication Name</label>
							<div class="invalid-feedback">
								Please select a Medication Name.
							</div>
					  	</div>
					</div>
					
			</div>
						
			<div class="row assignnewmedrow">
					<div class="col-md-4  position-relative assignnewmedrow float-start">
						<div class="form-floating mt-3">
							<input type="text" class="form-control" name="newmedname" id="newmedname" placeholder="New Medication Name"  >
							<label  for="newmedname">New Medication Name</label>
							<div class="invalid-feedback">
								Please provide the New Medication Name.
							</div>
					  	</div>
					</div>
					<div class="col-md-4 position-relative assignnewmedrow float-start">
						<div class="form-floating mt-3">
							<input type="text" class="form-control" name="reason" id="reason" placeholder="Reason for Taking Medication"  >
							<label  for="reason">Reason for Taking Medication</label>
							<div class="invalid-feedback">
								Please provide the Reason for Taking Medication.
							</div>
					  	</div>
					</div>
					<div class="col-md-4 position-relative assignnewmedrow float-start">
						<div class="form-floating mt-3">
							<input type="text" class="form-control" name="sideeffects" id="sideeffects" placeholder="Possible Side Effects"  />
							<label  for="sideeffects">Possible Side Effects</label>
							<div class="invalid-feedback">
								Please provide the Possible Side Effects.
							</div>
					  	</div>
					</div>
			</div>
						
			<div class="row">
					<div class="col-md-3 position-relative">
						<div class="form-floating mt-3">
							<select class="form-select js-select" name="medtype" id="medtype" aria-label="a Medication Type" required>
								  <option selected disabled value="">Choose a Medication Type</option>
								  <?php 
								  	for ( $i = 0; $i < count($medtypes); $i++ ) { 
									
										$selected = ( $medtypes[$i]['MedTypeID'] == $medRec[0]['MedType'] ) ? " SELECTED " : "";
								  ?>
										<option value="<?php echo $medtypes[$i]['MedTypeID']; ?>" <?php echo $selected; ?>><?php echo $medtypes[$i]['MedTypeName']; ?></option>
								 <?php } ?>
							</select>
							<label  for="medtype">Service Program Name</label>
							<div class="invalid-feedback">
								Please select a Medication Type.
							</div>
					  	</div>
					</div>
					
					<div class="col-md-2">
						<div class="form-floating mt-3 input-group" id='div_prescribedt' data-td-target-input='nearest' data-td-target-toggle='nearest'>
							<input type="text" class="form-control d-md-inline-block" name="prescribedt" id="prescribedt" placeholder="Prescription Date"  data-td-target='#div_prescribedt'  value="<?php echo $medRec[0]['PrescriptionDate']; ?>" required />
							  <label   class="form-label" for="prescribedt">Prescription Date</label>
							  <span class='input-group-text' data-td-target='#div_prescribedt' data-td-toggle='datetimepicker'>
								 <span class='bi bi-calendar-date fs-3'></span>
							  </span>
							  <div class="invalid-feedback">
								Please provide a Prescription Date.
							  </div>
					  	</div>
					</div>
					
					<div class="col-md-2">
						<div class="form-floating mt-3 input-group" id='div_medstartdt' data-td-target-input='nearest' data-td-target-toggle='nearest'>
							<input type="text" class="form-control d-md-inline-block" name="medstartdt" id="medstartdt" placeholder="Med Start Date"  data-td-target='#div_medstartdt'  value="<?php echo $medRec[0]['StartDate']; ?>" required />
							  <label   class="form-label" for="medstartdt">Med Start Date</label>
							  <span class='input-group-text' data-td-target='#div_medstartdt' data-td-toggle='datetimepicker'>
								 <span class='bi bi-calendar-date fs-3'></span>
							  </span>
							  <div class="invalid-feedback">
								Please provide a Medication Start Date.
							  </div>
					  	</div>
					</div>
					
					
					<div class="col-md-2">
						<div class="form-floating mt-3 input-group" id='div_medtime' data-td-target-input='nearest' data-td-target-toggle='nearest'>
							<input type="text" class="form-control d-md-inline-block" name="medtime" id="medtime" placeholder="Medication Time"  data-td-target='#div_medtime'  value="<?php echo $medRec[0]['MedTime']; ?>" required />
							  <label   class="form-label" for="medtime">Medication Time</label>
							  <span class='input-group-text' data-td-target='#div_medtime' data-td-toggle='datetimepicker'>
								 <span class='bi bi-clock fs-4'></span>
							  </span>
							  <div class="invalid-feedback">
								Please provide a Medication Time.
							  </div>
					  	</div>
					</div>
					
					<div class="col-md-3 position-relative">
						<div class="form-floating mt-3">
							<?php
								$statSelelcted = array( 'New' => '', 'Current' => '', 'Increased' => '', 'Decreased' => '' );
								$statSelelcted[$medRec[0]['MedStatus']] = " selected ";
							?>
							<select class="form-select js-select" name="medstatus" id="medstatus" aria-label="Medication Status" required>
								  <option selected disabled value="">Choose a Medication Status</option>
								   <option value="New" <?php echo $statSelelcted['New']; ?>>New</option>
								   <option value="Current" <?php echo $statSelelcted['Current']; ?>>Current</option>
								   <option value="Increased" <?php echo $statSelelcted['Increased']; ?>>Increased</option>
								   <option value="Decreased" <?php echo $statSelelcted['Decreased']; ?>>Decreased</option>
							</select>
							<label  for="medstatus">Medication Status</label>
							<div class="invalid-feedback">
								Please select a Medication Status.
							</div>
					  </div>
				</div>					
			</div>
			
			<div class="row">
					<div class="col-md-3 position-relative">
						<div class="form-floating mt-3">
							<input type="text" class="form-control" name="meddose" id="meddose" placeholder="Medication Dosage" value="<?php echo $medRec[0]['MedDosage']; ?>" required >
							<label  for="meddose">Medication Dosage</label>
							<div class="invalid-feedback">
								Please provide the Medication Dosage.
							</div>
					  	</div>
					</div>
					
					<div class="col-md-9 position-relative">
						<div class="form-floating mt-3">
							<input type="text" class="form-control" name="meddirection" id="meddirection" placeholder="Medication Directions" value="<?php echo $medRec[0]['Direction']; ?>" required >
						<label  for="meddirection">Medication Directions</label>
						<div class="invalid-feedback">
							Please provide the Directions.
						</div>
					  	</div>
					</div>
					
			</div>
				
								
			<div class="text-center mt-5 mb-5">
					<input type="hidden" name="clientTag" id="clientTag" value="<?php echo ( isset($CLIENTREF) ? rtrim(trim($CLIENTREF), "s") : 'Client ' ); ?>" />
					<input type="hidden" name="updmedparms" id="updmedparms" value="<?php echo $updmedparms; ?>" />
                   <button type="submit" id="configureit" class="btn btn-primary mt-3 configbtn" name="submit"><?php echo $ADMIN_BREADCRUMB[$dest]; ?></button>
				   <button type="reset" class="btn btn-secondary mt-3 configbtn" name="btnreset">Start Over</button>
              </div>	
 			</div>
	   </div>
		
</form>
	
<?php
	}
?>