<?php

// Include the PhpSpreadsheet library
require $_SERVER['DOCUMENT_ROOT'] . '/assets/vendor/autoload.php'; // Assuming you've installed PhpSpreadsheet via Composer

use PhpOffice\PhpSpreadsheet\Reader\Xlsx;

// Connect to MySQL database
$mysqli = loginToDB();

$query  = "SET foreign_key_checks = 0";
$statement = mysqli_prepare($mysqli, $query);
mysqli_stmt_execute($statement);
	
// Keep track of errors
$clienterrors = $serviceerrors = $houseerrors = $clientserviceserrors = "";

// Check connection
if (mysqli_connect_errno()) {
    $errors .= "DB Connection failed: " . mysqli_connect_error();
	$fileUploadError = 1;
}

if ( ! file_exists($_SERVER['DOCUMENT_ROOT'] . '/clients-online-files/' . $_SERVER['SERVER_NAME'] . '.files/load-tables/DailyAttendance.xlsx') ) {
	$fileUploadError = 1;
	$errors .= "<br>The Attendance data file was not found. <br>";
	if ( $mysqli ) {
		closeDB( $mysqli );
	}
}

if ( $fileUploadError == 0 ) {

	// Path to your Excel file
	$excelFile = $_SERVER['DOCUMENT_ROOT'] . '/clients-online-files/' . $_SERVER['SERVER_NAME'] . '.files/load-tables/DailyAttendance.xlsx';
		
	// Load the Excel file
	$reader = new Xlsx();
	$spreadsheet = $reader->load($excelFile);
	
	// Set the active sheet to the second sheet
	$spreadsheet->setActiveSheetIndex(1);
	
	// Get the active sheet
	$sheet = $spreadsheet->getActiveSheet();
	$highestRow = $sheet->getHighestRow(); // e.g. 10
		
	if ( ! mysqli_begin_transaction( $mysqli, MYSQLI_TRANS_START_READ_WRITE ) ) {
		
		$errors .= "<br>There was an error loading Daily Attendance data to the database. Error Message: " . mysqli_error($mysqli) . "<br>";
		$fileUploadError = 1;
		closeDB( $mysqli );	
	}
	else {
		$isFail = 0;	
		for ($row = 2; $row <= $highestRow; $row++ ) {
						
			$ServiceDate = $sheet->getCellByColumnAndRow(1, $row)->getFormattedValue();
			$earray = explode("/", $ServiceDate );
			if ( isset($earray) && count($earray) < 3 ) { continue; }
			$dbDate =   $earray[2] . '-' . $earray[0] . '-' . $earray[1];
			
			$ClientLtssID = trim($sheet->getCellByColumnAndRow(2, $row)->getFormattedValue());
			$ClientName = $sheet->getCellByColumnAndRow(3, $row)->getCalculatedValue();
			
			$ProviderNo = $sheet->getCellByColumnAndRow(4, $row)->getCalculatedValue();
			
			$Service = $sheet->getCellByColumnAndRow(5, $row)->getCalculatedValue();
			
			$servicename = preg_split('/\d+: /', $Service)[1];
			
			$noRetainerFee = '';
			if ( str_contains($servicename, "Retainer Fee") ) {
			
				$servicename = preg_replace("/Retainer Fee/i", "", $servicename); // Case-insensitive removal				
				$noRetainerFee = " AND ( LOWER(`Name`) not like '%retainer fee' ) ";
			}
			$servicecode = preg_split('/: /', $Service)[0];
			$Units = $sheet->getCellByColumnAndRow(6, $row)->getCalculatedValue();
			
			// Get the Day Month and Year
			list( $month, $day, $year ) = explode("/", $ServiceDate );
			
			// Get First Name and Last Name
			list( $firstName, $lastName ) = explode( ", ", $ClientName );
			
			// Get Service ID from database
			$query = "SELECT `ServiceID` FROM `ServicesProvidedLkup` WHERE ( '" . strtolower(trim($servicename)) . "' = LOWER(`Name`) or LOWER(`Code`) = '" . strtolower($servicecode) . "' ) " . $noRetainerFee;
			
			$result = mysqli_query( $mysqli, $query  );
			if (( mysqli_errno($mysqli) != 0 ) || (mysqli_num_rows($result) == 0)  || (mysqli_num_rows($result) > 1) ) {
				$serviceerrors .= "<br>Row " . $row . ": ServiceID for " . trim($Service) . " Not found for " . trim($ClientName);
				$isFail = 1;
				continue;
			}
			else {
				$scvrow = mysqli_fetch_assoc( $result );
				$ServiceID = $scvrow['ServiceID'];
			}
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
			
			// Get Client ID from database
			//$query = "SELECT `ClientID` FROM Clients WHERE CONCAT( LOWER(TRIM(`ClientLname`)), ', ', LOWER(TRIM(`ClientFname`))) = LOWER('" . $ClientName . "')";
			$query = "SELECT `ClientID` FROM `Clients` WHERE `ClientLtssID` = '" . trim($ClientLtssID) . "'";
			$cresult = mysqli_query( $mysqli, $query  );
			
			if (( mysqli_errno($mysqli) != 0 ) || (mysqli_num_rows($cresult) == 0)  || (mysqli_num_rows($cresult) > 1) ) {
				$clienterrors .= "<br>Row " . $row . ": Client ID for " . trim($ClientName) . " Not found.";
				$isFail = 1;
				continue;
			}
			else {
				$clirow = mysqli_fetch_assoc( $cresult );
				$ClientID = $clirow['ClientID'];
			}
			
			if ( isset( $cresult ) && is_object( $cresult ) ) { mysqli_free_result( $cresult ); }
			
			// Get House ID from database
			$query = "SELECT `HouseID` FROM `Houses` WHERE `ProviderMA` = '" . trim($ProviderNo) . "'";
			$cresult = mysqli_query( $mysqli, $query  );
			
			if (( mysqli_errno($mysqli) != 0 ) || (mysqli_num_rows($cresult) == 0) ) {
				$clienterrors .= "<br>Row # " . $row . ": House ID for " . trim($ClientName) . " Not found.";
				$isFail = 1;
				continue;
			}
			else if ( mysqli_num_rows($cresult) > 1 ) {
				if ( preg_match('/PERSONAL SUPPORT|EMPLOYMENT SERVICES/', strtoupper($Service)) ) {
					// Get House ID from database
					$query = "SELECT MIN(`HouseID`) as HouseID FROM `Houses` WHERE `ProviderMA` = '" . trim($ProviderNo) . "'";			
					$cresult = mysqli_query( $mysqli, $query  );
					
					if (( mysqli_errno($mysqli) != 0 ) || (mysqli_num_rows($cresult) == 0) ) {
						$clienterrors .= "<br>Row # " . $row . ": House ID for " . trim($ClientName) . " Not found.";
						$isFail = 1;
						$HouseID = 'N/A';
						continue;
					}
					else {
						$clirow = mysqli_fetch_assoc( $cresult );
						$HouseID = $clirow['HouseID'];
					}
				}
			}
			else {
				$clirow = mysqli_fetch_assoc( $cresult );
				$HouseID = $clirow['HouseID'];
			}
			
			if ( isset( $cresult ) && is_object( $cresult ) ) { mysqli_free_result( $cresult ); }
			
			
			// Get Client Services ID from database
			$query = "SELECT `ClientServicesID` FROM `ClientServices` WHERE `ClientID` = " . $ClientID . " and `ServiceID` = " . $ServiceID . " and HouseID = " . $HouseID . " and '" . $dbDate . "' between `StartDate` and `EndDate`;
";
			$csresult = mysqli_query( $mysqli, $query  );
			
			if (( mysqli_errno($mysqli) != 0 ) || (mysqli_num_rows($csresult) == 0)  || (mysqli_num_rows($csresult) > 1) ) {
				$clientserviceserrors .= "<br>Row " . $row . ": Client Services ID for " . trim($ClientName) . " Not found  for service " . trim($Service) . " for date " . $ServiceDate;
				$isFail = 1;
				continue;
			}
			else {
				$csrow = mysqli_fetch_assoc( $csresult );
				$ClientServicesID = $csrow['ClientServicesID'];
			}
			
			// Determine Units
			if ( ! in_array( $ServiceID, $PERSONAL_SUPPORTS ) ) {
				$Units = 1;
			}
			
			// Insert into Daily Attendance	
			$query = "INSERT INTO `DailyAttendance`(`Month`, `Year`, `D" . ltrim(trim($day), "0") . "`, `MonthlyTotal`, `ClientID`, `ClientServicesID`) VALUES( ";
			$query .= ltrim(trim($month), "0") . ", " . $year  . ", " . $Units  . ", " . $Units  . ", " . $ClientID . ", " . $ClientServicesID ;
			$query .= " ) ";
			if ( in_array(	$ServiceID, $PERSONAL_SUPPORTS ) ) {		
				$query .= " ON DUPLICATE KEY UPDATE `D" . ltrim(trim($day), "0") . "`=`D" . ltrim(trim($day), "0") . "` + " . $Units . ", `MonthlyTotal`=`MonthlyTotal`+ " . $Units;
			}
			else {
				$query .= " ON DUPLICATE KEY UPDATE `D" . ltrim(trim($day), "0") . "`=" . $Units . ", `MonthlyTotal`=`MonthlyTotal`+ " . $Units;
			}

			
			$cresult = mysqli_query( $mysqli, $query  );
			
			if (( mysqli_errno($mysqli) != 0 ) ) {
				/*
				if ( ! in_array(	$ServiceID, $PERSONAL_SUPPORTS ) ) {
					$query = "UPDATE `DailyAttendance` set `D" . ltrim(trim($day), "0") . "`=`D" . ltrim(trim($day), "0") . "` + " . $Units . ", `MonthlyTotal`=`MonthlyTotal`+ " . $Units;
					$query .= " WHERE  `Month`=" . ltrim(trim($month), "0") . " AND `Year`=" . $year . " AND `ClientID`=" . $ClientID . " AND `ClientServicesID`=" . $ClientServicesID . " AND `D" . ltrim(trim($day), "0") . "`=0";
					$cresult = mysqli_query( $mysqli, $query  );
			
					if (( mysqli_errno($mysqli) != 0 ) ) {
						$attendanceerrors .= "<br>Unable to save Attendance for " . trim($ClientName) . " for service " . trim($Service);
						if ( isset( $cresult ) && is_object( $cresult ) ) { mysqli_free_result( $cresult ); }
						$isFail = 1;
						continue;
					}
					
				}
				else {
				*/
					$attendanceerrors .= "<br>Row " . $row . ": Unable to save Attendance for " . trim($ClientName) . " for service " . trim($Service);
					if ( isset( $cresult ) && is_object( $cresult ) ) { mysqli_free_result( $cresult ); }
					$isFail = 1;
					continue;
				//}
			}
			
			if ( isset( $cresult ) && is_object( $cresult ) ) { mysqli_free_result( $cresult ); }
			
		}
	}
	
	if ( $fileUploadError == 0 ) {
		/* If code reaches this point without errors then commit the data in the database */
		mysqli_commit($mysqli);
		
		// enable foreign key checks
		//$query  = "SET foreign_key_checks = 1";
		//$statement = mysqli_prepare($mysqli, $query);
		//mysqli_stmt_execute($statement);
		
		$attendanceerrors .= " Attendance data was successfully loaded to the database. <br>";
		//closeDB( $mysqli );
	}
	$query  = "SET foreign_key_checks = 1";
	$statement = mysqli_prepare($mysqli, $query);
	mysqli_stmt_execute($statement);
	closeDB( $mysqli );

}
?>

