<?php

// Include the PhpSpreadsheet library
require $_SERVER['DOCUMENT_ROOT'] . '/assets/vendor/autoload.php'; // Assuming you've installed PhpSpreadsheet via Composer

use PhpOffice\PhpSpreadsheet\Reader\Xlsx;
use PhpOffice\PhpSpreadsheet\IOFactory;

	
// Connect to MySQL database
$mysqli = loginToDB();

$query  = "SET foreign_key_checks = 0";
$statement = mysqli_prepare($mysqli, $query);
mysqli_stmt_execute($statement);

// Keep track of errors
$clienterrors = $serviceerrors = $clientserviceserrors = "";

// Check connection
if (mysqli_connect_errno()) {
    $errors .= "DB Connection failed: " . mysqli_connect_error();
	$fileUploadError = 1;
}

if ( ! file_exists($_SERVER['DOCUMENT_ROOT'] . '/clients-online-files/' . $_SERVER['SERVER_NAME'] . '.files/load-tables/ClientServices.xlsx') ) {
	$fileUploadError = 1;
	$errors .= "<br>The Client Services data file was not found. <br>";
	if ( $mysqli ) {
		closeDB( $mysqli );
	}
}

if ( $fileUploadError == 0 ) {
	
	// Path to your Excel file
	$excelFile = $_SERVER['DOCUMENT_ROOT'] . '/clients-online-files/' . $_SERVER['SERVER_NAME'] . '.files/load-tables/ClientServices.xlsx';
	

	
	
	// Load the Excel file
	$reader = new Xlsx();
	$spreadsheet = $reader->load($excelFile);	
	
	// Set the active sheet to the second sheet
	$spreadsheet->setActiveSheetIndex(0);

	// Get the active sheet
	$sheet = $spreadsheet->getActiveSheet();
	$highestRow = $sheet->getHighestRow(); // e.g. 10
	
	if ( ! mysqli_begin_transaction( $mysqli, MYSQLI_TRANS_START_READ_WRITE ) ) {
		
		$errors .= "<br>There was an error loading Client Services data to the database. Error Message: " . mysqli_error($mysqli) . "<br>";
		$fileUploadError = 1;
		closeDB( $mysqli );	
	}
	else {
		$isFail = 0;	
				
		for ($row = 2; $row <= $highestRow; $row++ ) {
			
			$clientLtssID = trim($sheet->getCellByColumnAndRow(1, $row)->getFormattedValue());	
			$clientName = trim($sheet->getCellByColumnAndRow(2, $row)->getFormattedValue());
			$location = trim($sheet->getCellByColumnAndRow(3, $row)->getFormattedValue());
			$startDate = trim($sheet->getCellByColumnAndRow(4, $row)->getFormattedValue());	
			$endDate = trim($sheet->getCellByColumnAndRow(5, $row)->getFormattedValue());
			$clientPCPDate = trim($sheet->getCellByColumnAndRow(6, $row)->getFormattedValue());				
			$service = trim($sheet->getCellByColumnAndRow(7, $row)->getFormattedValue());
			
			if ( trim($clientLtssID) == '' ) {
				$clienterrors .= "<br>Row # " . ($row + 6)  . ":  Invalid Client Data, as client LTSS ID is blank.";
				$isFail = 1;
				continue;
			}
			
			if ( trim($location) == '' ) {
				$clienterrors .= "<br>Row # " . ($row + 6)  . ":  Invalid Location Data, as Location is blank.";
				$isFail = 1;
				continue;
			}
			
			if ( trim($service) == '' ) {
				$clienterrors .= "<br>Row # " . ($row + 6)  . ":  Invalid Service Data, as Service is blank.";
				$isFail = 1;
				continue;
			}
			
			if ( trim($startDate) == '' ) {
				$clienterrors .= "<br>Row # " . ($row + 6)  . ":  Invalid Start Date Data, as Start Date is blank.";
				$isFail = 1;
				continue;
			}
			
			if ( trim($endDate) == '' ) {
			
				$pcpdate = DateTime::createFromFormat('m/d/Y', trim($clientPCPDate) ); // Create DateTime object
				$pcpdate->modify('-1 day'); // Subtract one day
				$endDate = $pcpdate->format('m/d/Y');
			}

			// Get Client ID from database
			$query = "SELECT `ClientID` FROM `Clients` WHERE `ClientLtssID` = '" . trim($clientLtssID) . "'";
			$cresult = mysqli_query( $mysqli, $query  );
			
			if (( mysqli_errno($mysqli) != 0 ) || (mysqli_num_rows($cresult) == 0)  || (mysqli_num_rows($cresult) > 1) ) {
				$clienterrors .= "<br>Row # " . ($row + 6)  . ": Client ID for " . trim($clientName) . " Not found.";
				$isFail = 1;
				continue;
			}
			else {
				$clirow = mysqli_fetch_assoc( $cresult );
				$ClientID = $clirow['ClientID'];
			}
			if ( isset( $cresult ) && is_object( $cresult ) ) { mysqli_free_result( $cresult ); }
						
			// Get House ID from database
			$query = "SELECT `HouseID` FROM `Houses` WHERE `ProviderMA` = '" . trim($location) . "'";					
			$cresult = mysqli_query( $mysqli, $query  );
			
			if (( mysqli_errno($mysqli) != 0 ) || (mysqli_num_rows($cresult) == 0) ) {
				$clienterrors .= "<br>Row # " . ($row + 6)  . ": House ID for " . trim($clientName) . " Not found.";
				$isFail = 1;
				continue;
			}
			else if ( mysqli_num_rows($cresult) > 1 ) {
				if ( preg_match('/PERSONAL SUPPORT|EMPLOYMENT SERVICES/', strtoupper($service)) ) {
					// Get House ID from database
					$query = "SELECT MIN(`HouseID`) as HouseID FROM `Houses` WHERE `ProviderMA` = '" . trim($location) . "'";						
					$cresult = mysqli_query( $mysqli, $query  );
					
					if (( mysqli_errno($mysqli) != 0 ) || (mysqli_num_rows($cresult) == 0) ) {
						$clienterrors .= "<br>Row # " . ($row + 6)  . ": House ID for " . trim($clientName) . " Not found.";
						$isFail = 1;
						$HouseID = 'N/A';
						continue;
					}
					else {
						$clirow = mysqli_fetch_assoc( $cresult );
						$HouseID = $clirow['HouseID'];
					}
				}
			}
			else {
				$clirow = mysqli_fetch_assoc( $cresult );
				$HouseID = $clirow['HouseID'];
			}
			if ( isset( $cresult ) && is_object( $cresult ) ) { mysqli_free_result( $cresult ); }
						
			// Get Service ID from database
			$query = "SELECT `ServiceID` FROM `ServicesProvidedLkup` WHERE '" . strtolower(trim($service)) . "' = LOWER(`Name`)";
			$SubServiceID = 'NULL';
			$result = mysqli_query( $mysqli, $query  );

			if (( mysqli_errno($mysqli) != 0 ) || (mysqli_num_rows($result) > 1) ) {
				$serviceerrors .= "<br>Row # " . ($row + 6)  . ": ServiceID for " . trim($service) . " Not found for " . trim($clientName);
				$isFail = 1;
				continue;
			}
			else if ( mysqli_num_rows($result) == 0 ) {
			
				if ( preg_match('/DAY HABILITATION GROUPS/', strtoupper($service)) ) {
					$ServiceID = 24;  //  Day Habilitation Small Group (2-5)
				}
			}
			else {
				$scvrow = mysqli_fetch_assoc( $result );
				$ServiceID = $scvrow['ServiceID'];
				
				if ( $ServiceID == COMMUNITY_LIVING_GROUP_HOME ) {
					$SubServiceID = ( isset($_REQUEST['residents'][$HouseID]) ) ? $_REQUEST['residents'][$HouseID] : '';
				}
				
				if ( trim($SubServiceID) == '' ) {
					$SubServiceID = 'NULL';
				}
			}
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
						
			if ( trim($startDate) == '' ) {
				$clientserviceserrors .= "<br>Row # " . ($row + 6)  . ": Service Start Date for client " . trim($clientName) . " and service " . trim($service) . " is blank. RECORD SKIPPED";
				$isFail = 1;
				continue;
			}
			
			if ( ( trim($endDate) == '' ) && ( trim($clientPCPDate) == '' ) ) {
				$clientserviceserrors .= "<br>Row # " . ($row + 6)  . ": Service End Date for client " . trim($clientName) . " and service " . trim($service) . " is blank. RECORD SKIPPED";
				$isFail = 1;
				continue;
			}
			
			$dbUnixDate = DateTime::createFromFormat('m/d/Y', '01/01/1970' );
						
			// Keep current Start Date
			$planStartDate = $startDate;
			
			$defaultDate = DateTime::createFromFormat('m/d/Y', '03/01/2023' );
			$startDate = DateTime::createFromFormat('m/d/Y', trim($startDate));
			$planDate = DateTime::createFromFormat('m/d/Y', trim($clientPCPDate));
			$endDate = DateTime::createFromFormat('m/d/Y', trim($endDate));
			
					
			$comparisonDate = DateTime::createFromFormat('m/d/Y', '03/01/2023');
			$oneYearBeforePlan = clone $planDate;
			$oneYearBeforePlan->modify('-1 year');
		
			$dbEndDate = $dbUnixDate;
			
			if ($startDate < $comparisonDate) {
				$startDate = clone $defaultDate;
			}
			elseif ($startDate > $comparisonDate) {
			
				$query = "SELECT IFNULL( MAX(EndDate), '1970-01-01' ) as  EndDate FROM `ClientServices` WHERE `ClientID`=" . $ClientID . " AND `ServiceID`="; ;
				$query .= "" . $ServiceID . " AND `HouseID`=" . $HouseID . " AND ( `SubServiceID` is NULL or `SubServiceID`= " . $SubServiceID . " )" ;
				
				$result = mysqli_query( $mysqli, $query  );
				if ( mysqli_errno($mysqli) != 0 ) {
					continue;
				}
				else {
					$scvrow = mysqli_fetch_assoc( $result );
					$dbEndDate = $scvrow['EndDate'];
					$dbEndDate = DateTime::createFromFormat('Y-m-d', $dbEndDate );
					
					if ( $dbEndDate ==  $dbUnixDate ) { 
						// do nothing and leave startdate alone;
					}
					else {
						//$startDate = (DateTime::createFromFormat('m/d/Y', trim($planStartDate)))->format('Y-m-d');
						//$previousStartDate = $planStartDate;
					}
				}
			}
			
			if ($endDate < $comparisonDate) {
				continue;
			}
			
			$startDate = $startDate->format('Y-m-d');
			$defaultDate = $defaultDate->format('Y-m-d');
			$planDate = $planDate->format('Y-m-d');
			$endDate = $endDate->format('Y-m-d');
			
			// Verify that the ClientService does not exist be for inserting
			//			
			// Get Service ID from database
			$query = "SELECT count(*) as NumSvcs FROM `ClientServices` WHERE `ClientID`=" . $ClientID . " AND `ServiceID`= " . $ServiceID . " ";
			$query .= " AND `StartDate`= '" . $startDate . "' AND `EndDate`= '" . $endDate . "' AND `HouseID`=" . $HouseID ;
						
			$result = mysqli_query( $mysqli, $query  );
			if ( mysqli_errno($mysqli) != 0 ) {
				continue;
			}
			else {
				$scvrow = mysqli_fetch_assoc( $result );
				if ( $scvrow['NumSvcs'] > 0 ) {
					continue;
				}
			}
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }

			$query = "INSERT INTO `ClientServices`(`ClientID`, `ServiceID`, `SubServiceID`, `StartDate`, `EndDate`, `HouseID` ) VALUES ( ";
			$query .=  $ClientID . ", " . $ServiceID . ", " . $SubServiceID . ", '" . $startDate . "', '" . $endDate . "', " . $HouseID . " ) ";	
								
			$result = mysqli_query( $mysqli, $query  );
			if (( mysqli_errno($mysqli) != 0 ) ) {
				$clientserviceserrors .= "<br>Row # " . ($row + 6)  . ": Unable to save Client Service ( " . trim($service) . " )  for " . trim($clientName);
				$isFail = 1;
				continue;
			}
			
			if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }			
			
		}
	}
	
	if ( $fileUploadError == 0 ) {
		/* If code reaches this point without errors then commit the data in the database */
		mysqli_commit($mysqli);
		
		// enable foreign key checks
		$query  = "SET foreign_key_checks = 1";
		$statement = mysqli_prepare($mysqli, $query);
		mysqli_stmt_execute($statement);
		
		$attendanceerrors .= " Client Services data was successfully loaded to the database. <br>";
		closeDB( $mysqli );
	}
}

/*
// Get endDate if there is a recored with the same ClientID, ServiceID, startDate and HouseID
$query = "SELECT count(*) as  NumSvcs FROM `ClientServices` WHERE `ClientID`=" . $ClientID . " AND `ServiceID`= " . $ServiceID . " ";
$query .= " AND `StartDate`= '" . $startDate . "' AND `HouseID`=" . $HouseID . " AND ( `SubServiceID` is NULL or `SubServiceID`= " . $SubServiceID . " )" ;
			
$result = mysqli_query( $mysqli, $query  );
if ( mysqli_errno($mysqli) != 0 ) {
	continue;
}
else {
	$scvrow = mysqli_fetch_assoc( $result );
	if ( $scvrow['NumSvcs'] > 0 ) {
							
		// check End Date to include end date
		$query = "SELECT count(*) as  NumSvcs FROM `ClientServices` WHERE `ClientID`=" . $ClientID . " AND `ServiceID`= " . $ServiceID . " ";
$query .= " AND `EndDate`= '" . $endDate . "' AND `HouseID`=" . $HouseID . " AND ( `SubServiceID` is NULL or `SubServiceID`= " . $SubServiceID . " )" ;
		$result = mysqli_query( $mysqli, $query  );
		if ( mysqli_errno($mysqli) != 0 ) {
			continue;
		}
		else {
			$scvrow = mysqli_fetch_assoc( $result );
			if ( $scvrow['NumSvcs'] > 0 ) { 
				continue;
			}
			else {
				$startDate = (DateTime::createFromFormat('m/d/Y', trim($planStartDate)))->format('Y-m-d');
				$previousStartDate = $planStartDate;
			}
		}
	}
}
if ( isset( $result ) && is_object( $result ) ) { mysqli_free_result( $result ); }
*/
			
?>

