<?php

	// Include the PhpSpreadsheet library
	require $_SERVER['DOCUMENT_ROOT'] . '/assets/vendor/autoload.php'; // Assuming you've installed PhpSpreadsheet via Composer
	
	use PhpOffice\PhpSpreadsheet\IOFactory;
	use PhpOffice\PhpSpreadsheet\Reader\Xlsx;
	use PhpOffice\PhpSpreadsheet\Spreadsheet;
	
	// Path to your Excel file
	$excelFile = $_SERVER['DOCUMENT_ROOT'] . '/clients-online-files/' . $_SERVER['SERVER_NAME'] . '.files/load-tables/DirtyClientServices.xlsx';
	
	// Path to your Excel file
	$cleanExcelFile = $_SERVER['DOCUMENT_ROOT'] . '/clients-online-files/' . $_SERVER['SERVER_NAME'] . '.files/load-tables/ClientServices.xlsx';
	
	// Load the spreadsheet
	$reader = new Xlsx();
	$spreadsheet = $reader->load($excelFile);
	
	// Set the active sheet to the second sheet
	$spreadsheet->setActiveSheetIndex(1);
	
	// Remove the first sheet
	$spreadsheet->removeSheetByIndex(0);

	// Select the active sheet (or a specific sheet)
	$sheet = $spreadsheet->getActiveSheet(0);
	
	// Delete the first 6 rows
	$sheet->removeRow(1, 4); // Start at row 1, remove 6 rows

	// Get highest row and column indices
	$highestRow = $sheet->getHighestRow();
	$highestColumn = $sheet->getHighestColumn();
	$highestColumnIndex = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::columnIndexFromString($highestColumn);
		
	// Step 1: Remove Rows with All Empty Cells
	$rowsToKeep = [];
	for ($row = 1; $row <= $highestRow; $row++) {
		$isRowEmpty = true;
		for ($col = 1; $col <= $highestColumnIndex; $col++) {
			$cellValue = trim($sheet->getCellByColumnAndRow($col, $row)->getFormattedValue());
			if ($cellValue !== '') {
				$isRowEmpty = false;
				break;
			}
		}
		if (!$isRowEmpty) {
			$rowsToKeep[] = $row;
		}
	}
	//echo dpp($rowsToKeep);
	
	// Step 2: Remove Columns with All Empty Cells
	$colsToKeep = [];
	for ($col = 1; $col <= $highestColumnIndex; $col++) {
		$isColEmpty = true;
		for ($row = 1; $row <= $highestRow; $row++) {
			$cellValue = trim($sheet->getCellByColumnAndRow($col, $row)->getFormattedValue());
			if ($cellValue !== '') {
				$isColEmpty = false;
				break;
			}
		}
		if (!$isColEmpty) {
			$colsToKeep[] = $col;
		}
	}
	//echo dpp($colsToKeep);
	
	/* =================================================================================================
	$spreadsheet = \PhpOffice\PhpSpreadsheet\IOFactory::load($excelFile);

	// PhpSpreadsheet uses zero-based index for sheets
	$sheet = $spreadsheet->getSheet(0); // 0 = Sheet1, 1 = Sheet2

	$requiredHeaders = ['ClientID', 'ClientName', 'ProviderLocationNumnbrer'];

	// Get range for header rows (5 and 6)
	$headerRow1 = 1;
	$headerRow2 = 2;
	$highestColumn = $sheet->getHighestColumn();
	
	$row5 = $sheet->rangeToArray("A{$headerRow1}:{$highestColumn}{$headerRow1}", null, true, false)[0];
	$row6 = $sheet->rangeToArray("A{$headerRow2}:{$highestColumn}{$headerRow2}", null, true, false)[0];
	echo dpp($row5);
	echo dpp($row6);
	
	// Merge headers into a single label
	$mergedHeaders = [];
	foreach ($row6 as $index => $subHeader) {
		$mainHeader = isset($row5[$index]) ? trim($row5[$index]) : '';
		$subHeader = trim($subHeader);
		//$label = trim($mainHeader . ' - ' . $subHeader, ' -');
		$label = str_replace( " ", "", trim($mainHeader . $subHeader, ' -') );
		$mergedHeaders[$index] = $label;
	}
	echo dpp($mergedHeaders);
	
	// Map required headers to their column indexes (by checking only the final part)
	$headerMap = [];
	foreach ($mergedHeaders as $index => $headerLabel) {
		foreach ($requiredHeaders as $required) {
			if (stripos($headerLabel, $required) !== false) {
				$headerMap[$required] = $index;
			}
		}
	}
	
	echo dpp($headerMap);
	
	$data = [];
	$startRow = 7;
	$highestRow = $sheet->getHighestRow();
	
	for ($row = $startRow; $row <= $highestRow; $row++) {
		$rowValues = $sheet->rangeToArray("A{$row}:{$highestColumn}{$row}", null, true, false)[0];
		$entry = [];
	
		foreach ($requiredHeaders as $header) {
			$index = $headerMap[$header] ?? null;
			$entry[$header] = $index !== null ? $rowValues[$index] ?? null : null;
		}
	
		$data[] = $entry;
	}

	echo dpp($data);
	//print_r($data);

	exit;
	//=============================================================================
	*/
	
	// Step 3: Extract and Reconstruct Data without Blank Rows and Columns
	$data = [];
	foreach ($rowsToKeep as $rowIndex) {
		$rowData = [];
		foreach ($colsToKeep as $colIndex) {
			$rowData[] = $sheet->getCellByColumnAndRow($colIndex, $rowIndex)->getFormattedValue();
		}
		$data[] = $rowData;
	}
	
	// combine row 1 and row 2
	$combinedHeader = [];
	for ($i = 0; $i < count($data[0]); $i++) {
		$combinedHeader[] = str_replace( " ", "", trim($data[0][$i]) . trim($data[1][$i]) );
	}
	
	$newarray = [];
	$newarray[] = $combinedHeader;

	for ($i = 2; $i < count($data); $i++) {
		$newarray[] = $data[$i];
	}
	
	//echo dpp($newarray[0]);

	$headersToKeep  = ['ClientID', 'ClientName', 'ProviderLocationNumber', 'PlanEffectiveDate', 'PlanEndDate', 'AnnualPCPDate', 'ServicePlanService' ];
	
	// Step 1: Map header names to their indexes
	$header = $newarray[0];
	$indexesToKeep = [];
	
	foreach ($header as $index => $columnName) {
		if (in_array($columnName, $headersToKeep)) {
			$indexesToKeep[] = $index;
		}
	}
	
	// Step 2: Filter all rows to keep only those indexes
	$filteredArray = [];
	
	foreach ($newarray as $row) {
		$filteredRow = [];
		foreach ($indexesToKeep as $i) {
			$filteredRow[] = $row[$i];
		}
		$filteredArray[] = $filteredRow;
	}
	
	//echo dpp($filteredArray);
	
	$data = $filteredArray;
	
	$endDateKey = array_search('PlanEndDate', $data[0]);
	$pcpDateKey = array_search('AnnualPCPDate', $data[0]);
	
	for( $i = 0; $i < count($data); $i++ )
	{
		if ( trim($data[$i][$endDateKey]) == '' ) 
		{				
			$pcpdate = DateTime::createFromFormat('m/d/Y', trim($data[$i][$pcpDateKey]) ); // Create DateTime object
			$pcpdate->modify('-1 day'); // Subtract one day
			$data[$i][$endDateKey] = $pcpdate->format('m/d/Y');
		}
	}
	
	$sortKey1 = array_search('ClientID', $data[0]);
	$sortKey2 = array_search('ServicePlanService', $data[0]);
	$sortKey3 = array_search('ProviderLocationNumber', $data[0]);
	$sortKey4 = array_search('PlanEffectiveDate', $data[0]);
	$sortKey5 = array_search('PlanEndDate', $data[0]);
	
	// Step 1: Extract header and data
	$header = $data[0];
	$sortArray = array_slice($data, 1);

	// Step 4: Sort Data on Three Columns (e.g., first, second, and third columns)
	usort($sortArray, function ($a, $b) use ($sortKey1, $sortKey2, $sortKey3, $sortKey4, $sortKey5) {
		return $a[$sortKey1] <=> $b[$sortKey1] ?: $a[$sortKey2] <=> $b[$sortKey2] ?: $a[$sortKey3] <=> $b[$sortKey3] ?: strtotime($a[$sortKey4]) <=> strtotime($b[$sortKey4]) ?: strtotime($a[$sortKey5]) <=> strtotime($b[$sortKey5]); // Adjust indexes as needed
	});
	
	// Step 3: Reattach header
	$data = array_merge([$header], $sortArray);
	
	$saveKey1 = array_search('ClientID', $data[0]);
	$saveKey2 = array_search('ClientName', $data[0]);
	$saveKey3 = array_search('ProviderLocationNumber', $data[0]);
	$saveKey4 = array_search('PlanEffectiveDate', $data[0]);
	$saveKey5 = array_search('PlanEndDate', $data[0]);
	$saveKey6 = array_search('AnnualPCPDate', $data[0]);
	$saveKey7 = array_search('ServicePlanService', $data[0]);
	
	$uniqueData = []; // Store unique rows
	
	//echo dpp($data);
	foreach( $data as $dataKey => $dataValues ){
		$uniqueData[] = trim($dataValues[$saveKey1]) . "|" . trim($dataValues[$saveKey2]) . "|" . trim($dataValues[$saveKey3]) . "|" . trim($dataValues[$saveKey4]) . "|" . trim($dataValues[$saveKey5]) . "|" . trim($dataValues[$saveKey6]) . "|" . trim($dataValues[$saveKey7]); 
	}
	
	// Create a new spreadsheet
	$newSpreadsheet = new Spreadsheet();
	$newSheet = $newSpreadsheet->getActiveSheet();
	
	// Remove duplicates
	$uniqueData = array_values( array_unique($uniqueData));
		
	// Write unique data to new spreadsheet
	$newRowIndex = 1;
	foreach ($uniqueData as $rowString) {
		$rowValues = explode('|', $rowString);
				
		$newColumnIndex = 1;
		
		foreach ($rowValues as $value) {
		
			$newSheet->setCellValueByColumnAndRow($newColumnIndex, $newRowIndex, $value);
			$newColumnIndex++;
		}
		$newRowIndex++;
	}
	
	// Save the modified file
	$writer = IOFactory::createWriter($newSpreadsheet, 'Xlsx');
	$writer->save($cleanExcelFile);
	
	//echo "Blank rows/columns removed and data sorted successfully!";

?>

