<?php

	// Include the PhpSpreadsheet library
	require $_SERVER['DOCUMENT_ROOT'] . '/assets/vendor/autoload.php'; // Assuming you've installed PhpSpreadsheet via Composer
	
	use PhpOffice\PhpSpreadsheet\IOFactory;
	use PhpOffice\PhpSpreadsheet\Reader\Xlsx;
	use PhpOffice\PhpSpreadsheet\Spreadsheet;
	
	// Path to your Excel file
	$excelFile = $_SERVER['DOCUMENT_ROOT'] . '/clients-online-files/' . $_SERVER['SERVER_NAME'] . '.files/load-tables/DirtyDailyAttendance.xlsx';
	
	// Path to your Excel file
	$cleanExcelFile = $_SERVER['DOCUMENT_ROOT'] . '/clients-online-files/' . $_SERVER['SERVER_NAME'] . '.files/load-tables/DailyAttendance.xlsx';
	
	// Load the spreadsheet
	$reader = new Xlsx();
	$spreadsheet = $reader->load($excelFile);
	
	// Set the active sheet to the second sheet
	$spreadsheet->setActiveSheetIndex(1);
	
	// Remove the first sheet
	$spreadsheet->removeSheetByIndex(0);

	// Select the active sheet (or a specific sheet)
	$sheet = $spreadsheet->getActiveSheet(0);
	
	// Delete the first 6 rows
	$sheet->removeRow(1, 4); // Start at row 1, remove 6 rows

	// Get highest row and column indices
	$highestRow = $sheet->getHighestRow();
	$highestColumn = $sheet->getHighestColumn();
	$highestColumnIndex = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::columnIndexFromString($highestColumn);
		
	// Step 1: Remove Rows with All Empty Cells
	$rowsToKeep = [];
	for ($row = 1; $row <= $highestRow; $row++) {
		$isRowEmpty = true;
		for ($col = 1; $col <= $highestColumnIndex; $col++) {
			$cellValue = trim($sheet->getCellByColumnAndRow($col, $row)->getFormattedValue());
			if ($cellValue !== '') {
				$isRowEmpty = false;
				break;
			}
		}
		if (!$isRowEmpty) {
			$rowsToKeep[] = $row;
		}
	}
	
	// Step 2: Remove Columns with All Empty Cells
	$colsToKeep = [];
	for ($col = 1; $col <= $highestColumnIndex; $col++) {
		$isColEmpty = true;
		for ($row = 1; $row <= $highestRow; $row++) {
			$cellValue = trim($sheet->getCellByColumnAndRow($col, $row)->getFormattedValue());
			if ($cellValue !== '') {
				$isColEmpty = false;
				break;
			}
		}
		if (!$isColEmpty) {
			$colsToKeep[] = $col;
		}
	}
	
	// Step 3: Extract and Reconstruct Data without Blank Rows and Columns
	$data = [];
	foreach ($rowsToKeep as $rowIndex) {
		$rowData = [];
		foreach ($colsToKeep as $colIndex) {
			$rowData[] = $sheet->getCellByColumnAndRow($colIndex, $rowIndex)->getFormattedValue();
		}
		$data[] = $rowData;
	}
	
	// combine row 1 and row 2
	$combinedHeader = [];
	for ($i = 0; $i < count($data[0]); $i++) {
		$combinedHeader[] = str_replace( " ", "", trim($data[0][$i]) );
	}
	
	$newarray = [];
	$newarray[] = $combinedHeader;

	for ($i = 2; $i < count($data); $i++) {
		$newarray[] = $data[$i];
	}
	
	//echo dpp($newarray[0]);

	$headersToKeep  = array_map( 'strtoupper', ['ServiceDate', 'ClientID', 'ClientName', 'Provider#', 'Service', 'TotalUnits' ]);
	
	// Step 1: Map header names to their indexes
	$header = $newarray[0];
	$indexesToKeep = [];
	
	foreach ($header as $index => $columnName) {
		if (in_array(strtoupper($columnName), $headersToKeep)) {
			$indexesToKeep[] = $index;
		}
	}
	
	// Step 2: Filter all rows to keep only those indexes
	$filteredArray = [];
	
	foreach ($newarray as $row) {
		$filteredRow = [];
		foreach ($indexesToKeep as $i) {
			$filteredRow[] = $row[$i];
		}
		$filteredArray[] = $filteredRow;
	}
		
	$data = $filteredArray;
	$data[0] = array_map('strtoupper', $data[0] );
		
	$sortKey1 = array_search(strtoupper('ServiceDate'), $data[0]);
	$sortKey2 = array_search(strtoupper('ClientID'), $data[0]);
	
	// Step 1: Extract header and data
	$header = $data[0];
	$sortArray = array_slice($data, 1);

	// Step 4: Sort Data on Three Columns (e.g., first, second, and third columns)
	usort($sortArray, function ($a, $b) use ($sortKey1, $sortKey2 ) {
		return $a[$sortKey1] <=> $b[$sortKey1] ?: $a[$sortKey2] <=> $b[$sortKey2]; // Adjust indexes as needed
	});
	
	// Step 3: Reattach header
	$data = array_merge([$header], $sortArray);
	
	$headersToKeep  = ['ServiceDate', 'ClientID', 'ClientName', 'Provider#', 'Service', 'TotalUnits' ];
	
	$saveKey1 = array_search(strtoupper('ServiceDate'), $data[0]);
	$saveKey2 = array_search(strtoupper('ClientID'), $data[0]);
	$saveKey3 = array_search(strtoupper('ClientName'), $data[0]);
	$saveKey4 = array_search(strtoupper('Provider#'), $data[0]);
	$saveKey5 = array_search(strtoupper('Service'), $data[0]);
	$saveKey6 = array_search(strtoupper('TotalUnits'), $data[0]);
		
	$uniqueData = []; // Store unique rows
		
	foreach( $data as $dataKey => $dataValues ){
		$uniqueData[] = trim($dataValues[$saveKey1]) . "|" . trim($dataValues[$saveKey2]) . "|" . trim($dataValues[$saveKey3]) . "|" . trim($dataValues[$saveKey4]) . "|" . trim($dataValues[$saveKey5]) . "|" . trim($dataValues[$saveKey6]); 		
	}
	
	// Create a new spreadsheet
	$newSpreadsheet = new Spreadsheet();
	$newSheet = $newSpreadsheet->getActiveSheet();
	
	// Remove duplicates
	$uniqueData = array_values( array_unique($uniqueData));
		
	// Write unique data to new spreadsheet
	$newRowIndex = 1;
	foreach ($uniqueData as $rowString) {
		$rowValues = explode('|', $rowString);
				
		$newColumnIndex = 1;
		
		foreach ($rowValues as $value) {
		
			$newSheet->setCellValueByColumnAndRow($newColumnIndex, $newRowIndex, $value);
			$newColumnIndex++;
		}
		$newRowIndex++;
	}
	
	// Save the modified file
	$writer = IOFactory::createWriter($newSpreadsheet, 'Xlsx');
	$writer->save($cleanExcelFile);
	
	//echo "Blank rows/columns removed and data sorted successfully!";

?>

